/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.archiver;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import jp.sourceforge.jindolf.archiver.VillageData;
import jp.sourceforge.jindolf.archiver.Win31j;
import jp.sourceforge.jindolf.corelib.LandDef;
import jp.sourceforge.jindolf.parser.DecodeErrorInfo;
import jp.sourceforge.jindolf.parser.DecodedContent;

public final class XmlUtils {
    public static final String ORIG_DTD = "http://jindolf.sourceforge.jp/xml/dtd/bbsArchive-110420.dtd";
    public static final String ORIG_NS = "http://jindolf.sourceforge.jp/xml/ns/501";
    public static final String ORIG_SCHEME = "http://jindolf.sourceforge.jp/xml/xsd/bbsArchive-110420.xsd";
    public static final String SCHEMA_NS = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String OUTPATH = "D:\\TEMP\\zxzx\\";
    private static final String INDENT_UNIT = "  ";
    private static final TimeZone TZ_TOKYO = TimeZone.getTimeZone("Asia/Tokyo");
    private static final GregorianCalendar calendar = new GregorianCalendar(TZ_TOKYO);

    public static void dumpDocType(Writer writer) throws IOException {
        writer.append("<!DOCTYPE village SYSTEM ");
        writer.append('\"');
        writer.append(ORIG_DTD);
        writer.append('\"');
        writer.append(" >");
    }

    public static void dumpNameSpaceDecl(Writer writer) throws IOException {
        XmlUtils.attrOut(writer, "xmlns", ORIG_NS);
    }

    public static void dumpSiNameSpaceDecl(Writer writer) throws IOException {
        XmlUtils.attrOut(writer, "xmlns:xsi", SCHEMA_NS);
    }

    public static void dumpSchemeLocation(Writer writer) throws IOException {
        XmlUtils.attrOut(writer, "xsi:schemaLocation", "http://jindolf.sourceforge.jp/xml/ns/501 http://jindolf.sourceforge.jp/xml/xsd/bbsArchive-110420.xsd");
    }

    public static void indent(Writer writer, int level) throws IOException {
        for (int ct = 1; ct <= level; ++ct) {
            writer.append(INDENT_UNIT);
        }
    }

    public static void charRefOut(Writer writer, char chVal) throws IOException {
        if (chVal == ' ') {
            writer.append("&#x20;");
            return;
        }
        if (chVal == '\t') {
            writer.append("&#x09;");
            return;
        }
        int ival = 0xFFFF & chVal;
        String hex = Integer.toHexString(ival);
        if (hex.length() % 2 != 0) {
            hex = "0" + hex;
        }
        writer.append("&#x");
        writer.append(hex);
        writer.append(";");
    }

    public static void dumpInvalidChar(Writer writer, char chVal) throws IOException {
        int hexVal = chVal & 0xFF;
        String hexBin = Integer.toHexString(hexVal);
        if (hexBin.length() % 2 != 0) {
            hexBin = "0" + hexBin;
        }
        char replaceChar = '\ufffd';
        if ('\u0000' <= chVal && chVal <= '\u001f') {
            replaceChar = (char)(chVal + 9216);
        }
        writer.append("<rawdata");
        writer.append(' ');
        XmlUtils.attrOut(writer, "encoding", "Shift_JIS");
        writer.append(' ');
        XmlUtils.attrOut(writer, "hexBin", hexBin);
        writer.append(" >");
        writer.append(replaceChar);
        writer.append("</rawdata>");
    }

    public static boolean isWhiteSpace(char chVal) {
        switch (chVal) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    public static void textOut(Writer writer, CharSequence seq) throws IOException {
        int len = seq.length();
        boolean leadSpace = false;
        for (int pos = 0; pos < len; ++pos) {
            char chVal = seq.charAt(pos);
            if (XmlUtils.isWhiteSpace(chVal)) {
                if (pos == 0 || pos >= len - 1 || leadSpace) {
                    XmlUtils.charRefOut(writer, chVal);
                } else if (chVal != ' ') {
                    XmlUtils.charRefOut(writer, chVal);
                } else {
                    writer.append(chVal);
                }
                leadSpace = true;
                continue;
            }
            if (chVal == '&') {
                writer.append("&amp;");
            } else if (chVal == '<') {
                writer.append("&lt;");
            } else if (chVal == '>') {
                writer.append("&gt;");
            } else if (chVal == '\"') {
                writer.append("&quot;");
            } else if (chVal == '\'') {
                writer.append("&apos;");
            } else if (chVal == '\\') {
                writer.append('\u00a5');
            } else if (chVal == '~') {
                writer.append('\u203e');
            } else if (Character.isISOControl(chVal)) {
                XmlUtils.dumpInvalidChar(writer, chVal);
            } else {
                writer.append(chVal);
            }
            leadSpace = false;
        }
    }

    public static void attrOut(Writer writer, CharSequence name, CharSequence value) throws IOException {
        StringBuilder newValue = new StringBuilder(value);
        for (int pt = 0; pt < newValue.length(); ++pt) {
            char chVal = newValue.charAt(pt);
            if (chVal == '\n' || chVal == '\r' || chVal == '\t' || !Character.isISOControl(chVal)) continue;
            newValue.setCharAt(pt, (char)(9216 + chVal));
        }
        writer.append(name);
        writer.append('=');
        writer.append('\"');
        XmlUtils.textOut(writer, newValue);
        writer.append('\"');
    }

    public static void timeAttrOut(Writer writer, CharSequence name, int hour, int minute) throws IOException {
        String cmtTime = MessageFormat.format("{0,number,#00}:{1,number,#00}:00+09:00", hour, minute);
        XmlUtils.attrOut(writer, name, cmtTime);
    }

    public static void dateAttrOut(Writer writer, CharSequence name, int month, int day) throws IOException {
        String dateAttr = MessageFormat.format("--{0,number,#00}-{1,number,#00}+09:00", month, day);
        XmlUtils.attrOut(writer, name, dateAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dateTimeAttr(Writer writer, CharSequence name, long epochMs) throws IOException {
        GregorianCalendar gregorianCalendar = calendar;
        synchronized (gregorianCalendar) {
            calendar.setTimeInMillis(epochMs);
            int year = calendar.get(1);
            int month = calendar.get(2) + 1;
            int day = calendar.get(5);
            int hour = calendar.get(11);
            int minute = calendar.get(12);
            int sec = calendar.get(13);
            int msec = calendar.get(14);
            String attrVal = MessageFormat.format("{0,number,#0000}-{1,number,#00}-{2,number,#00}T{3,number,#00}:{4,number,#00}:{5,number,#00}.{6,number,#000}+09:00", year, month, day, hour, minute, sec, msec);
            XmlUtils.attrOut(writer, name, attrVal);
        }
    }

    public static void dumpErrorInfo(Writer writer, DecodeErrorInfo errorInfo) throws IOException {
        String hexBin;
        int hexVal = errorInfo.getRawByte1st() & 0xFF;
        if (errorInfo.has2nd()) {
            hexVal <<= 8;
            hexVal |= errorInfo.getRawByte2nd() & 0xFF;
        }
        if ((hexBin = Integer.toHexString(hexVal)).length() % 2 != 0) {
            hexBin = "0" + hexBin;
        }
        char replaceChar = Win31j.getWin31jChar(errorInfo);
        writer.append("<rawdata");
        writer.append(' ');
        XmlUtils.attrOut(writer, "encoding", "Shift_JIS");
        writer.append(' ');
        XmlUtils.attrOut(writer, "hexBin", hexBin);
        writer.append(" >");
        writer.append(replaceChar);
        writer.append("</rawdata>");
    }

    public static void dumpDecodedContent(Writer writer, DecodedContent content) throws IOException {
        if (!content.hasDecodeError()) {
            XmlUtils.textOut(writer, content);
            return;
        }
        int last = 0;
        List<DecodeErrorInfo> errList = content.getDecodeErrorList();
        for (DecodeErrorInfo err : errList) {
            int charPos = err.getCharPosition();
            CharSequence line = content.subSequence(last, charPos);
            XmlUtils.textOut(writer, line);
            XmlUtils.dumpErrorInfo(writer, err);
            last = charPos + 1;
        }
        CharSequence line = content.subSequence(last, content.length());
        XmlUtils.textOut(writer, line);
    }

    public static void dumpVillageData(Writer writer, VillageData villageData) throws IOException {
        writer.append("<?xml");
        writer.append(' ');
        XmlUtils.attrOut(writer, "version", "1.0");
        writer.append(' ');
        XmlUtils.attrOut(writer, "encoding", "UTF-8");
        writer.append(" ?>\n\n");
        writer.append("<!--\n");
        writer.append("  \u4eba\u72fcBBS\u30a2\u30fc\u30ab\u30a4\u30d6\n");
        writer.append("  http://jindolf.sourceforge.jp/\n");
        writer.append("-->\n\n");
        XmlUtils.dumpDocType(writer);
        writer.append("\n\n");
        villageData.dumpXml(writer);
        writer.append("\n<!-- EOF -->\n");
        writer.flush();
    }

    public static String createOutFileName(VillageData village) {
        LandDef landDef = village.getLandDef();
        String landId = landDef.getLandId();
        int vid = village.getVillageId();
        String fname = MessageFormat.format("{0}jin_{1}_{2,number,#00000}.xml", OUTPATH, landId, vid);
        return fname;
    }

    public static Writer createFileWriter(VillageData village) throws IOException {
        String fname = XmlUtils.createOutFileName(village);
        File file = new File(fname);
        OutputStream ostream = new FileOutputStream(file);
        ostream = new BufferedOutputStream(ostream, 10000);
        Writer writer = new OutputStreamWriter(ostream, "UTF-8");
        writer = new BufferedWriter(writer, 10000);
        return writer;
    }

    private XmlUtils() {
        throw new Error();
    }
}

