/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.jindolf.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Anchor {
    private static final int EPILOGUEDAY = 99;
    private static final Pattern ANCHOR_PATTERN;
    private final CharSequence source;
    private final int startPos;
    private final int endPos;
    private final int day;
    private final int hour;
    private final int minute;
    private final int talkNo;

    private Anchor(CharSequence source, int startPos, int endPos, int talkNo) {
        if (talkNo <= 0) {
            throw new IllegalArgumentException();
        }
        this.source = source;
        this.startPos = startPos;
        this.endPos = endPos;
        this.day = -1;
        this.hour = -1;
        this.minute = -1;
        this.talkNo = talkNo;
    }

    private Anchor(CharSequence source, int startPos, int endPos, int day, int hour, int minute) {
        this.source = source;
        this.startPos = startPos;
        this.endPos = endPos;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.talkNo = -1;
    }

    public static Anchor getAnchor(CharSequence source, int regionStart, int regionEnd, int currentDay) {
        Matcher matcher = ANCHOR_PATTERN.matcher(source);
        matcher.region(regionStart, regionEnd);
        if (!matcher.find()) {
            return null;
        }
        Anchor anchor = Anchor.getAnchorFromMatched(source, matcher, currentDay);
        return anchor;
    }

    public static List<Anchor> getAnchorList(CharSequence source, int currentDay) {
        LinkedList<Anchor> result = new LinkedList<Anchor>();
        Matcher matcher = ANCHOR_PATTERN.matcher(source);
        int regionEnd = source.length();
        while (matcher.find()) {
            Anchor anchor = Anchor.getAnchorFromMatched(source, matcher, currentDay);
            result.add(anchor);
            int regionStart = matcher.end();
            matcher.region(regionStart, regionEnd);
        }
        return result;
    }

    private static Anchor getAnchorFromMatched(CharSequence source, Matcher matcher, int currentDay) {
        int minuteGroup;
        int hourGroup;
        int startPos = matcher.start();
        int endPos = matcher.end();
        if (matcher.start(14) < matcher.end(14)) {
            int talkNo = StringUtils.parseInt(source, matcher, 14);
            Anchor anchor = new Anchor(source, startPos, endPos, talkNo);
            return anchor;
        }
        int day = currentDay;
        if (matcher.start(1) < matcher.end(1)) {
            if (matcher.start(2) < matcher.end(2)) {
                day = 0;
            } else if (matcher.start(3) < matcher.end(3)) {
                day = 99;
            } else if (matcher.start(4) < matcher.end(4)) {
                day = StringUtils.parseInt(source, matcher, 4);
            } else {
                assert (false);
                return null;
            }
        }
        boolean isPM = false;
        if (matcher.start(5) < matcher.end(5)) {
            if (matcher.start(6) < matcher.end(6)) {
                isPM = false;
            } else if (matcher.start(7) < matcher.end(7)) {
                isPM = true;
            } else {
                assert (false);
                return null;
            }
        }
        if (matcher.start(8) < matcher.end(8)) {
            hourGroup = 9;
            minuteGroup = 10;
        } else if (matcher.start(11) < matcher.end(11)) {
            hourGroup = 12;
            minuteGroup = 13;
        } else {
            assert (false);
            return null;
        }
        int hour = StringUtils.parseInt(source, matcher, hourGroup);
        int minute = StringUtils.parseInt(source, matcher, minuteGroup);
        if (isPM && hour < 12) {
            hour += 12;
        }
        Anchor anchor = new Anchor(source, startPos, endPos, day, hour %= 24, minute);
        return anchor;
    }

    public CharSequence getSource() {
        return this.source;
    }

    public int getStartPos() {
        return this.startPos;
    }

    public int getEndPos() {
        return this.endPos;
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getTalkNo() {
        return this.talkNo;
    }

    public boolean hasTalkNo() {
        return 0 < this.talkNo;
    }

    public boolean isEpilogueDay() {
        return this.day >= 99;
    }

    public String toString() {
        if (this.hasTalkNo()) {
            return ">>" + this.talkNo;
        }
        StringBuilder result = new StringBuilder();
        result.append(this.getDay()).append('d');
        int anchorHour = this.getHour();
        if (anchorHour < 10) {
            result.append('0');
        }
        result.append(anchorHour).append(':');
        int anchorMinute = this.getMinute();
        if (anchorMinute < 10) {
            result.append('0');
        }
        result.append(anchorMinute);
        return result.toString();
    }

    static {
        String spchar = " \u3000\\t";
        String sp = "[" + spchar + "]";
        String sp_n = "(?:" + sp + "|" + "(?:\\Q&nbsp;\\E)" + ")*?";
        String day = "((?:(\u30d7\u30ed(?:\u30ed\u30fc\u30b0)?)|(\u30a8\u30d4(?:\u30ed\u30fc\u30b0)?)|(?:([1-9\uff11-\uff19]?[0-9\uff10-\uff19])" + sp_n + "(?:[dD\uff44\uff24]|(?:\u65e5\u76ee?))" + ")" + ")" + "[\\-\\[\\(/_\uff0d\u30fc\u2015\uff3b\uff3f]?" + sp_n + ")?";
        String ampm = "((?:((?:[aA\uff41\uff21][\\.\uff0e]?[mM\uff4d\uff2d][\\.\uff0e]?)|(?:\u5348\u524d))|((?:[pP\uff50\uff30][\\.\uff0e]?[mM\uff4d\uff2d][\\.\uff0e]?)|(?:\u5348\u5f8c)))" + sp_n + ")?";
        String hhmm = "(?:(([0-2\uff10-\uff12]?[0-9\uff10-\uff19])" + sp_n + "[:;\uff1a\uff1b]?" + sp_n + "([0-5\uff10-\uff15][0-9\uff10-\uff19])" + ")" + "|" + "(" + "([0-2\uff10-\uff12]?[0-9\uff10-\uff19])" + sp_n + "\u6642" + sp_n + "([0-5\uff10-\uff15]?[0-9\uff10-\uff19])" + sp_n + "\u5206" + ")" + ")";
        String talkNum = "(?:>>([1-9][0-9]{0,8}))";
        ANCHOR_PATTERN = Pattern.compile(day + ampm + hhmm + "|" + talkNum, 32);
    }
}

