/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import jp.sourceforge.jindolf.Jindolf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CmdOption {
    OPT_HELP("help", "h", "-help", "?"),
    OPT_VERSION("version"),
    OPT_BOLDMETAL("boldMetal"),
    OPT_NOSPLASH("nosplash"),
    OPT_GEOMETRY("geometry"),
    OPT_VMINFO("vminfo"),
    OPT_CONSOLELOG("consolelog"),
    OPT_INITFONT("initfont"),
    OPT_ANTIALIAS("antialias"),
    OPT_FRACTIONAL("fractional"),
    OPT_CONFDIR("confdir"),
    OPT_NOCONF("noconfdir");

    private final List<String> nameList = new LinkedList<String>();

    private CmdOption(CharSequence ... names) {
        if (names == null) {
            throw new NullPointerException();
        }
        if (names.length <= 0) {
            throw new IllegalArgumentException();
        }
        for (CharSequence name : names) {
            if (name == null) {
                throw new NullPointerException();
            }
            this.nameList.add(((Object)name).toString().intern());
        }
    }

    public static CmdOption parseCmdOption(CharSequence seq) {
        for (CmdOption option : CmdOption.values()) {
            if (!option.matchHyphened(seq)) continue;
            return option;
        }
        return null;
    }

    public static boolean isIndepOption(CmdOption option) {
        switch (option) {
            case OPT_HELP: 
            case OPT_VERSION: 
            case OPT_VMINFO: 
            case OPT_BOLDMETAL: 
            case OPT_NOSPLASH: 
            case OPT_CONSOLELOG: 
            case OPT_NOCONF: {
                return true;
            }
        }
        return false;
    }

    public static boolean isBooleanOption(CmdOption option) {
        switch (option) {
            case OPT_ANTIALIAS: 
            case OPT_FRACTIONAL: {
                return true;
            }
        }
        return false;
    }

    public static CharSequence getHelpText() {
        CharSequence helpText;
        try {
            helpText = Jindolf.loadResourceText("resources/help.txt");
        }
        catch (IOException e) {
            helpText = "";
        }
        return helpText;
    }

    public String toString() {
        return this.nameList.get(0);
    }

    public String toHyphened() {
        return "-" + this.toString();
    }

    public boolean matchHyphened(CharSequence option) {
        if (option == null) {
            return false;
        }
        for (String name : this.nameList) {
            String hyphened = "-" + name;
            if (!hyphened.equals(((Object)option).toString())) continue;
            return true;
        }
        return false;
    }
}

