/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Handler;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.TreePath;
import jp.sourceforge.jindolf.AccountPanel;
import jp.sourceforge.jindolf.ActionManager;
import jp.sourceforge.jindolf.Anchor;
import jp.sourceforge.jindolf.AnchorHitEvent;
import jp.sourceforge.jindolf.AnchorHitListener;
import jp.sourceforge.jindolf.AppSetting;
import jp.sourceforge.jindolf.CsvExporter;
import jp.sourceforge.jindolf.DaySummary;
import jp.sourceforge.jindolf.DialogPref;
import jp.sourceforge.jindolf.Discussion;
import jp.sourceforge.jindolf.FilterPanel;
import jp.sourceforge.jindolf.FindPanel;
import jp.sourceforge.jindolf.FontInfo;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.HelpFrame;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.Land;
import jp.sourceforge.jindolf.LandsModel;
import jp.sourceforge.jindolf.LandsTree;
import jp.sourceforge.jindolf.LogFrame;
import jp.sourceforge.jindolf.OptionPanel;
import jp.sourceforge.jindolf.Period;
import jp.sourceforge.jindolf.PeriodView;
import jp.sourceforge.jindolf.PileHandler;
import jp.sourceforge.jindolf.ProxyInfo;
import jp.sourceforge.jindolf.RegexPattern;
import jp.sourceforge.jindolf.ServerAccess;
import jp.sourceforge.jindolf.StringUtils;
import jp.sourceforge.jindolf.TabBrowser;
import jp.sourceforge.jindolf.Talk;
import jp.sourceforge.jindolf.TalkDraw;
import jp.sourceforge.jindolf.TalkPreview;
import jp.sourceforge.jindolf.TopView;
import jp.sourceforge.jindolf.Village;
import jp.sourceforge.jindolf.VillageDigest;
import jp.sourceforge.jindolf.WebIPCDialog;
import jp.sourceforge.jindolf.corelib.LandDef;
import jp.sourceforge.jindolf.corelib.VillageState;

public class Controller
implements ActionListener,
TreeWillExpandListener,
TreeSelectionListener,
ChangeListener,
AnchorHitListener {
    private final ActionManager actionManager;
    private final TopView topView;
    private final LandsModel model;
    private final FilterPanel filterFrame;
    private final LogFrame showlogFrame;
    private final OptionPanel optionPanel;
    private final FindPanel findPanel;
    private final TalkPreview talkPreview;
    private JFrame helpFrame;
    private AccountPanel accountFrame;
    private DaySummary daySummaryPanel;
    private VillageDigest digestPanel;
    private final Map<Window, Boolean> windowMap = new HashMap<Window, Boolean>();
    private volatile boolean isBusyNow;
    private JFrame topFrame = null;

    public Controller(ActionManager actionManager, TopView topView, LandsModel model) {
        this.actionManager = actionManager;
        this.topView = topView;
        this.model = model;
        JToolBar toolbar = this.actionManager.getBrowseToolBar();
        this.topView.setBrowseToolBar(toolbar);
        this.actionManager.addActionListener(this);
        JTree treeView = this.topView.getTreeView();
        treeView.setModel(this.model);
        treeView.addTreeWillExpandListener(this);
        treeView.addTreeSelectionListener(this);
        this.topView.getTabBrowser().addChangeListener(this);
        this.topView.getTabBrowser().addActionListener(this);
        this.topView.getTabBrowser().addAnchorHitListener(this);
        JButton reloadVillageListButton = this.topView.getLandsTree().getReloadVillageListButton();
        reloadVillageListButton.addActionListener(this);
        reloadVillageListButton.setEnabled(false);
        this.filterFrame = new FilterPanel(this.topFrame);
        this.filterFrame.addChangeListener(this);
        this.filterFrame.pack();
        this.filterFrame.setVisible(false);
        this.showlogFrame = new LogFrame(this.topFrame);
        this.showlogFrame.pack();
        this.showlogFrame.setSize(600, 500);
        this.showlogFrame.setLocationByPlatform(true);
        this.showlogFrame.setVisible(false);
        if (Jindolf.hasLoggingPermission()) {
            Handler[] handlers;
            Handler newHandler = this.showlogFrame.getHandler();
            Logger jre14Logger = Jindolf.logger().getJre14Logger();
            jre14Logger.addHandler(newHandler);
            for (Handler handler : handlers = jre14Logger.getHandlers()) {
                if (!(handler instanceof PileHandler)) continue;
                PileHandler pile = (PileHandler)handler;
                pile.delegate(newHandler);
                pile.close();
            }
        }
        this.talkPreview = new TalkPreview();
        this.talkPreview.pack();
        this.talkPreview.setSize(700, 500);
        this.talkPreview.setVisible(false);
        this.talkPreview.loadDraft();
        this.optionPanel = new OptionPanel(this.topFrame);
        this.optionPanel.pack();
        this.optionPanel.setSize(450, 500);
        this.optionPanel.setVisible(false);
        this.findPanel = new FindPanel(this.topFrame);
        this.findPanel.pack();
        this.findPanel.setVisible(false);
        this.findPanel.loadHistory();
        this.windowMap.put(this.filterFrame, true);
        this.windowMap.put(this.showlogFrame, false);
        this.windowMap.put(this.talkPreview, false);
        this.windowMap.put(this.optionPanel, false);
        this.windowMap.put(this.findPanel, true);
        AppSetting setting = Jindolf.getAppSetting();
        FontInfo fontInfo = setting.getFontInfo();
        this.topView.getTabBrowser().setFontInfo(fontInfo);
        this.talkPreview.setFontInfo(fontInfo);
        this.optionPanel.getFontChooser().setFontInfo(fontInfo);
        ProxyInfo proxyInfo = setting.getProxyInfo();
        this.optionPanel.getProxyChooser().setProxyInfo(proxyInfo);
        DialogPref pref = setting.getDialogPref();
        this.topView.getTabBrowser().setDialogPref(pref);
        this.optionPanel.getDialogPrefPanel().setDialogPref(pref);
    }

    public JFrame createTopFrame() {
        this.topFrame = new JFrame();
        Container content = this.topFrame.getContentPane();
        BorderLayout layout = new BorderLayout();
        content.setLayout(layout);
        content.add((Component)this.topView, "Center");
        JComponent glassPane = new JComponent(){};
        glassPane.addMouseListener(new MouseAdapter(){});
        glassPane.addKeyListener(new KeyAdapter(){});
        this.topFrame.setGlassPane(glassPane);
        this.topFrame.setJMenuBar(this.actionManager.getMenuBar());
        this.setFrameTitle(null);
        this.windowMap.put(this.topFrame, false);
        this.topFrame.setDefaultCloseOperation(2);
        this.topFrame.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent event) {
                Controller.this.shutdown();
            }
        });
        return this.topFrame;
    }

    private void actionAbout() {
        String message = Jindolf.TITLE + "   Version " + Jindolf.VERSION + "\n" + Jindolf.COPYRIGHT + "\n" + "\u30e9\u30a4\u30bb\u30f3\u30b9: " + Jindolf.LICENSE + "\n" + "\u9023\u7d61\u5148: " + Jindolf.CONTACT;
        if (Jindolf.COMMENT.length() > 0) {
            message = message + "\n" + Jindolf.COMMENT;
        }
        JOptionPane pane = new JOptionPane(message, 1, -1, GUIUtils.getLogoIcon());
        JDialog dialog = pane.createDialog(this.topFrame, Jindolf.TITLE + "\u306b\u3064\u3044\u3066");
        dialog.pack();
        dialog.setVisible(true);
        dialog.dispose();
    }

    private void actionExit() {
        this.shutdown();
    }

    private void actionHelp() {
        if (this.helpFrame != null) {
            this.toggleWindow(this.helpFrame);
            return;
        }
        this.helpFrame = new HelpFrame();
        this.helpFrame.pack();
        this.helpFrame.setSize(450, 450);
        this.windowMap.put(this.helpFrame, false);
        this.helpFrame.setVisible(true);
    }

    private void actionShowWebVillage() {
        TabBrowser browser = this.topView.getTabBrowser();
        Village village = browser.getVillage();
        if (village == null) {
            return;
        }
        Land land = village.getParentLand();
        ServerAccess server = land.getServerAccess();
        URL url = server.getVillageURL(village);
        String urlText = url.toString();
        if (village.getState() != VillageState.GAMEOVER) {
            urlText = urlText + "#bottom";
        }
        WebIPCDialog.showDialog(this.topFrame, urlText);
    }

    private void actionShowWebWiki() {
        String villageName;
        TabBrowser browser = this.topView.getTabBrowser();
        Village village = browser.getVillage();
        if (village == null) {
            return;
        }
        LandDef landDef = village.getParentLand().getLandDef();
        if (landDef.getLandId().equals("wolfg")) {
            String vnum = "000" + village.getVillageID();
            vnum = vnum.substring(vnum.length() - 3);
            villageName = landDef.getLandPrefix() + vnum;
        } else {
            villageName = village.getVillageName();
        }
        StringBuilder url = new StringBuilder().append("http://wolfbbs.jp/").append(villageName).append("%C2%BC.html");
        WebIPCDialog.showDialog(this.topFrame, url.toString());
    }

    private void actionShowWebCast() {
        TabBrowser browser = this.topView.getTabBrowser();
        Village village = browser.getVillage();
        if (village == null) {
            return;
        }
        Land land = village.getParentLand();
        ServerAccess server = land.getServerAccess();
        URL villageUrl = server.getVillageURL(village);
        StringBuilder url = new StringBuilder("http://hon5.com/jinro/");
        try {
            url.append("?u=").append(URLEncoder.encode(villageUrl.toString(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return;
        }
        url.append("&s=1");
        WebIPCDialog.showDialog(this.topFrame, url.toString());
    }

    private void actionShowWebDay() {
        PeriodView periodView = this.currentPeriodView();
        if (periodView == null) {
            return;
        }
        Period period = periodView.getPeriod();
        if (period == null) {
            return;
        }
        TabBrowser browser = this.topView.getTabBrowser();
        Village village = browser.getVillage();
        if (village == null) {
            return;
        }
        Land land = village.getParentLand();
        ServerAccess server = land.getServerAccess();
        URL url = server.getPeriodURL(period);
        String urlText = url.toString();
        if (period.isHot()) {
            urlText = urlText + "#bottom";
        }
        WebIPCDialog.showDialog(this.topFrame, urlText);
    }

    private void actionShowWebTalk() {
        TabBrowser browser = this.topView.getTabBrowser();
        Village village = browser.getVillage();
        if (village == null) {
            return;
        }
        PeriodView periodView = this.currentPeriodView();
        if (periodView == null) {
            return;
        }
        Discussion discussion = periodView.getDiscussion();
        Talk talk = discussion.getPopupedTalk();
        if (talk == null) {
            return;
        }
        Period period = periodView.getPeriod();
        if (period == null) {
            return;
        }
        Land land = village.getParentLand();
        ServerAccess server = land.getServerAccess();
        URL url = server.getPeriodURL(period);
        String urlText = url.toString();
        urlText = urlText + "#" + talk.getMessageID();
        WebIPCDialog.showDialog(this.topFrame, urlText);
    }

    private void actionShowPortal() {
        WebIPCDialog.showDialog(this.topFrame, Jindolf.CONTACT);
    }

    private void warnDialog(String title, String message, Throwable e) {
        Jindolf.logger().warn(message, e);
        JOptionPane.showMessageDialog(this.topFrame, message, title + " - " + Jindolf.TITLE, 2);
    }

    private void actionChangeLaF() {
        LookAndFeel lnf;
        Class<?> lnfClass;
        String className = this.actionManager.getSelectedLookAndFeel();
        String warnTitle = "Look&Feel";
        String warnMsg = "\u3053\u306eLook&Feel[" + className + "]\u3092\u8aad\u307f\u8fbc\u3080\u4e8b\u304c\u3067\u304d\u307e\u305b\u3093\u3002";
        try {
            lnfClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.warnDialog(warnTitle, warnMsg, e);
            return;
        }
        warnMsg = "\u3053\u306eLook&Feel[" + className + "]\u3092\u751f\u6210\u3059\u308b\u4e8b\u304c\u3067\u304d\u307e\u305b\u3093\u3002";
        try {
            lnf = (LookAndFeel)lnfClass.newInstance();
        }
        catch (InstantiationException e) {
            this.warnDialog(warnTitle, warnMsg, e);
            return;
        }
        catch (IllegalAccessException e) {
            this.warnDialog(warnTitle, warnMsg, e);
            return;
        }
        catch (ClassCastException e) {
            this.warnDialog(warnTitle, warnMsg, e);
            return;
        }
        warnMsg = "\u3053\u306eLook&Feel[" + lnf.getName() + "]\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
        try {
            UIManager.setLookAndFeel(lnf);
        }
        catch (UnsupportedLookAndFeelException e) {
            this.warnDialog(warnTitle, warnMsg, e);
            return;
        }
        Jindolf.logger().info("Look&Feel\u304c[" + lnf.getName() + "]\u306b\u5909\u66f4\u3055\u308c\u307e\u3057\u305f\u3002");
        final Runnable updateUITask = new Runnable(){

            public void run() {
                Set windows = Controller.this.windowMap.keySet();
                for (Window window : windows) {
                    SwingUtilities.updateComponentTreeUI(window);
                    window.validate();
                    boolean needPack = (Boolean)Controller.this.windowMap.get(window);
                    if (!needPack) continue;
                    window.pack();
                }
            }
        };
        ExecutorService executor = Executors.newCachedThreadPool();
        executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Controller.this.setBusy(true);
                Controller.this.updateStatusBar("Look&Feel\u3092\u66f4\u65b0\u4e2d\u2026");
                try {
                    SwingUtilities.invokeAndWait(updateUITask);
                }
                catch (InvocationTargetException e) {
                    Jindolf.logger().warn("Look&Feel\u306e\u66f4\u65b0\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
                }
                catch (InterruptedException e) {
                    Jindolf.logger().warn("Look&Feel\u306e\u66f4\u65b0\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
                }
                finally {
                    Controller.this.updateStatusBar("Look&Feel\u304c\u66f4\u65b0\u3055\u308c\u307e\u3057\u305f");
                    Controller.this.setBusy(false);
                }
            }
        });
    }

    private void actionShowFilter() {
        this.toggleWindow(this.filterFrame);
    }

    private void actionShowAccount() {
        if (this.accountFrame != null) {
            this.toggleWindow(this.accountFrame);
            return;
        }
        this.accountFrame = new AccountPanel((Frame)this.topFrame, this.model);
        this.accountFrame.pack();
        this.accountFrame.setVisible(true);
        this.windowMap.put(this.accountFrame, true);
    }

    private void actionShowLog() {
        this.toggleWindow(this.showlogFrame);
    }

    private void actionTalkPreview() {
        this.toggleWindow(this.talkPreview);
    }

    private void actionOption() {
        AppSetting setting = Jindolf.getAppSetting();
        FontInfo fontInfo = setting.getFontInfo();
        this.optionPanel.getFontChooser().setFontInfo(fontInfo);
        ProxyInfo proxyInfo = setting.getProxyInfo();
        this.optionPanel.getProxyChooser().setProxyInfo(proxyInfo);
        DialogPref dialogPref = setting.getDialogPref();
        this.optionPanel.getDialogPrefPanel().setDialogPref(dialogPref);
        this.optionPanel.setVisible(true);
        if (this.optionPanel.isCanceled()) {
            return;
        }
        fontInfo = this.optionPanel.getFontChooser().getFontInfo();
        this.updateFontInfo(fontInfo);
        proxyInfo = this.optionPanel.getProxyChooser().getProxyInfo();
        this.updateProxyInfo(proxyInfo);
        dialogPref = this.optionPanel.getDialogPrefPanel().getDialogPref();
        this.updateDialogPref(dialogPref);
    }

    private void updateFontInfo(FontInfo newFontInfo) {
        AppSetting setting = Jindolf.getAppSetting();
        FontInfo oldInfo = setting.getFontInfo();
        if (newFontInfo.equals(oldInfo)) {
            return;
        }
        setting.setFontInfo(newFontInfo);
        this.topView.getTabBrowser().setFontInfo(newFontInfo);
        this.talkPreview.setFontInfo(newFontInfo);
        this.optionPanel.getFontChooser().setFontInfo(newFontInfo);
    }

    private void updateProxyInfo(ProxyInfo newProxyInfo) {
        AppSetting setting = Jindolf.getAppSetting();
        ProxyInfo oldProxyInfo = setting.getProxyInfo();
        if (newProxyInfo.equals(oldProxyInfo)) {
            return;
        }
        setting.setProxyInfo(newProxyInfo);
        for (Land land : this.model.getLandList()) {
            ServerAccess server = land.getServerAccess();
            server.setProxy(newProxyInfo.getProxy());
        }
    }

    private void updateDialogPref(DialogPref newDialogPref) {
        AppSetting setting = Jindolf.getAppSetting();
        DialogPref oldDialogPref = setting.getDialogPref();
        if (newDialogPref.equals(oldDialogPref)) {
            return;
        }
        setting.setDialogPref(newDialogPref);
        this.topView.getTabBrowser().setDialogPref(newDialogPref);
    }

    private void actionShowDigest() {
        TabBrowser browser = this.topView.getTabBrowser();
        final Village village = browser.getVillage();
        if (village == null) {
            return;
        }
        VillageState villageState = village.getState();
        if (villageState != VillageState.EPILOGUE && villageState != VillageState.GAMEOVER || !village.isValid()) {
            String message = "\u30a8\u30d4\u30ed\u30fc\u30b0\u3092\u6b63\u5e38\u306b\u8fce\u3048\u3066\u3044\u306a\u3044\u6751\u306f\n\u30c0\u30a4\u30b8\u30a7\u30b9\u30c8\u6a5f\u80fd\u3092\u5229\u7528\u3067\u304d\u307e\u305b\u3093";
            String title = "\u30c0\u30a4\u30b8\u30a7\u30b9\u30c8\u4e0d\u53ef - " + Jindolf.TITLE;
            JOptionPane pane = new JOptionPane(message, 2, -1);
            JDialog dialog = pane.createDialog(this.topFrame, title);
            dialog.pack();
            dialog.setVisible(true);
            dialog.dispose();
            return;
        }
        if (this.digestPanel == null) {
            this.digestPanel = new VillageDigest(this.topFrame);
            this.digestPanel.pack();
            this.digestPanel.setSize(600, 550);
            this.windowMap.put(this.digestPanel, false);
        }
        final VillageDigest digest = this.digestPanel;
        ExecutorService executor = Executors.newCachedThreadPool();
        executor.execute(new Runnable(){

            public void run() {
                Controller.this.taskFullOpenAllPeriod();
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        digest.setVillage(village);
                        digest.setVisible(true);
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void taskFullOpenAllPeriod() {
        this.setBusy(true);
        this.updateStatusBar("\u4e00\u62ec\u8aad\u307f\u8fbc\u307f\u958b\u59cb");
        try {
            TabBrowser browser = this.topView.getTabBrowser();
            Village village = browser.getVillage();
            if (village == null) {
                return;
            }
            for (PeriodView periodView : browser.getPeriodViewList()) {
                Period period = periodView.getPeriod();
                if (period == null || period.isFullOpen()) continue;
                String message = period.getDay() + "\u65e5\u76ee\u306e\u30c7\u30fc\u30bf\u3092\u8aad\u307f\u8fbc\u3093\u3067\u3044\u307e\u3059";
                this.updateStatusBar(message);
                try {
                    Period.parsePeriod(period, true);
                }
                catch (IOException e) {
                    this.showNetworkError(village, e);
                    this.updateStatusBar("\u4e00\u62ec\u8aad\u307f\u8fbc\u307f\u5b8c\u4e86");
                    this.setBusy(false);
                    return;
                }
                periodView.showTopics();
            }
        }
        finally {
            this.updateStatusBar("\u4e00\u62ec\u8aad\u307f\u8fbc\u307f\u5b8c\u4e86");
            this.setBusy(false);
        }
    }

    private void actionShowFind() {
        this.findPanel.setVisible(true);
        if (this.findPanel.isCanceled()) {
            this.updateFindPanel();
            return;
        }
        if (this.findPanel.isBulkSearch()) {
            this.bulkSearch();
        } else {
            this.regexSearch();
        }
    }

    private void regexSearch() {
        Pattern pattern;
        Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        RegexPattern regPattern = this.findPanel.getRegexPattern();
        int hits = discussion.setRegexPattern(regPattern);
        String hitMessage = "\uff3b" + hits + "\uff3d\u4ef6\u30d2\u30c3\u30c8\u3057\u307e\u3057\u305f";
        this.updateStatusBar(hitMessage);
        String loginfo = "";
        if (regPattern != null && (pattern = regPattern.getPattern()) != null) {
            loginfo = "\u6b63\u898f\u8868\u73fe " + pattern.pattern() + " \u306b";
        }
        loginfo = loginfo + hitMessage;
        Jindolf.logger().info(loginfo);
    }

    private void bulkSearch() {
        ExecutorService executor = Executors.newCachedThreadPool();
        executor.execute(new Runnable(){

            public void run() {
                Controller.this.taskBulkSearch();
            }
        });
    }

    private void taskBulkSearch() {
        Pattern pattern;
        this.taskLoadAllPeriod();
        int totalhits = 0;
        RegexPattern regPattern = this.findPanel.getRegexPattern();
        StringBuilder hitDesc = new StringBuilder();
        TabBrowser browser = this.topView.getTabBrowser();
        for (PeriodView periodView : browser.getPeriodViewList()) {
            Discussion discussion = periodView.getDiscussion();
            int hits = discussion.setRegexPattern(regPattern);
            totalhits += hits;
            if (hits <= 0) continue;
            Period period = discussion.getPeriod();
            hitDesc.append(' ').append(period.getDay()).append("d:");
            hitDesc.append(hits).append("\u4ef6");
        }
        String hitMessage = "\uff3b" + totalhits + "\uff3d\u4ef6\u30d2\u30c3\u30c8\u3057\u307e\u3057\u305f\u3002" + hitDesc.toString();
        this.updateStatusBar(hitMessage);
        String loginfo = "";
        if (regPattern != null && (pattern = regPattern.getPattern()) != null) {
            loginfo = "\u6b63\u898f\u8868\u73fe " + pattern.pattern() + " \u306b";
        }
        loginfo = loginfo + hitMessage;
        Jindolf.logger().info(loginfo);
    }

    private void updateFindPanel() {
        Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        RegexPattern pattern = discussion.getRegexPattern();
        this.findPanel.setRegexPattern(pattern);
    }

    private void actionDaySummary() {
        PeriodView periodView = this.currentPeriodView();
        if (periodView == null) {
            return;
        }
        Period period = periodView.getPeriod();
        if (period == null) {
            return;
        }
        if (this.daySummaryPanel == null) {
            this.daySummaryPanel = new DaySummary(this.topFrame);
            this.daySummaryPanel.pack();
            this.daySummaryPanel.setSize(400, 500);
        }
        this.daySummaryPanel.summaryPeriod(period);
        this.daySummaryPanel.setVisible(true);
        this.windowMap.put(this.daySummaryPanel, false);
    }

    private void actionDayExportCsv() {
        PeriodView periodView = this.currentPeriodView();
        if (periodView == null) {
            return;
        }
        Period period = periodView.getPeriod();
        if (period == null) {
            return;
        }
        File file = CsvExporter.exportPeriod(period, this.filterFrame);
        if (file != null) {
            String message = "CSV\u30d5\u30a1\u30a4\u30eb(" + file.getName() + ")\u3078\u306e\u30a8\u30af\u30b9\u30dd\u30fc\u30c8\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f";
            this.updateStatusBar(message);
        }
    }

    private void actionSearchNext() {
        Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        discussion.nextHotTarget();
    }

    private void actionSearchPrev() {
        Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        discussion.prevHotTarget();
    }

    private void actionReloadPeriod() {
        this.updatePeriod(true);
        TabBrowser tabBrowser = this.topView.getTabBrowser();
        Village village = tabBrowser.getVillage();
        if (village == null) {
            return;
        }
        if (village.getState() != VillageState.EPILOGUE) {
            return;
        }
        Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        Period period = discussion.getPeriod();
        if (period == null) {
            return;
        }
        if (period.getTopics() > 1000) {
            JOptionPane.showMessageDialog(this.topFrame, "\u30a8\u30d4\u30ed\u30fc\u30b0\u304c1000\u767a\u8a00\u3092\u8d85\u3048\u306f\u3058\u3081\u305f\u3089\u3001\n\u8ca0\u8377\u5bfe\u7b56\u306e\u305f\u3081Web\u30d6\u30e9\u30a6\u30b6\u306b\u3088\u308b\u30a2\u30af\u30bb\u30b9\u3092\u5fc3\u304c\u3051\u307e\u3057\u3087\u3046", "\u9577\u5927\u30a8\u30d4\u30ed\u30fc\u30b0\u8b66\u544a", 2);
        }
    }

    private void actionLoadAllPeriod() {
        ExecutorService executor = Executors.newCachedThreadPool();
        executor.execute(new Runnable(){

            public void run() {
                Controller.this.taskLoadAllPeriod();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void taskLoadAllPeriod() {
        this.setBusy(true);
        this.updateStatusBar("\u4e00\u62ec\u8aad\u307f\u8fbc\u307f\u958b\u59cb");
        try {
            TabBrowser browser = this.topView.getTabBrowser();
            Village village = browser.getVillage();
            if (village == null) {
                return;
            }
            for (PeriodView periodView : browser.getPeriodViewList()) {
                Period period = periodView.getPeriod();
                if (period == null) continue;
                String message = period.getDay() + "\u65e5\u76ee\u306e\u30c7\u30fc\u30bf\u3092\u8aad\u307f\u8fbc\u3093\u3067\u3044\u307e\u3059";
                this.updateStatusBar(message);
                try {
                    Period.parsePeriod(period, false);
                }
                catch (IOException e) {
                    this.showNetworkError(village, e);
                    this.updateStatusBar("\u4e00\u62ec\u8aad\u307f\u8fbc\u307f\u5b8c\u4e86");
                    this.setBusy(false);
                    return;
                }
                periodView.showTopics();
            }
        }
        finally {
            this.updateStatusBar("\u4e00\u62ec\u8aad\u307f\u8fbc\u307f\u5b8c\u4e86");
            this.setBusy(false);
        }
    }

    private void actionReloadVillageList() {
        JTree tree = this.topView.getTreeView();
        TreePath path = tree.getSelectionPath();
        if (path == null) {
            return;
        }
        Land land = null;
        for (int ct = 0; ct < path.getPathCount(); ++ct) {
            Object obj = path.getPathComponent(ct);
            if (!(obj instanceof Land)) continue;
            land = (Land)obj;
            break;
        }
        if (land == null) {
            return;
        }
        this.topView.showInitPanel();
        this.execReloadVillageList(land);
    }

    private void actionCopySelected() {
        Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        CharSequence copied = discussion.copySelected();
        if (copied == null) {
            return;
        }
        copied = StringUtils.suppressString(copied);
        this.updateStatusBar("[" + copied + "]\u3092\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u30b3\u30d4\u30fc\u3057\u307e\u3057\u305f");
    }

    private void actionCopyTalk() {
        Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        CharSequence copied = discussion.copyTalk();
        if (copied == null) {
            return;
        }
        copied = StringUtils.suppressString(copied);
        this.updateStatusBar("[" + copied + "]\u3092\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u30b3\u30d4\u30fc\u3057\u307e\u3057\u305f");
    }

    private void actionJumpAnchor() {
        PeriodView periodView = this.currentPeriodView();
        if (periodView == null) {
            return;
        }
        Discussion discussion = periodView.getDiscussion();
        final TabBrowser browser = this.topView.getTabBrowser();
        final Village village = browser.getVillage();
        final Anchor anchor = discussion.getPopupedAnchor();
        if (anchor == null) {
            return;
        }
        ExecutorService executor = Executors.newCachedThreadPool();
        executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Controller.this.setBusy(true);
                Controller.this.updateStatusBar("\u30b8\u30e3\u30f3\u30d7\u5148\u306e\u8aad\u307f\u8fbc\u307f\u4e2d\u2026");
                if (anchor.hasTalkNo()) {
                    Controller.this.taskLoadAllPeriod();
                }
                try {
                    List<Talk> talkList = village.getTalkListFromAnchor(anchor);
                    if (talkList == null || talkList.size() <= 0) {
                        Controller.this.updateStatusBar("\u30a2\u30f3\u30ab\u30fc\u306e\u30b8\u30e3\u30f3\u30d7\u5148[" + anchor.toString() + "]\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093");
                        return;
                    }
                    final Talk targetTalk = talkList.get(0);
                    final Period targetPeriod = targetTalk.getPeriod();
                    final int tabIndex = targetPeriod.getDay() + 1;
                    final PeriodView target = browser.getPeriodView(tabIndex);
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            browser.setSelectedIndex(tabIndex);
                            target.setPeriod(targetPeriod);
                            target.scrollToTalk(targetTalk);
                        }
                    });
                    Controller.this.updateStatusBar("\u30a2\u30f3\u30ab\u30fc[" + anchor.toString() + "]\u306b\u30b8\u30e3\u30f3\u30d7\u3057\u307e\u3057\u305f");
                }
                catch (IOException e) {
                    Controller.this.updateStatusBar("\u30a2\u30f3\u30ab\u30fc\u306e\u5c55\u958b\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u8d77\u304d\u307e\u3057\u305f");
                }
                finally {
                    Controller.this.setBusy(false);
                }
            }
        });
    }

    private void execReloadVillageList(final Land land) {
        final LandsTree treePanel = this.topView.getLandsTree();
        ExecutorService executor = Executors.newCachedThreadPool();
        executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Controller.this.setBusy(true);
                Controller.this.updateStatusBar("\u6751\u4e00\u89a7\u3092\u8aad\u307f\u8fbc\u307f\u4e2d\u2026");
                try {
                    try {
                        Controller.this.model.loadVillageList(land);
                    }
                    catch (IOException e) {
                        Controller.this.showNetworkError(land, e);
                    }
                    treePanel.expandLand(land);
                }
                finally {
                    Controller.this.updateStatusBar("\u6751\u4e00\u89a7\u306e\u8aad\u307f\u8fbc\u307f\u5b8c\u4e86");
                    Controller.this.setBusy(false);
                }
            }
        });
    }

    private void updatePeriod(final boolean force) {
        final TabBrowser tabBrowser = this.topView.getTabBrowser();
        final Village village = tabBrowser.getVillage();
        if (village == null) {
            return;
        }
        this.setFrameTitle(village.getVillageFullName());
        final PeriodView periodView = this.currentPeriodView();
        Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        discussion.setTopicFilter(this.filterFrame);
        final Period period = discussion.getPeriod();
        if (period == null) {
            return;
        }
        ExecutorService executor = Executors.newCachedThreadPool();
        executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Controller.this.setBusy(true);
                try {
                    boolean wasHot = this.loadPeriod();
                    if (wasHot && !period.isHot() && !this.updatePeriodList()) {
                        return;
                    }
                    this.renderBrowser();
                }
                finally {
                    Controller.this.setBusy(false);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean loadPeriod() {
                boolean wasHot;
                Controller.this.updateStatusBar("1\u65e5\u5206\u306e\u30c7\u30fc\u30bf\u3092\u8aad\u307f\u8fbc\u3093\u3067\u3044\u307e\u3059\u2026");
                try {
                    wasHot = period.isHot();
                    try {
                        Period.parsePeriod(period, force);
                    }
                    catch (IOException e) {
                        Controller.this.showNetworkError(village, e);
                    }
                }
                finally {
                    Controller.this.updateStatusBar("1\u65e5\u5206\u306e\u30c7\u30fc\u30bf\u3092\u8aad\u307f\u7d42\u308f\u308a\u307e\u3057\u305f");
                }
                return wasHot;
            }

            private boolean updatePeriodList() {
                Controller.this.updateStatusBar("\u6751\u60c5\u5831\u3092\u8aad\u307f\u76f4\u3057\u3066\u3044\u307e\u3059\u2026");
                try {
                    Village.updateVillage(village);
                }
                catch (IOException e) {
                    Controller.this.showNetworkError(village, e);
                    return false;
                }
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            tabBrowser.setVillage(village);
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    Jindolf.logger().fatal("\u30bf\u30d6\u64cd\u4f5c\u3067\u81f4\u547d\u7684\u306a\u969c\u5bb3\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
                }
                catch (InterruptedException e) {
                    Jindolf.logger().fatal("\u30bf\u30d6\u64cd\u4f5c\u3067\u81f4\u547d\u7684\u306a\u969c\u5bb3\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
                }
                Controller.this.updateStatusBar("\u6751\u60c5\u5831\u3092\u8aad\u307f\u76f4\u3057\u307e\u3057\u305f\u2026");
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void renderBrowser() {
                Controller.this.updateStatusBar("\u30ec\u30f3\u30c0\u30ea\u30f3\u30b0\u4e2d\u2026");
                try {
                    final int lastPos = periodView.getVerticalPosition();
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            public void run() {
                                periodView.showTopics();
                            }
                        });
                    }
                    catch (InvocationTargetException e) {
                        Jindolf.logger().fatal("\u30d6\u30e9\u30a6\u30b6\u8868\u793a\u3067\u81f4\u547d\u7684\u306a\u969c\u5bb3\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
                    }
                    catch (InterruptedException e) {
                        Jindolf.logger().fatal("\u30d6\u30e9\u30a6\u30b6\u8868\u793a\u3067\u81f4\u547d\u7684\u306a\u969c\u5bb3\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
                    }
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            periodView.setVerticalPosition(lastPos);
                        }
                    });
                }
                finally {
                    Controller.this.updateStatusBar("\u30ec\u30f3\u30c0\u30ea\u30f3\u30b0\u5b8c\u4e86");
                }
            }
        });
    }

    private void filterChanged() {
        final Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        discussion.setTopicFilter(this.filterFrame);
        ExecutorService executor = Executors.newCachedThreadPool();
        executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Controller.this.setBusy(true);
                Controller.this.updateStatusBar("\u30d5\u30a3\u30eb\u30bf\u30ea\u30f3\u30b0\u4e2d\u2026");
                try {
                    discussion.filtering();
                }
                finally {
                    Controller.this.updateStatusBar("\u30d5\u30a3\u30eb\u30bf\u30ea\u30f3\u30b0\u5b8c\u4e86");
                    Controller.this.setBusy(false);
                }
            }
        });
    }

    private PeriodView currentPeriodView() {
        TabBrowser tb = this.topView.getTabBrowser();
        PeriodView result = tb.currentPeriodView();
        return result;
    }

    private Discussion currentDiscussion() {
        PeriodView periodView = this.currentPeriodView();
        if (periodView == null) {
            return null;
        }
        Discussion result = periodView.getDiscussion();
        return result;
    }

    private void toggleWindow(Window window) {
        if (window == null) {
            return;
        }
        if (window instanceof Frame) {
            boolean isIconified;
            Frame frame = (Frame)window;
            int winState = frame.getExtendedState();
            boolean bl = isIconified = (winState & 1) != 0;
            if (isIconified) {
                frame.setExtendedState(winState &= 0xFFFFFFFE);
                frame.setVisible(true);
                return;
            }
        }
        if (window.isVisible()) {
            window.setVisible(false);
            window.dispose();
        } else {
            window.setVisible(true);
        }
    }

    public void showNetworkError(Village village, IOException e) {
        Land land = village.getParentLand();
        this.showNetworkError(land, e);
    }

    public void showNetworkError(Land land, IOException e) {
        Jindolf.logger().warn("\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u3067\u969c\u5bb3\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
        ServerAccess server = land.getServerAccess();
        String message = land.getLandDef().getLandName() + "\u3092\u904b\u55b6\u3059\u308b\u30b5\u30fc\u30d0\u3068\u306e\u9593\u306e\u901a\u4fe1\u3067" + "\u4f55\u3089\u304b\u306e\u30c8\u30e9\u30d6\u30eb\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\n" + "\u76f8\u624b\u30b5\u30fc\u30d0\u306eURL\u306f [ " + server.getBaseURL() + " ] \u3060\u3088\u3002\n" + "\u30d7\u30ed\u30af\u30b7\u8a2d\u5b9a\u306f\u6b63\u3057\u3044\u304b\u306a\uff1f\n" + "Web\u30d6\u30e9\u30a6\u30b6\u3067\u3082\u904a\u3079\u306a\u3044\u304b\u78ba\u8a8d\u3057\u3066\u307f\u3066\u306d!\n";
        JOptionPane pane = new JOptionPane(message, 2, -1);
        JDialog dialog = pane.createDialog(this.topFrame, "\u901a\u4fe1\u7570\u5e38\u767a\u751f - " + Jindolf.TITLE);
        dialog.pack();
        dialog.setVisible(true);
        dialog.dispose();
    }

    public void valueChanged(TreeSelectionEvent event) {
        TreePath path = event.getNewLeadSelectionPath();
        if (path == null) {
            return;
        }
        Object selObj = path.getLastPathComponent();
        if (selObj instanceof Land) {
            Land land = (Land)selObj;
            this.setFrameTitle(land.getLandDef().getLandName());
            this.topView.showLandInfo(land);
            this.actionManager.appearVillage(false);
            this.actionManager.appearPeriod(false);
        } else if (selObj instanceof Village) {
            final Village village = (Village)selObj;
            ExecutorService executor = Executors.newCachedThreadPool();
            executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Controller.this.setBusy(true);
                    Controller.this.updateStatusBar("\u6751\u60c5\u5831\u3092\u8aad\u307f\u8fbc\u307f\u4e2d\u2026");
                    try {
                        Village.updateVillage(village);
                    }
                    catch (IOException e) {
                        Controller.this.showNetworkError(village, e);
                        return;
                    }
                    finally {
                        Controller.this.updateStatusBar("\u6751\u60c5\u5831\u306e\u8aad\u307f\u8fbc\u307f\u5b8c\u4e86");
                        Controller.this.setBusy(false);
                    }
                    Controller.this.actionManager.appearVillage(true);
                    Controller.this.setFrameTitle(village.getVillageFullName());
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            Controller.this.topView.showVillageInfo(village);
                        }
                    });
                }
            });
        }
    }

    public void stateChanged(ChangeEvent event) {
        Object source = event.getSource();
        if (source == this.filterFrame) {
            this.filterChanged();
        } else if (source instanceof TabBrowser) {
            this.updateFindPanel();
            this.updatePeriod(false);
            PeriodView periodView = this.currentPeriodView();
            if (periodView == null) {
                this.actionManager.appearPeriod(false);
            } else {
                this.actionManager.appearPeriod(true);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.isBusyNow) {
            return;
        }
        String cmd = e.getActionCommand();
        if (cmd.equals("ACCOUNT")) {
            this.actionShowAccount();
        } else if (cmd.equals("EXIT")) {
            this.actionExit();
        } else if (cmd.equals("COPY")) {
            this.actionCopySelected();
        } else if (cmd.equals("SHOWFIND")) {
            this.actionShowFind();
        } else if (cmd.equals("SEARCHNEXT")) {
            this.actionSearchNext();
        } else if (cmd.equals("SEARCHPREV")) {
            this.actionSearchPrev();
        } else if (cmd.equals("ALLPERIOD")) {
            this.actionLoadAllPeriod();
        } else if (cmd.equals("DIGEST")) {
            this.actionShowDigest();
        } else if (cmd.equals("WEBVILL")) {
            this.actionShowWebVillage();
        } else if (cmd.equals("WEBWIKI")) {
            this.actionShowWebWiki();
        } else if (cmd.equals("WEBCAST")) {
            this.actionShowWebCast();
        } else if (cmd.equals("RELOAD")) {
            this.actionReloadPeriod();
        } else if (cmd.equals("DAYSUMMARY")) {
            this.actionDaySummary();
        } else if (cmd.equals("DAYEXPCSV")) {
            this.actionDayExportCsv();
        } else if (cmd.equals("WEBDAY")) {
            this.actionShowWebDay();
        } else if (cmd.equals("OPTION")) {
            this.actionOption();
        } else if (cmd.equals("LANDF")) {
            this.actionChangeLaF();
        } else if (cmd.equals("SHOWFILT")) {
            this.actionShowFilter();
        } else if (cmd.equals("SHOWEDIT")) {
            this.actionTalkPreview();
        } else if (cmd.equals("SHOWLOG")) {
            this.actionShowLog();
        } else if (cmd.equals("HELPDOC")) {
            this.actionHelp();
        } else if (cmd.equals("SHOWPORTAL")) {
            this.actionShowPortal();
        } else if (cmd.equals("ABOUT")) {
            this.actionAbout();
        } else if (cmd.equals("VILLAGELIST")) {
            this.actionReloadVillageList();
        } else if (cmd.equals("COPYTALK")) {
            this.actionCopyTalk();
        } else if (cmd.equals("JUMPANCHOR")) {
            this.actionJumpAnchor();
        } else if (cmd.equals("WEBTALK")) {
            this.actionShowWebTalk();
        }
    }

    public void treeWillCollapse(TreeExpansionEvent event) {
    }

    public void treeWillExpand(TreeExpansionEvent event) {
        if (!(event.getSource() instanceof JTree)) {
            return;
        }
        TreePath path = event.getPath();
        Object lastObj = path.getLastPathComponent();
        if (!(lastObj instanceof Land)) {
            return;
        }
        Land land = (Land)lastObj;
        if (land.getVillageCount() > 0) {
            return;
        }
        this.execReloadVillageList(land);
    }

    public void anchorHitted(AnchorHitEvent event) {
        PeriodView periodView = this.currentPeriodView();
        if (periodView == null) {
            return;
        }
        Period period = periodView.getPeriod();
        if (period == null) {
            return;
        }
        final Village village = period.getVillage();
        final TalkDraw talkDraw = event.getTalkDraw();
        final Anchor anchor = event.getAnchor();
        final Discussion discussion = periodView.getDiscussion();
        ExecutorService executor = Executors.newCachedThreadPool();
        executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Controller.this.setBusy(true);
                Controller.this.updateStatusBar("\u30a2\u30f3\u30ab\u30fc\u306e\u5c55\u958b\u4e2d\u2026");
                if (anchor.hasTalkNo()) {
                    Controller.this.taskLoadAllPeriod();
                }
                try {
                    final List<Talk> talkList = village.getTalkListFromAnchor(anchor);
                    if (talkList == null || talkList.size() <= 0) {
                        Controller.this.updateStatusBar("\u30a2\u30f3\u30ab\u30fc\u306e\u5c55\u958b\u5148[" + anchor.toString() + "]\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093");
                        return;
                    }
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            talkDraw.showAnchorTalks(anchor, talkList);
                            discussion.layoutRows();
                        }
                    });
                    Controller.this.updateStatusBar("\u30a2\u30f3\u30ab\u30fc[" + anchor.toString() + "]\u306e\u5c55\u958b\u5b8c\u4e86");
                }
                catch (IOException e) {
                    Controller.this.updateStatusBar("\u30a2\u30f3\u30ab\u30fc\u306e\u5c55\u958b\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u8d77\u304d\u307e\u3057\u305f");
                }
                finally {
                    Controller.this.setBusy(false);
                }
            }
        });
    }

    private void setBusy(final boolean isBusy) {
        this.isBusyNow = isBusy;
        Runnable microJob = new Runnable(){

            public void run() {
                Cursor cursor = isBusy ? Cursor.getPredefinedCursor(3) : Cursor.getDefaultCursor();
                Component glass = Controller.this.topFrame.getGlassPane();
                glass.setCursor(cursor);
                glass.setVisible(isBusy);
                Controller.this.topView.setBusy(isBusy);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            microJob.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(microJob);
            }
            catch (InvocationTargetException e) {
                Jindolf.logger().fatal("\u30d3\u30b8\u30fc\u51e6\u7406\u3067\u5931\u6557", e);
            }
            catch (InterruptedException e) {
                Jindolf.logger().fatal("\u30d3\u30b8\u30fc\u51e6\u7406\u3067\u5931\u6557", e);
            }
        }
    }

    private void updateStatusBar(String message) {
        this.topView.updateSysMessage(message);
    }

    private void setFrameTitle(CharSequence name) {
        String title = Jindolf.TITLE;
        if (name != null && name.length() > 0) {
            title = name + " - " + title;
        }
        this.topFrame.setTitle(title);
    }

    private void shutdown() {
        this.findPanel.saveHistory();
        this.talkPreview.saveDraft();
        Jindolf.getAppSetting().saveConfig();
        Jindolf.exit(0);
    }
}

