/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jp.sourceforge.jindolf.Avatar;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.Period;
import jp.sourceforge.jindolf.Talk;
import jp.sourceforge.jindolf.TalkDraw;
import jp.sourceforge.jindolf.Topic;
import jp.sourceforge.jindolf.Village;
import jp.sourceforge.jindolf.corelib.TalkType;

public class DaySummary
extends JDialog
implements WindowListener,
ActionListener,
ItemListener {
    private static final String FRAMETITLE = "\u767a\u8a00\u96c6\u8a08 - " + Jindolf.TITLE;
    private static final NumberFormat AVERAGE_FORM;
    private static final String PUBTALK = "\u767d\u767a\u8a00";
    private static final String WOLFTALK = "\u8d64\u767a\u8a00";
    private static final String GRAVETALK = "\u9752\u767a\u8a00";
    private static final String PRVTALK = "\u7070\u767a\u8a00";
    private static final String ALLTALK = "\u5168\u767a\u8a00";
    private static final int HORIZONTAL_GAP = 5;
    private static final int VERTICAL_GAP = 1;
    private static final Color COLOR_ALL;
    private final DefaultTableModel tableModel;
    private final TableColumn avatarColumn;
    private final JTable tableComp;
    private final JComboBox typeSelector = new JComboBox();
    private final JButton closeButton = new JButton("\u9589\u3058\u308b");
    private final JLabel caption = new JLabel();
    private final JLabel totalSum = new JLabel();
    private TalkType talkFilter;
    private Period period;

    public DaySummary(Frame owner) {
        super(owner, FRAMETITLE, true);
        GUIUtils.modifyWindowAttributes(this, true, false, true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.tableModel = DaySummary.createInitModel();
        this.tableComp = new JTable();
        this.tableComp.setModel(this.tableModel);
        this.tableComp.setSelectionMode(0);
        this.tableComp.setIntercellSpacing(new Dimension(5, 1));
        this.tableComp.setDefaultEditor(Object.class, null);
        this.tableComp.setDefaultRenderer(Object.class, new CustomRenderer());
        this.tableComp.setShowGrid(true);
        TableColumnModel tcolModel = this.tableComp.getColumnModel();
        this.avatarColumn = tcolModel.getColumn(0);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(4);
        tcolModel.getColumn(1).setCellRenderer(renderer);
        renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(4);
        tcolModel.getColumn(2).setCellRenderer(renderer);
        renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(4);
        tcolModel.getColumn(3).setCellRenderer(renderer);
        this.typeSelector.addItem(PUBTALK);
        this.typeSelector.addItem(WOLFTALK);
        this.typeSelector.addItem(GRAVETALK);
        this.typeSelector.addItem(PRVTALK);
        this.typeSelector.addItem(ALLTALK);
        this.closeButton.addActionListener(this);
        this.typeSelector.addItemListener(this);
        this.typeSelector.setSelectedItem(null);
        this.typeSelector.setSelectedItem(PUBTALK);
        this.design();
        this.clearModel();
    }

    private static DefaultTableModel createInitModel() {
        DefaultTableModel result = new DefaultTableModel();
        Object[] rowHeads = new Object[]{"\u540d\u524d", "\u767a\u8a00\u56de\u6570", "\u5e73\u5747\u6587\u5b57\u5217\u9577", "\u6700\u7d42\u767a\u8a00"};
        result.setColumnCount(rowHeads.length);
        result.setColumnIdentifiers(rowHeads);
        return result;
    }

    private void clearModel() {
        int rows = this.tableModel.getRowCount();
        for (int ct = 1; ct <= rows; ++ct) {
            this.tableModel.removeRow(0);
        }
    }

    private void appendRow(Avatar avatar, Integer talkCount, Integer totalChars, String lastTime) {
        String talks = talkCount + " \u56de";
        double average = talkCount <= 0 ? 0.0 : (double)totalChars.intValue() / (double)talkCount.intValue();
        String chars = AVERAGE_FORM.format(average) + " \u6587\u5b57";
        Object[] row = new Object[]{avatar, talks, chars, lastTime};
        int rowIndex = this.tableModel.getRowCount();
        this.tableModel.insertRow(rowIndex, row);
    }

    private void design() {
        Container content = this.getContentPane();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        content.setLayout(layout);
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        content.add((Component)this.caption, constraints);
        constraints.gridwidth = 0;
        constraints.fill = 0;
        content.add((Component)this.typeSelector, constraints);
        JScrollPane scroller = new JScrollPane(this.tableComp);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        content.add((Component)scroller, constraints);
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 17;
        content.add((Component)this.totalSum, constraints);
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        content.add((Component)new JSeparator(), constraints);
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 13;
        content.add((Component)this.closeButton, constraints);
    }

    public void summaryPeriod(Period newPeriod) {
        this.period = newPeriod;
        this.summaryPeriod();
    }

    private void summaryPeriod() {
        this.clearModel();
        if (this.period == null) {
            return;
        }
        TreeSet<Avatar> avatarSet = new TreeSet<Avatar>();
        HashMap<Avatar, Integer> talkCount = new HashMap<Avatar, Integer>();
        HashMap<Avatar, Integer> totalChars = new HashMap<Avatar, Integer>();
        HashMap<Avatar, Talk> lastTalk = new HashMap<Avatar, Talk>();
        List<Topic> topicList = this.period.getTopicList();
        for (Topic topic : topicList) {
            Talk talk;
            if (!(topic instanceof Talk) || (talk = (Talk)topic).getTalkCount() <= 0 || this.talkFilter != null && talk.getTalkType() != this.talkFilter) continue;
            Avatar avatar = talk.getAvatar();
            Integer counts = (Integer)talkCount.get(avatar);
            if (counts == null) {
                counts = 0;
            }
            Integer n = counts;
            Integer n2 = counts = Integer.valueOf(counts + 1);
            talkCount.put(avatar, counts);
            Integer total = (Integer)totalChars.get(avatar);
            if (total == null) {
                total = 0;
            }
            total = total + talk.getTotalChars();
            totalChars.put(avatar, total);
            lastTalk.put(avatar, talk);
            avatarSet.add(avatar);
        }
        int sum = 0;
        for (Avatar avatar : avatarSet) {
            Integer counts = (Integer)talkCount.get(avatar);
            Integer total = (Integer)totalChars.get(avatar);
            String lastTime = ((Talk)lastTalk.get(avatar)).getAnchorNotation();
            this.appendRow(avatar, counts, total, lastTime);
            sum += counts.intValue();
        }
        this.totalSum.setText("\u5408\u8a08\uff1a" + sum + " \u767a\u8a00");
        Village village = this.period.getVillage();
        String villageName = village.getVillageName();
        String periodCaption = this.period.getCaption();
        this.caption.setText(villageName + "\u6751 " + periodCaption);
    }

    public void windowActivated(WindowEvent event) {
    }

    public void windowDeactivated(WindowEvent event) {
    }

    public void windowIconified(WindowEvent event) {
    }

    public void windowDeiconified(WindowEvent event) {
    }

    public void windowOpened(WindowEvent event) {
    }

    public void windowClosing(WindowEvent event) {
        this.close();
    }

    public void windowClosed(WindowEvent event) {
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() != this.closeButton) {
            return;
        }
        this.close();
    }

    public void itemStateChanged(ItemEvent event) {
        if (event.getStateChange() != 1) {
            return;
        }
        Object selected = this.typeSelector.getSelectedItem();
        if (selected == PUBTALK) {
            this.talkFilter = TalkType.PUBLIC;
        } else if (selected == WOLFTALK) {
            this.talkFilter = TalkType.WOLFONLY;
        } else if (selected == GRAVETALK) {
            this.talkFilter = TalkType.GRAVE;
        } else if (selected == PRVTALK) {
            this.talkFilter = TalkType.PRIVATE;
        } else if (selected == ALLTALK) {
            this.talkFilter = null;
        }
        this.summaryPeriod();
    }

    private void close() {
        this.clearModel();
        this.period = null;
        this.setVisible(false);
    }

    static {
        COLOR_ALL = new Color(0xFFFF80);
        AVERAGE_FORM = NumberFormat.getInstance();
        AVERAGE_FORM.setMaximumFractionDigits(1);
        AVERAGE_FORM.setMinimumFractionDigits(1);
    }

    private class CustomRenderer
    extends DefaultTableCellRenderer {
        public void setValue(Object value) {
            if (value instanceof Avatar) {
                Avatar avatar = (Avatar)value;
                Village village = DaySummary.this.period.getVillage();
                BufferedImage image = village.getAvatarFaceImage(avatar);
                if (image == null) {
                    image = village.getGraveImage();
                }
                if (image != null) {
                    ImageIcon icon = new ImageIcon(image);
                    this.setIcon(icon);
                }
                this.setText(avatar.getName());
                Dimension prefSize = this.getPreferredSize();
                int cellHeight = 2 + prefSize.height;
                if (DaySummary.this.tableComp.getRowHeight() < cellHeight) {
                    DaySummary.this.tableComp.setRowHeight(cellHeight);
                }
                int cellWidth = 10 + prefSize.width;
                if (DaySummary.this.avatarColumn.getPreferredWidth() < cellWidth) {
                    DaySummary.this.avatarColumn.setPreferredWidth(cellWidth);
                }
                return;
            }
            super.setValue(value);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component result = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Object selected = DaySummary.this.typeSelector.getSelectedItem();
            Color bgColor = null;
            if (selected == DaySummary.PUBTALK) {
                bgColor = TalkDraw.COLOR_PUBLIC;
            } else if (selected == DaySummary.WOLFTALK) {
                bgColor = TalkDraw.COLOR_WOLFONLY;
            } else if (selected == DaySummary.GRAVETALK) {
                bgColor = TalkDraw.COLOR_GRAVE;
            } else if (selected == DaySummary.PRVTALK) {
                bgColor = TalkDraw.COLOR_PRIVATE;
            } else if (selected == DaySummary.ALLTALK) {
                bgColor = COLOR_ALL;
            } else {
                assert (false);
                return null;
            }
            result.setForeground(Color.BLACK);
            result.setBackground(bgColor);
            return result;
        }
    }
}

