/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileUtils {
    private static final String SCHEME_FILE = "file";
    private static final Method METHOD_SETREADABLE;
    private static final Method METHOD_SETWRITABLE;
    private static final Locale ROOT;

    private FileUtils() {
        assert (false);
        throw new AssertionError();
    }

    private static boolean invokeOwnerOnly(Method method, File file) throws SecurityException {
        Object result2;
        Object result1;
        if (method == null) {
            return false;
        }
        if (file == null) {
            throw new NullPointerException();
        }
        try {
            result1 = method.invoke((Object)file, false, false);
            result2 = method.invoke((Object)file, true, true);
        }
        catch (IllegalAccessException e) {
            assert (false);
            return false;
        }
        catch (IllegalArgumentException e) {
            assert (false);
            return false;
        }
        catch (ExceptionInInitializerError e) {
            assert (false);
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SecurityException) {
                throw (SecurityException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            assert (false);
            return false;
        }
        assert (result1 instanceof Boolean);
        assert (result2 instanceof Boolean);
        Boolean bresult1 = (Boolean)result1;
        Boolean bresult2 = (Boolean)result2;
        return bresult1 != false && bresult2 != false;
    }

    public static boolean setOwnerOnlyAccess(File file) throws SecurityException {
        boolean readresult = FileUtils.invokeOwnerOnly(METHOD_SETREADABLE, file);
        boolean writeresult = FileUtils.invokeOwnerOnly(METHOD_SETWRITABLE, file);
        return readresult & writeresult;
    }

    public static File findExistsAncestor(File file) throws IllegalArgumentException {
        if (file == null) {
            return null;
        }
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException();
        }
        if (file.exists()) {
            return file;
        }
        File parent = file.getParentFile();
        return FileUtils.findExistsAncestor(parent);
    }

    public static File findRootFile(File file) throws IllegalArgumentException {
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException();
        }
        File parent = file.getParentFile();
        if (parent == null) {
            return file;
        }
        return FileUtils.findRootFile(parent);
    }

    public static File supplyFullPath(File file) {
        File absFile;
        if (file.isAbsolute()) {
            return file;
        }
        try {
            absFile = file.getAbsoluteFile();
        }
        catch (SecurityException e) {
            return file;
        }
        return absFile;
    }

    public static boolean isAccessibleDirectory(File path) {
        if (path == null) {
            return false;
        }
        if (!path.exists()) {
            return false;
        }
        if (!path.isDirectory()) {
            return false;
        }
        if (!path.canRead()) {
            return false;
        }
        return path.canWrite();
    }

    public static File getClassSourceFile(Class<?> klass) {
        URI uri;
        ProtectionDomain domain;
        try {
            domain = klass.getProtectionDomain();
        }
        catch (SecurityException e) {
            return null;
        }
        CodeSource src = domain.getCodeSource();
        URL location = src.getLocation();
        String scheme = location.getProtocol();
        if (!scheme.equals(SCHEME_FILE)) {
            return null;
        }
        try {
            uri = location.toURI();
        }
        catch (URISyntaxException e) {
            assert (false);
            return null;
        }
        File file = new File(uri);
        return file;
    }

    public static boolean isExistsJarFile(File file) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        if (!file.isFile()) {
            return false;
        }
        String name = file.getName();
        return name.matches("^.+\\.[jJ][aA][rR]$");
    }

    public static File getJarDirectory(Class<?> klass) {
        File jarFile = FileUtils.getClassSourceFile(klass);
        if (jarFile == null) {
            return null;
        }
        if (!FileUtils.isExistsJarFile(jarFile)) {
            return null;
        }
        return jarFile.getParentFile();
    }

    public static File getHomeDirectory() {
        String homeProp;
        try {
            homeProp = System.getProperty("user.home");
        }
        catch (SecurityException e) {
            return null;
        }
        File homeFile = new File(homeProp);
        return homeFile;
    }

    public static boolean isMacOSXFs() {
        String osName;
        if (File.separatorChar != '/') {
            return false;
        }
        try {
            osName = System.getProperty("os.name");
        }
        catch (SecurityException e) {
            return false;
        }
        if (osName == null) {
            return false;
        }
        return (osName = osName.toLowerCase(ROOT)).startsWith("mac os x");
    }

    public static boolean isWindowsOSFs() {
        String osName;
        if (File.separatorChar != '\\') {
            return false;
        }
        try {
            osName = System.getProperty("os.name");
        }
        catch (SecurityException e) {
            return false;
        }
        if (osName == null) {
            return false;
        }
        return (osName = osName.toLowerCase(ROOT)).startsWith("windows");
    }

    public static File getAppSetDir() {
        File home = FileUtils.getHomeDirectory();
        if (home == null) {
            return null;
        }
        File result = home;
        if (FileUtils.isMacOSXFs()) {
            result = new File(result, "Library");
            result = new File(result, "Application Support");
        }
        return result;
    }

    public static String getHtmledFileName(File file) {
        String pathName = file.getPath();
        Locale locale = Locale.getDefault();
        String lang = locale.getLanguage();
        if (FileUtils.isWindowsOSFs() && lang.equals("ja")) {
            pathName = pathName.replace(File.separator, "&yen;");
        }
        return "<code>" + pathName + "</code>";
    }

    static {
        int modifiers;
        Method method;
        ROOT = new Locale("", "", "");
        try {
            method = File.class.getMethod("setReadable", Boolean.TYPE, Boolean.TYPE);
            modifiers = method.getModifiers();
            if (!Modifier.isPublic(modifiers)) {
                method = null;
            }
        }
        catch (NoSuchMethodException e) {
            method = null;
        }
        catch (SecurityException e) {
            method = null;
        }
        METHOD_SETREADABLE = method;
        try {
            method = File.class.getMethod("setWritable", Boolean.TYPE, Boolean.TYPE);
            modifiers = method.getModifiers();
            if (!Modifier.isPublic(modifiers)) {
                method = null;
            }
        }
        catch (NoSuchMethodException e) {
            method = null;
        }
        catch (SecurityException e) {
            method = null;
        }
        METHOD_SETWRITABLE = method;
        assert (!FileUtils.isMacOSXFs() || !FileUtils.isWindowsOSFs());
    }
}

