/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.text.CharacterIterator;
import jp.sourceforge.jindolf.FontUtils;
import jp.sourceforge.jindolf.ImtblAffineTx;
import jp.sourceforge.jindolf.json.JsBoolean;
import jp.sourceforge.jindolf.json.JsNumber;
import jp.sourceforge.jindolf.json.JsObject;
import jp.sourceforge.jindolf.json.JsPair;
import jp.sourceforge.jindolf.json.JsString;
import jp.sourceforge.jindolf.json.JsValue;

public class FontInfo {
    public static final FontInfo DEFAULT_FONTINFO = new FontInfo();
    private static final String HASH_FAMILY = "family";
    private static final String HASH_SIZE = "size";
    private static final String HASH_ISBOLD = "isBold";
    private static final String HASH_ISITALIC = "isItalic";
    private static final String HASH_USEAA = "useAntiAlias";
    private static final String HASH_FRACTIONAL = "useFractional";
    private Font font;
    private FontRenderContext context;

    public FontInfo() {
        this(FontUtils.createDefaultSpeechFont());
    }

    public FontInfo(Font font) throws NullPointerException {
        this(font, FontInfo.createBestContext(font));
    }

    public FontInfo(Font font, FontRenderContext context) throws NullPointerException {
        if (font == null || context == null) {
            throw new NullPointerException();
        }
        this.font = font;
        this.context = context;
    }

    public static FontRenderContext createBestContext(Font font) {
        AffineTransform identity = ImtblAffineTx.IDENTITY;
        FontRenderContext result = FontUtils.guessBitmapFont(font) ? new FontRenderContext(identity, false, false) : new FontRenderContext(identity, true, true);
        return result;
    }

    public static JsObject buildJson(FontInfo fontInfo) {
        Font font = fontInfo.getFont();
        FontRenderContext frc = fontInfo.getFontRenderContext();
        JsPair type = new JsPair(HASH_FAMILY, FontUtils.getRootFamilyName(font));
        JsPair size = new JsPair(HASH_SIZE, font.getSize());
        JsPair bold = new JsPair(HASH_ISBOLD, font.isBold());
        JsPair italic = new JsPair(HASH_ISITALIC, font.isItalic());
        JsPair host = new JsPair(HASH_USEAA, frc.isAntiAliased());
        JsPair port = new JsPair(HASH_FRACTIONAL, frc.usesFractionalMetrics());
        JsObject result = new JsObject();
        result.putPair(type);
        result.putPair(size);
        result.putPair(bold);
        result.putPair(italic);
        result.putPair(host);
        result.putPair(port);
        return result;
    }

    public static FontInfo decodeJson(JsObject obj) {
        JsString string;
        Font decoded;
        Font newFont = FontUtils.createDefaultSpeechFont();
        FontRenderContext newFrc = FontInfo.createBestContext(newFont);
        int style = newFont.getStyle();
        JsValue value = obj.getValue(HASH_FAMILY);
        if (value instanceof JsString && (decoded = Font.decode((string = (JsString)value).toRawString())) != null) {
            newFont = decoded;
        }
        int size = newFont.getSize();
        value = obj.getValue(HASH_SIZE);
        if (value instanceof JsNumber) {
            JsNumber number = (JsNumber)value;
            size = number.intValue();
        }
        boolean isBold = newFont.isBold();
        value = obj.getValue(HASH_ISBOLD);
        if (value instanceof JsBoolean) {
            JsBoolean bool = (JsBoolean)value;
            isBold = bool.booleanValue();
        }
        if (isBold) {
            style |= 1;
        }
        boolean isItalic = newFont.isItalic();
        value = obj.getValue(HASH_ISITALIC);
        if (value instanceof JsBoolean) {
            JsBoolean bool = (JsBoolean)value;
            isItalic = bool.booleanValue();
        }
        if (isItalic) {
            style |= 2;
        }
        boolean isAntiAlias = newFrc.isAntiAliased();
        value = obj.getValue(HASH_USEAA);
        if (value instanceof JsBoolean) {
            JsBoolean bool = (JsBoolean)value;
            isAntiAlias = bool.booleanValue();
        }
        boolean useFractional = newFrc.usesFractionalMetrics();
        value = obj.getValue(HASH_FRACTIONAL);
        if (value instanceof JsBoolean) {
            JsBoolean bool = (JsBoolean)value;
            useFractional = bool.booleanValue();
        }
        newFont = newFont.deriveFont(style, size);
        newFrc = new FontRenderContext(ImtblAffineTx.IDENTITY, isAntiAlias, useFractional);
        FontInfo result = new FontInfo(newFont, newFrc);
        return result;
    }

    public Font getFont() {
        return this.font;
    }

    public FontRenderContext getFontRenderContext() {
        return this.context;
    }

    public FontInfo deriveFont(Font newFont) {
        return new FontInfo(newFont, this.context);
    }

    public FontInfo deriveRenderContext(FontRenderContext newContext) {
        return new FontInfo(this.font, newContext);
    }

    public GlyphVector createGlyphVector(CharacterIterator iterator) {
        GlyphVector glyph = this.font.createGlyphVector(this.context, iterator);
        return glyph;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FontInfo)) {
            return false;
        }
        FontInfo target = (FontInfo)obj;
        if (!this.font.equals(target.font)) {
            return false;
        }
        return this.context.equals(target.context);
    }

    public int hashCode() {
        return this.font.hashCode() ^ this.context.hashCode();
    }
}

