/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorConvertOp;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import jp.sourceforge.jindolf.Jindolf;

public final class GUIUtils {
    private static final String RES_LOGOICON = "resources/image/logo.png";
    private static final String RES_WINDOWICON = "resources/image/winicon.png";
    private static final String RES_WWWICON = "resources/image/www.png";
    private static final String RES_NOIMAGE = "resources/image/noimage.png";
    private static BufferedImage logoImage;
    private static Icon logoIcon;
    private static BufferedImage windowIconImage;
    private static Icon wwwIcon;
    private static BufferedImage noImage;
    private static final RenderingHints HINTS_QUALITY;
    private static final RenderingHints HINTS_SPEEDY;
    private static final BufferedImageOp OP_MONOIMG;
    private static final Runnable TASK_NOTHING;

    private GUIUtils() {
        assert (false);
        throw new AssertionError();
    }

    public static RenderingHints getQualityHints() {
        return HINTS_QUALITY;
    }

    public static BufferedImage loadImageFromResource(String resource) throws IOException {
        URL url = Jindolf.getResource(resource);
        BufferedImage result = ImageIO.read(url);
        return result;
    }

    public static BufferedImage getLogoImage() {
        BufferedImage image;
        if (logoImage != null) {
            return logoImage;
        }
        try {
            image = GUIUtils.loadImageFromResource(RES_LOGOICON);
        }
        catch (IOException e) {
            Jindolf.logger().warn("\u30ed\u30b4\u30a4\u30e1\u30fc\u30b8\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
            image = new BufferedImage(100, 100, 2);
        }
        logoImage = image;
        return logoImage;
    }

    public static BufferedImage getWindowIconImage() {
        BufferedImage image;
        if (windowIconImage != null) {
            return windowIconImage;
        }
        try {
            image = GUIUtils.loadImageFromResource(RES_WINDOWICON);
        }
        catch (IOException e) {
            Jindolf.logger().warn("\u30a2\u30a4\u30b3\u30f3\u30a4\u30e1\u30fc\u30b8\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
            image = GUIUtils.getLogoImage();
        }
        windowIconImage = image;
        return windowIconImage;
    }

    public static Icon getLogoIcon() {
        if (logoIcon != null) {
            return logoIcon;
        }
        ImageIcon icon = new ImageIcon(GUIUtils.getLogoImage());
        logoIcon = icon;
        return logoIcon;
    }

    public static Icon getWWWIcon() {
        if (wwwIcon != null) {
            return wwwIcon;
        }
        URL url = Jindolf.getResource(RES_WWWICON);
        wwwIcon = new ImageIcon(url);
        return wwwIcon;
    }

    public static BufferedImage getNoImage() {
        if (noImage != null) {
            return noImage;
        }
        URL url = Jindolf.getResource(RES_NOIMAGE);
        try {
            noImage = ImageIO.read(url);
        }
        catch (IOException e) {
            assert (false);
            noImage = GUIUtils.getLogoImage();
        }
        return noImage;
    }

    public static void dispatchEmptyAWTEvent() {
        if (SwingUtilities.isEventDispatchThread()) {
            return;
        }
        try {
            SwingUtilities.invokeAndWait(TASK_NOTHING);
        }
        catch (InterruptedException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public static int getDirection(Rectangle rect, Point pt) {
        if (pt.y < rect.y) {
            return 1;
        }
        if (rect.y + rect.height <= pt.y) {
            return 5;
        }
        if (pt.x < rect.x) {
            return 3;
        }
        if (rect.x + rect.width <= pt.x) {
            return 7;
        }
        return 0;
    }

    public static void modifyWindowAttributes(Window window, boolean isResizable, boolean isDynamic, boolean isAutoLocation) {
        Toolkit kit = window.getToolkit();
        kit.setDynamicLayout(isDynamic);
        window.setLocationByPlatform(isAutoLocation);
        if (window instanceof Frame) {
            Frame frame = (Frame)window;
            frame.setIconImage(GUIUtils.getWindowIconImage());
            frame.setResizable(isResizable);
        } else if (window instanceof Dialog) {
            Dialog dialog = (Dialog)window;
            dialog.setResizable(isResizable);
        }
    }

    public static void addMargin(Component comp, int top, int left, int bottom, int right) {
        if (!(comp instanceof JComponent)) {
            return;
        }
        JComponent jcomp = (JComponent)comp;
        Border outer = jcomp.getBorder();
        Border inner = BorderFactory.createEmptyBorder(top, left, bottom, right);
        Border border = outer == null ? inner : BorderFactory.createCompoundBorder(outer, inner);
        jcomp.setBorder(border);
    }

    public static void replaceEventQueue() {
        Toolkit kit = Toolkit.getDefaultToolkit();
        EventQueue oldQueue = kit.getSystemEventQueue();
        EventQueue newQueue = new EventQueue(){
            private static final String FATALMSG = "\u30a4\u30d9\u30f3\u30c8\u30c7\u30a3\u30b9\u30d1\u30c3\u30c1\u4e2d\u306b\u7570\u5e38\u304c\u8d77\u304d\u307e\u3057\u305f\u3002";

            protected void dispatchEvent(AWTEvent event) {
                try {
                    super.dispatchEvent(event);
                }
                catch (RuntimeException e) {
                    Jindolf.logger().fatal(FATALMSG, e);
                    throw e;
                }
                catch (Exception e) {
                    Jindolf.logger().fatal(FATALMSG, e);
                }
                catch (Error e) {
                    Jindolf.logger().fatal(FATALMSG, e);
                    throw e;
                }
            }
        };
        oldQueue.push(newQueue);
    }

    public static BufferedImage createMonoImage(BufferedImage image) {
        BufferedImage result = OP_MONOIMG.filter(image, null);
        return result;
    }

    static {
        TASK_NOTHING = new Runnable(){

            public void run() {
            }
        };
        HINTS_QUALITY = new RenderingHints(null);
        HINTS_SPEEDY = new RenderingHints(null);
        HINTS_QUALITY.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        HINTS_SPEEDY.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        HINTS_QUALITY.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        HINTS_SPEEDY.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        HINTS_QUALITY.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        HINTS_SPEEDY.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        HINTS_QUALITY.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        HINTS_SPEEDY.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        HINTS_QUALITY.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        HINTS_SPEEDY.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        HINTS_QUALITY.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        HINTS_SPEEDY.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        HINTS_QUALITY.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        HINTS_SPEEDY.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        HINTS_QUALITY.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        HINTS_SPEEDY.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        HINTS_QUALITY.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        HINTS_SPEEDY.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        ColorSpace mono = ColorSpace.getInstance(1003);
        OP_MONOIMG = new ColorConvertOp(mono, null);
    }
}

