/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.jindolf.CmdOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionInfo {
    private static final Pattern PATTERN_GEOMETRY = Pattern.compile("([1-9][0-9]*)x([1-9][0-9]*)(?:(\\+|\\-)([1-9][0-9]*)(\\+|\\-)([1-9][0-9]*))?");
    private Integer frameWidth = null;
    private Integer frameHeight = null;
    private Integer frameXpos = null;
    private Integer frameYpos = null;
    private final List<String> invokeArgs = new LinkedList<String>();
    private final List<CmdOption> optionList = new LinkedList<CmdOption>();
    private final Map<CmdOption, Boolean> boolOptionMap = new EnumMap<CmdOption, Boolean>(CmdOption.class);
    private final Map<CmdOption, String> stringOptionMap = new EnumMap<CmdOption, String>(CmdOption.class);

    protected OptionInfo() {
    }

    public static OptionInfo parseOptions(String[] args) throws IllegalArgumentException {
        OptionInfo result = new OptionInfo();
        result.invokeArgs.clear();
        for (String arg : args) {
            if (arg == null || arg.length() <= 0) continue;
            result.invokeArgs.add(arg);
        }
        Iterator<String> iterator = result.invokeArgs.iterator();
        block7: while (iterator.hasNext()) {
            String arg = iterator.next();
            CmdOption option = CmdOption.parseCmdOption(arg);
            if (option == null) {
                throw new IllegalArgumentException("\u672a\u5b9a\u7fa9\u306e\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3[" + arg + "]\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f\u3002");
            }
            result.optionList.add(option);
            if (CmdOption.isIndepOption(option)) continue;
            if (CmdOption.isBooleanOption(option)) {
                Boolean bool = OptionInfo.parseBooleanSwitch(arg, iterator);
                result.boolOptionMap.put(option, bool);
                continue;
            }
            switch (option) {
                case OPT_INITFONT: 
                case OPT_CONFDIR: {
                    OptionInfo.checkNextArg(arg, iterator);
                    result.stringOptionMap.put(option, iterator.next());
                    break;
                }
                case OPT_GEOMETRY: {
                    OptionInfo.checkNextArg(arg, iterator);
                    String geometry = iterator.next();
                    Matcher matcher = PATTERN_GEOMETRY.matcher(geometry);
                    if (!matcher.matches()) {
                        throw new IllegalArgumentException("\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3[" + arg + "]\u306e\u5f15\u6570\u5f62\u5f0f[" + geometry + "]\u304c\u4e0d\u6b63\u3067\u3059\u3002");
                    }
                    String width = matcher.group(1);
                    String height = matcher.group(2);
                    String xSign = matcher.group(3);
                    String xPos = matcher.group(4);
                    String ySign = matcher.group(5);
                    String yPos = matcher.group(6);
                    try {
                        result.frameWidth = Integer.parseInt(width);
                        result.frameHeight = Integer.parseInt(height);
                        if (xPos != null && xPos.length() > 0) {
                            result.frameXpos = Integer.parseInt(xPos);
                            if (xSign.equals("-")) {
                                result.frameXpos = -result.frameXpos.intValue();
                            }
                        }
                        if (yPos == null || yPos.length() <= 0) continue block7;
                        result.frameYpos = Integer.parseInt(yPos);
                        if (!ySign.equals("-")) continue block7;
                        result.frameYpos = -result.frameYpos.intValue();
                        break;
                    }
                    catch (NumberFormatException e) {
                        assert (false);
                        throw new IllegalArgumentException(e);
                    }
                }
                default: {
                    assert (false);
                    continue block7;
                }
            }
        }
        return result;
    }

    private static Boolean parseBooleanSwitch(String option, Iterator<String> iterator) throws IllegalArgumentException {
        Boolean result;
        OptionInfo.checkNextArg(option, iterator);
        String onoff = iterator.next();
        if (onoff.compareToIgnoreCase("on") == 0 || onoff.compareToIgnoreCase("yes") == 0 || onoff.compareToIgnoreCase("true") == 0) {
            result = Boolean.TRUE;
        } else if (onoff.compareToIgnoreCase("off") == 0 || onoff.compareToIgnoreCase("no") == 0 || onoff.compareToIgnoreCase("false") == 0) {
            result = Boolean.FALSE;
        } else {
            throw new IllegalArgumentException("\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3[" + option + "]\u306e\u5f15\u6570\u5f62\u5f0f[" + onoff + "]\u304c\u4e0d\u6b63\u3067\u3059\u3002" + "on, off, yes, no, true, false" + "\u306e\u3044\u305a\u308c\u304b\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        return result;
    }

    private static void checkNextArg(CharSequence option, Iterator<String> iterator) throws IllegalArgumentException {
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException("\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3[" + option + "]\u306b\u5f15\u6570\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
        }
    }

    public List<String> getInvokeArgList() {
        return Collections.unmodifiableList(this.invokeArgs);
    }

    public boolean hasOption(CmdOption option) {
        return this.optionList.contains((Object)option);
    }

    public Boolean getBooleanArg(CmdOption option) throws IllegalArgumentException {
        if (!CmdOption.isBooleanOption(option)) {
            throw new IllegalArgumentException();
        }
        Boolean result = this.boolOptionMap.get((Object)option);
        return result;
    }

    public String getStringArg(CmdOption option) {
        String result = this.stringOptionMap.get((Object)option);
        return result;
    }

    public CmdOption getExclusiveOption(CmdOption ... options) {
        CmdOption result = null;
        block0: for (CmdOption option : this.optionList) {
            for (CmdOption excOption : options) {
                if (option != excOption) continue;
                result = option;
                continue block0;
            }
        }
        return result;
    }

    public Integer initialFrameWidth() {
        return this.frameWidth;
    }

    public Integer initialFrameHeight() {
        return this.frameHeight;
    }

    public Integer initialFrameXpos() {
        return this.frameXpos;
    }

    public Integer initialFrameYpos() {
        return this.frameYpos;
    }
}

