/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jp.sourceforge.jindolf.json.JsBoolean;
import jp.sourceforge.jindolf.json.JsObject;
import jp.sourceforge.jindolf.json.JsPair;
import jp.sourceforge.jindolf.json.JsString;
import jp.sourceforge.jindolf.json.JsValue;

public class RegexPattern {
    public static final int IGNORECASEFLAG = 66;
    private static final String REGEX_DELIM = "[\\s\u3000]+";
    private static final String REGEX_CHAR = ".?+*\\$(|)[]{}^-&";
    private final String editSource;
    private final boolean isRegex;
    private final Pattern pattern;
    private final String comment;

    public RegexPattern(String editSource, boolean isRegex, int flag, String comment) throws PatternSyntaxException {
        String regexExpr;
        if (editSource == null) {
            throw new NullPointerException();
        }
        this.isRegex = isRegex;
        this.comment = comment != null ? comment : "";
        if (this.isRegex) {
            regexExpr = this.editSource = editSource;
        } else {
            String[] tokens;
            String newSource = "";
            regexExpr = "";
            for (String token : tokens = editSource.split(REGEX_DELIM)) {
                if (token == null || token.length() <= 0) continue;
                newSource = newSource.length() <= 0 ? token : newSource + " " + token;
                String quoted = "(?:" + RegexPattern.quote(token) + ")";
                regexExpr = regexExpr.length() <= 0 ? quoted : regexExpr + "|" + quoted;
            }
            this.editSource = newSource;
        }
        this.pattern = Pattern.compile(regexExpr, flag);
    }

    public RegexPattern(String editSource, boolean isRegex, int flag) throws PatternSyntaxException {
        this(editSource, isRegex, flag, " ");
    }

    public static boolean hasRegexChar(CharSequence seq) {
        int length = seq.length();
        for (int pt = 0; pt < length; ++pt) {
            char ch = seq.charAt(pt);
            if (REGEX_CHAR.indexOf(ch) < 0) continue;
            return true;
        }
        return false;
    }

    public static String quote(String text) {
        if (RegexPattern.hasRegexChar(text)) {
            return Pattern.quote(text);
        }
        return text;
    }

    public static JsObject encodeJson(RegexPattern regex) {
        JsObject result = new JsObject();
        int regexFlag = regex.getRegexFlag();
        boolean flagDotall = (regexFlag & 0x20) != 0;
        boolean flagMultiline = (regexFlag & 8) != 0;
        boolean flagIgnoreCase = (regexFlag & 0x42) != 0;
        JsPair source = new JsPair("source", regex.getEditSource());
        JsPair isRegex = new JsPair("isRegex", regex.isRegex());
        JsPair dotall = new JsPair("dotall", flagDotall);
        JsPair multiline = new JsPair("multiline", flagMultiline);
        JsPair ignorecase = new JsPair("ignorecase", flagIgnoreCase);
        JsPair comment = new JsPair("comment", regex.getComment());
        result.putPair(source);
        result.putPair(isRegex);
        result.putPair(dotall);
        result.putPair(multiline);
        result.putPair(ignorecase);
        result.putPair(comment);
        return result;
    }

    public static RegexPattern decodeJson(JsObject object) {
        JsValue value = object.getValue("source");
        String source = value instanceof JsString ? ((JsString)value).toRawString() : "";
        value = object.getValue("isRegex");
        boolean isRegex = value instanceof JsBoolean ? ((JsBoolean)value).booleanValue() : false;
        int regexFlag = 0;
        value = object.getValue("dotall");
        if (value instanceof JsBoolean && ((JsBoolean)value).isTrue()) {
            regexFlag |= 0x20;
        }
        if ((value = object.getValue("multiline")) instanceof JsBoolean && ((JsBoolean)value).isTrue()) {
            regexFlag |= 8;
        }
        if ((value = object.getValue("ignorecase")) instanceof JsBoolean && ((JsBoolean)value).isTrue()) {
            regexFlag |= 0x42;
        }
        String comment = (value = object.getValue("comment")) instanceof JsString ? ((JsString)value).toRawString() : "";
        RegexPattern result = new RegexPattern(source, isRegex, regexFlag, comment);
        return result;
    }

    public String getEditSource() {
        return this.editSource;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isRegex() {
        return this.isRegex;
    }

    public int getRegexFlag() {
        return this.pattern.flags();
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String toString() {
        return this.editSource;
    }

    public boolean equals(Object obj) {
        String otherPattern;
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegexPattern)) {
            return false;
        }
        RegexPattern other = (RegexPattern)obj;
        String thisPattern = this.pattern.pattern();
        if (!thisPattern.equals(otherPattern = other.pattern.pattern())) {
            return false;
        }
        return this.pattern.flags() == other.pattern.flags();
    }

    public int hashCode() {
        int hash = this.pattern.pattern().hashCode();
        return hash ^= this.pattern.flags();
    }
}

