/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import jp.sourceforge.jindolf.AccountCookie;
import jp.sourceforge.jindolf.HtmlSequence;
import jp.sourceforge.jindolf.HttpUtils;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.Period;
import jp.sourceforge.jindolf.TallyInputStream;
import jp.sourceforge.jindolf.TallyOutputStream;
import jp.sourceforge.jindolf.Village;
import jp.sourceforge.jindolf.parser.ContentBuilder;
import jp.sourceforge.jindolf.parser.ContentBuilderSJ;
import jp.sourceforge.jindolf.parser.ContentBuilderUCS2;
import jp.sourceforge.jindolf.parser.DecodeException;
import jp.sourceforge.jindolf.parser.DecodedContent;
import jp.sourceforge.jindolf.parser.SjisDecoder;
import jp.sourceforge.jindolf.parser.StreamDecoder;

public class ServerAccess {
    private static final String USER_AGENT = HttpUtils.getUserAgentName();
    private static final String JINRO_CGI = "./index.rb";
    private static final Map<String, SoftReference<BufferedImage>> IMAGE_CACHE;
    private final URL baseURL;
    private final Charset charset;
    private Proxy proxy = Proxy.NO_PROXY;
    private long lastServerMs;
    private long lastLocalMs;
    private long lastSystemMs;
    private AccountCookie cookieAuth = null;
    private String encodedUserID = null;

    public ServerAccess(URL baseURL, Charset charset) {
        this.baseURL = baseURL;
        this.charset = charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage getImageCache(String key) {
        BufferedImage image;
        if (key == null) {
            return null;
        }
        Map<String, SoftReference<BufferedImage>> map = IMAGE_CACHE;
        synchronized (map) {
            SoftReference<BufferedImage> ref = IMAGE_CACHE.get(key);
            if (ref == null) {
                return null;
            }
            BufferedImage referent = ref.get();
            if (referent == null) {
                IMAGE_CACHE.remove(key);
                return null;
            }
            image = referent;
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putImageCache(String key, BufferedImage image) {
        if (key == null || image == null) {
            return;
        }
        Map<String, SoftReference<BufferedImage>> map = IMAGE_CACHE;
        synchronized (map) {
            if (ServerAccess.getImageCache(key) != null) {
                return;
            }
            SoftReference<BufferedImage> ref = new SoftReference<BufferedImage>(image);
            IMAGE_CACHE.put(key, ref);
        }
    }

    public static String formEncode(String formData) {
        String result;
        if (formData == null) {
            return null;
        }
        try {
            result = URLEncoder.encode(formData, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            assert (false);
            result = null;
        }
        return result;
    }

    public static String formEncode(char[] formData) {
        return ServerAccess.formEncode(new String(formData));
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy == null ? Proxy.NO_PROXY : proxy;
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    protected URL getQueryURL(String query) {
        URL result;
        if (query.length() >= 1 && query.charAt(0) != '?') {
            return null;
        }
        try {
            result = new URL(this.getBaseURL(), JINRO_CGI + query);
        }
        catch (MalformedURLException e) {
            assert (false);
            return null;
        }
        return result;
    }

    public DecodedContent downloadHTMLStream(InputStream istream) throws IOException {
        ContentBuilder builder;
        StreamDecoder decoder;
        if (this.charset.name().equalsIgnoreCase("Shift_JIS")) {
            decoder = new SjisDecoder();
            builder = new ContentBuilderSJ(204800);
        } else if (this.charset.name().equalsIgnoreCase("UTF-8")) {
            decoder = new StreamDecoder(this.charset.newDecoder());
            builder = new ContentBuilderUCS2(204800);
        } else {
            assert (false);
            return null;
        }
        decoder.setDecodeHandler(builder);
        try {
            decoder.decode(istream);
        }
        catch (DecodeException e) {
            return null;
        }
        return builder.getContent();
    }

    protected HtmlSequence downloadHTML(String query) throws IOException {
        URL url = this.getQueryURL(query);
        HtmlSequence result = this.downloadHTML(url);
        return result;
    }

    protected HtmlSequence downloadHTML(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection(this.proxy);
        connection.setRequestProperty("Accept", "*/*");
        connection.setRequestProperty("User-Agent", USER_AGENT);
        connection.setUseCaches(false);
        connection.setInstanceFollowRedirects(false);
        connection.setDoInput(true);
        connection.setRequestMethod("GET");
        AccountCookie cookie = this.cookieAuth;
        if (cookie != null) {
            if (ServerAccess.shouldAccept(url, cookie)) {
                connection.setRequestProperty("Cookie", "login=" + cookie.getLoginData());
            } else {
                this.clearAuthentication();
            }
        }
        connection.connect();
        long datems = this.updateLastAccess(connection);
        int responseCode = connection.getResponseCode();
        if (responseCode != 200) {
            String logMessage = "\u767a\u8a00\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
            logMessage = logMessage + HttpUtils.formatHttpStat(connection, 0L, 0L);
            Jindolf.logger().warn(logMessage);
            return null;
        }
        String cs = HttpUtils.getHTMLCharset(connection);
        if (!cs.equalsIgnoreCase(this.charset.name())) {
            return null;
        }
        InputStream stream = TallyInputStream.getInputStream(connection);
        DecodedContent html = this.downloadHTMLStream(stream);
        stream.close();
        connection.disconnect();
        HtmlSequence hseq = new HtmlSequence(url, datems, html);
        return hseq;
    }

    public BufferedImage downloadImage(String url) throws IOException {
        URL absolute;
        try {
            URL base = this.getBaseURL();
            absolute = new URL(base, url);
        }
        catch (MalformedURLException e) {
            assert (false);
            return null;
        }
        BufferedImage image = ServerAccess.getImageCache(absolute.toString());
        if (image != null) {
            return image;
        }
        HttpURLConnection connection = (HttpURLConnection)absolute.openConnection(this.proxy);
        connection.setRequestProperty("Accept", "*/*");
        connection.setRequestProperty("User-Agent", USER_AGENT);
        connection.setUseCaches(true);
        connection.setInstanceFollowRedirects(true);
        connection.setDoInput(true);
        connection.setRequestMethod("GET");
        connection.connect();
        int responseCode = connection.getResponseCode();
        if (responseCode != 200) {
            String logMessage = "\u30a4\u30e1\u30fc\u30b8\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
            logMessage = logMessage + HttpUtils.formatHttpStat(connection, 0L, 0L);
            Jindolf.logger().warn(logMessage);
            return null;
        }
        InputStream stream = TallyInputStream.getInputStream(connection);
        image = ImageIO.read(stream);
        stream.close();
        connection.disconnect();
        ServerAccess.putImageCache(absolute.toString(), image);
        return image;
    }

    protected boolean postAuthData(String authData) throws IOException {
        URL url = this.getQueryURL("");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection(this.proxy);
        connection.setRequestProperty("Accept", "*/*");
        connection.setRequestProperty("User-Agent", USER_AGENT);
        connection.setUseCaches(false);
        connection.setInstanceFollowRedirects(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        byte[] authBytes = authData.getBytes();
        OutputStream os = TallyOutputStream.getOutputStream(connection);
        os.write(authBytes);
        os.flush();
        os.close();
        this.updateLastAccess(connection);
        int responseCode = connection.getResponseCode();
        if (responseCode != 302) {
            String logMessage = "\u8a8d\u8a3c\u60c5\u5831\u306e\u9001\u4fe1\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
            Jindolf.logger().warn(logMessage);
            connection.disconnect();
            return false;
        }
        connection.disconnect();
        AccountCookie loginCookie = AccountCookie.createCookie(connection);
        if (loginCookie == null) {
            return false;
        }
        this.setAuthentication(loginCookie);
        Jindolf.logger().info("\u6b63\u3057\u304f\u8a8d\u8a3c\u304c\u884c\u308f\u308c\u307e\u3057\u305f\u3002");
        return true;
    }

    public HtmlSequence getHTMLTopPage() throws IOException {
        return this.downloadHTML("");
    }

    public HtmlSequence getHTMLLandList() throws IOException {
        return this.downloadHTML("?cmd=log");
    }

    public HtmlSequence getHTMLBoneHead(Village village) throws IOException {
        String villageID = village.getVillageID();
        return this.downloadHTML("?vid=" + villageID + "&meslog=");
    }

    public HtmlSequence getHTMLVillage(Village village) throws IOException {
        URL url = this.getVillageURL(village);
        return this.downloadHTML(url);
    }

    public URL getVillageURL(Village village) {
        String villageID = village.getVillageID();
        URL url = this.getQueryURL("?vid=" + villageID);
        return url;
    }

    public HtmlSequence getHTMLPeriod(Period period) throws IOException {
        URL url = this.getPeriodURL(period);
        return this.downloadHTML(url);
    }

    public URL getPeriodURL(Period period) {
        String query = period.getCGIQuery();
        URL url = this.getQueryURL(query);
        return url;
    }

    public long updateLastAccess(HttpURLConnection connection) {
        this.lastServerMs = connection.getDate();
        this.lastLocalMs = System.currentTimeMillis();
        this.lastSystemMs = System.nanoTime() / 1000000L;
        return this.lastServerMs;
    }

    private static boolean shouldAccept(URL url, AccountCookie cookie) {
        String cookiePath;
        if (cookie.hasExpired()) {
            return false;
        }
        String urlPath = url.getPath();
        return urlPath.startsWith(cookiePath = cookie.getPathURI().getPath());
    }

    public boolean hasLoggedIn() {
        AccountCookie cookie = this.cookieAuth;
        if (cookie == null) {
            return false;
        }
        if (cookie.hasExpired()) {
            this.clearAuthentication();
            return false;
        }
        return true;
    }

    public final boolean login(String userID, char[] password) throws IOException {
        boolean result;
        if (this.hasLoggedIn()) {
            return true;
        }
        String id = ServerAccess.formEncode(userID);
        if (id == null || id.length() <= 0) {
            return false;
        }
        String pw = ServerAccess.formEncode(password);
        if (pw == null || pw.length() <= 0) {
            return false;
        }
        this.encodedUserID = id;
        String redirect = ServerAccess.formEncode("&#bottom");
        StringBuilder postData = new StringBuilder();
        postData.append("cmd=login");
        postData.append('&').append("cgi_param=").append(redirect);
        postData.append('&').append("user_id=").append(id);
        postData.append('&').append("password=").append(pw);
        try {
            result = this.postAuthData(postData.toString());
        }
        catch (IOException e) {
            this.clearAuthentication();
            throw e;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout() throws IOException {
        if (!this.hasLoggedIn()) {
            return;
        }
        if (this.encodedUserID == null) {
            this.clearAuthentication();
            return;
        }
        String redirect = ServerAccess.formEncode("&#bottom");
        StringBuilder postData = new StringBuilder();
        postData.append("cmd=logout");
        postData.append('&').append("cgi_param=").append(redirect);
        postData.append('&').append("user_id=").append(this.encodedUserID);
        try {
            this.postAuthData(postData.toString());
        }
        finally {
            this.clearAuthentication();
        }
    }

    protected void clearAuthentication() {
        this.cookieAuth = null;
        this.encodedUserID = null;
    }

    private void setAuthentication(AccountCookie cookie) {
        this.cookieAuth = cookie;
    }

    static {
        HashMap cache = new HashMap();
        IMAGE_CACHE = Collections.synchronizedMap(cache);
    }
}

