/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import jp.sfjp.jindolf.Jindolf;

public final class ResourceManager {
    public static final char RES_SEPCHAR = '/';
    public static final char PKG_SEPCHAR = '.';
    public static final String RES_SEPARATOR = Character.toString('/');
    public static final String PKG_SEPARATOR = Character.toString('.');
    public static final Package DEF_ROOT_PACKAGE;
    public static final ClassLoader DEF_LOADER;
    private static final Charset CS_UTF8;

    private ResourceManager() {
        assert (false);
    }

    public static boolean isAbsoluteResourcePath(String resPath) {
        return resPath.startsWith(RES_SEPARATOR);
    }

    public static String getResourcePrefix(Package pkg) {
        if (pkg == null) {
            return "";
        }
        String pkgName = pkg.getName();
        String result = pkgName.replace('.', '/');
        if (result.length() > 0) {
            result = result + RES_SEPARATOR;
        }
        return result;
    }

    public static URL getResource(String resPath) {
        return ResourceManager.getResource(DEF_ROOT_PACKAGE, resPath);
    }

    public static URL getResource(Package rootPkg, String resPath) {
        return ResourceManager.getResource(DEF_LOADER, rootPkg, resPath);
    }

    public static URL getResource(ClassLoader loader, Package rootPkg, String resPath) {
        String fullName;
        if (ResourceManager.isAbsoluteResourcePath(resPath)) {
            fullName = resPath.substring(1);
        } else {
            String pfx = ResourceManager.getResourcePrefix(rootPkg);
            fullName = pfx + resPath;
        }
        URL result = loader.getResource(fullName);
        return result;
    }

    public static InputStream getResourceAsStream(String resPath) {
        return ResourceManager.getResourceAsStream(DEF_ROOT_PACKAGE, resPath);
    }

    public static InputStream getResourceAsStream(Package rootPkg, String resPath) {
        return ResourceManager.getResourceAsStream(DEF_LOADER, rootPkg, resPath);
    }

    public static InputStream getResourceAsStream(ClassLoader loader, Package rootPkg, String resPath) {
        InputStream result;
        URL url = ResourceManager.getResource(loader, rootPkg, resPath);
        if (url == null) {
            return null;
        }
        try {
            result = url.openStream();
        }
        catch (IOException e) {
            result = null;
        }
        return result;
    }

    public static BufferedImage getBufferedImage(String resPath) {
        BufferedImage result;
        URL url = ResourceManager.getResource(resPath);
        if (url == null) {
            return null;
        }
        try {
            result = ImageIO.read(url);
        }
        catch (IOException e) {
            result = null;
        }
        return result;
    }

    public static ImageIcon getImageIcon(String resPath) {
        URL url = ResourceManager.getResource(resPath);
        if (url == null) {
            return null;
        }
        ImageIcon result = new ImageIcon(url);
        return result;
    }

    public static Properties getProperties(String resPath) {
        InputStream is = ResourceManager.getResourceAsStream(resPath);
        if (is == null) {
            return null;
        }
        is = new BufferedInputStream(is);
        Properties properties = new Properties();
        try {
            properties.load(is);
        }
        catch (IOException e) {
            properties = null;
        }
        try {
            is.close();
        }
        catch (IOException e) {
            properties = null;
        }
        return properties;
    }

    public static String getTextFile(String resPath) {
        InputStream is = ResourceManager.getResourceAsStream(resPath);
        if (is == null) {
            return null;
        }
        is = new BufferedInputStream(is);
        Reader reader = new InputStreamReader(is, CS_UTF8);
        reader = new BufferedReader(reader);
        LineNumberReader lineReader = new LineNumberReader(reader);
        StringBuilder result = new StringBuilder();
        while (true) {
            String line;
            try {
                line = lineReader.readLine();
            }
            catch (IOException e) {
                result = null;
                break;
            }
            if (line == null) break;
            if (line.startsWith("#")) continue;
            result.append(line).append('\n');
        }
        try {
            lineReader.close();
        }
        catch (IOException e) {
            result = null;
        }
        if (result == null) {
            return null;
        }
        return result.toString();
    }

    static {
        CS_UTF8 = Charset.forName("UTF-8");
        Class<Jindolf> rootKlass = Jindolf.class;
        DEF_ROOT_PACKAGE = rootKlass.getPackage();
        DEF_LOADER = rootKlass.getClassLoader();
    }
}

