/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.config;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.sfjp.jindolf.config.ConfigFile;
import jp.sfjp.jindolf.config.InterVMLock;
import jp.sourceforge.jovsonz.JsComposition;
import jp.sourceforge.jovsonz.JsObject;
import jp.sourceforge.jovsonz.JsParseException;
import jp.sourceforge.jovsonz.JsTypes;
import jp.sourceforge.jovsonz.JsVisitException;
import jp.sourceforge.jovsonz.Json;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigStore {
    public static final File HIST_FILE = new File("searchHistory.json");
    public static final File DRAFT_FILE = new File("draft.json");
    public static final File NETCONFIG_FILE = new File("netconfig.json");
    public static final File TALKCONFIG_FILE = new File("talkconfig.json");
    private static final String LOCKFILE = "lock";
    private static final Charset CHARSET_JSON = Charset.forName("UTF-8");
    private static final Logger LOGGER = Logger.getAnonymousLogger();
    private boolean useStoreFile;
    private boolean isImplicitPath;
    private File configPath;

    public ConfigStore(boolean useStoreFile, File configPath) {
        this(useStoreFile, true, configPath);
    }

    public ConfigStore(boolean useStoreFile, boolean isImplicitPath, File configPath) {
        this.useStoreFile = useStoreFile;
        this.isImplicitPath = this.useStoreFile ? isImplicitPath : true;
        this.configPath = this.useStoreFile ? configPath : null;
    }

    public boolean useStoreFile() {
        return this.useStoreFile;
    }

    public File getConfigPath() {
        File result = this.useStoreFile ? this.configPath : null;
        return result;
    }

    public void prepareConfigDir() {
        if (!this.useStoreFile) {
            return;
        }
        if (!this.configPath.exists()) {
            File created = ConfigFile.buildConfigDirectory(this.configPath, this.isImplicitPath);
            ConfigFile.checkAccessibility(created);
        } else {
            ConfigFile.checkAccessibility(this.configPath);
        }
    }

    public void tryLock() {
        if (!this.useStoreFile) {
            return;
        }
        File lockFile = new File(this.configPath, LOCKFILE);
        InterVMLock lock = new InterVMLock(lockFile);
        lock.tryLock();
        if (!lock.isFileOwner()) {
            ConfigFile.confirmLockError(lock);
            if (!lock.isFileOwner()) {
                this.useStoreFile = false;
                this.configPath = null;
            }
        }
    }

    public JsObject loadJsObject(File file) {
        JsComposition<?> root = this.loadJson(file);
        if (root == null || root.getJsTypes() != JsTypes.OBJECT) {
            return null;
        }
        JsObject result = (JsObject)root;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsComposition<?> loadJson(File file) {
        JsComposition<?> root;
        InputStream istream;
        File absFile;
        if (!this.useStoreFile) {
            return null;
        }
        if (file.isAbsolute()) {
            absFile = file;
        } else {
            if (this.configPath == null) {
                return null;
            }
            absFile = new File(this.configPath, file.getPath());
            if (!absFile.exists()) {
                return null;
            }
            if (!absFile.isAbsolute()) {
                return null;
            }
        }
        String absPath = absFile.getPath();
        try {
            istream = new FileInputStream(absFile);
        }
        catch (FileNotFoundException e) {
            assert (false);
            return null;
        }
        istream = new BufferedInputStream(istream);
        try {
            root = this.loadJson(istream);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "JSON\u30d5\u30a1\u30a4\u30eb[" + absPath + "]\u306e\u8aad\u307f\u8fbc\u307f\u6642\u306b\u652f\u969c\u304c\u3042\u308a\u307e\u3057\u305f\u3002", e);
            JsComposition<?> jsComposition = null;
            return jsComposition;
        }
        catch (JsParseException e) {
            LOGGER.log(Level.SEVERE, "JSON\u30d5\u30a1\u30a4\u30eb[" + absPath + "]\u306e\u5185\u5bb9\u306b\u4e0d\u5099\u304c\u3042\u308a\u307e\u3059\u3002", e);
            JsComposition<?> jsComposition = null;
            return jsComposition;
        }
        finally {
            try {
                istream.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "JSON\u30d5\u30a1\u30a4\u30eb[" + absPath + "]\u3092\u9589\u3058\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3002", e);
                return null;
            }
        }
        return root;
    }

    protected JsComposition<?> loadJson(InputStream is) throws IOException, JsParseException {
        Reader reader = new InputStreamReader(is, CHARSET_JSON);
        reader = new BufferedReader(reader);
        JsComposition<?> root = this.loadJson(reader);
        return root;
    }

    protected JsComposition<?> loadJson(Reader reader) throws IOException, JsParseException {
        JsComposition root = Json.parseJson(reader);
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveJson(File file, JsComposition<?> root) {
        OutputStream ostream;
        if (!this.useStoreFile) {
            return false;
        }
        File absFile = new File(this.configPath, file.getPath());
        String absPath = absFile.getPath();
        absFile.delete();
        try {
            if (!absFile.createNewFile()) {
                return false;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "JSON\u30d5\u30a1\u30a4\u30eb[" + absPath + "]\u306e\u65b0\u898f\u751f\u6210\u304c\u3067\u304d\u307e\u305b\u3093\u3002", e);
            return false;
        }
        try {
            ostream = new FileOutputStream(absFile);
        }
        catch (FileNotFoundException e) {
            assert (false);
            return false;
        }
        ostream = new BufferedOutputStream(ostream);
        try {
            this.saveJson(ostream, root);
        }
        catch (JsVisitException e) {
            LOGGER.log(Level.SEVERE, "JSON\u30d5\u30a1\u30a4\u30eb[" + absPath + "]\u306e\u51fa\u529b\u51e6\u7406\u3067\u652f\u969c\u304c\u3042\u308a\u307e\u3057\u305f\u3002", e);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "JSON\u30d5\u30a1\u30a4\u30eb[" + absPath + "]\u306e\u66f8\u304d\u8fbc\u307f\u6642\u306b\u652f\u969c\u304c\u3042\u308a\u307e\u3057\u305f\u3002", e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                ostream.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "JSON\u30d5\u30a1\u30a4\u30eb[" + absPath + "]\u3092\u9589\u3058\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3002", e);
                return false;
            }
        }
        return true;
    }

    protected void saveJson(OutputStream os, JsComposition<?> root) throws IOException, JsVisitException {
        Writer writer = new OutputStreamWriter(os, CHARSET_JSON);
        writer = new BufferedWriter(writer);
        this.saveJson(writer, root);
    }

    protected void saveJson(Writer writer, JsComposition<?> root) throws IOException, JsVisitException {
        Json.dumpJson(writer, root);
    }

    public JsObject loadHistoryConfig() {
        JsObject result = this.loadJsObject(HIST_FILE);
        return result;
    }

    public JsObject loadDraftConfig() {
        JsObject result = this.loadJsObject(DRAFT_FILE);
        return result;
    }

    public JsObject loadNetConfig() {
        JsObject result = this.loadJsObject(NETCONFIG_FILE);
        return result;
    }

    public JsObject loadTalkConfig() {
        JsObject result = this.loadJsObject(TALKCONFIG_FILE);
        return result;
    }

    public boolean saveHistoryConfig(JsComposition<?> root) {
        boolean result = this.saveJson(HIST_FILE, root);
        return result;
    }

    public boolean saveDraftConfig(JsComposition<?> root) {
        boolean result = this.saveJson(DRAFT_FILE, root);
        return result;
    }

    public boolean saveNetConfig(JsComposition<?> root) {
        boolean result = this.saveJson(NETCONFIG_FILE, root);
        return result;
    }

    public boolean saveTalkConfig(JsComposition<?> root) {
        boolean result = this.saveJson(TALKCONFIG_FILE, root);
        return result;
    }
}

