/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.data;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import jp.sfjp.jindolf.data.Avatar;
import jp.sfjp.jindolf.data.Topic;
import jp.sourceforge.jindolf.corelib.EventFamily;
import jp.sourceforge.jindolf.corelib.GameRole;
import jp.sourceforge.jindolf.corelib.SysEventType;
import jp.sourceforge.jindolf.parser.DecodedContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SysEvent
implements Topic {
    private EventFamily eventFamily;
    private SysEventType sysEventType;
    private DecodedContent content;
    private final List<Avatar> avatarList = new LinkedList<Avatar>();
    private final List<GameRole> roleList = new LinkedList<GameRole>();
    private final List<Integer> integerList = new LinkedList<Integer>();
    private final List<CharSequence> charseqList = new LinkedList<CharSequence>();

    public EventFamily getEventFamily() {
        return this.eventFamily;
    }

    public void setEventFamily(EventFamily eventFamily) throws NullPointerException {
        this.eventFamily = eventFamily;
    }

    public SysEventType getSysEventType() {
        return this.sysEventType;
    }

    public void setSysEventType(SysEventType type) throws NullPointerException {
        if (type == null) {
            throw new NullPointerException();
        }
        this.sysEventType = type;
    }

    public DecodedContent getContent() {
        return this.content;
    }

    public void setContent(DecodedContent content) throws NullPointerException {
        if (content == null) {
            throw new NullPointerException();
        }
        this.content = content;
    }

    public List<Avatar> getAvatarList() {
        List<Avatar> result = Collections.unmodifiableList(this.avatarList);
        return result;
    }

    public List<GameRole> getRoleList() {
        List<GameRole> result = Collections.unmodifiableList(this.roleList);
        return result;
    }

    public List<Integer> getIntegerList() {
        List<Integer> result = Collections.unmodifiableList(this.integerList);
        return result;
    }

    public List<CharSequence> getCharSequenceList() {
        List<CharSequence> result = Collections.unmodifiableList(this.charseqList);
        return result;
    }

    public void addAvatarList(List<Avatar> list) {
        this.avatarList.addAll(list);
    }

    public void addRoleList(List<GameRole> list) {
        this.roleList.addAll(list);
    }

    public void addIntegerList(List<Integer> list) {
        this.integerList.addAll(list);
    }

    public void addCharSequenceList(List<CharSequence> list) {
        this.charseqList.addAll(list);
    }

    public Avatar getExecutedAvatar() {
        Avatar result = null;
        switch (this.sysEventType) {
            case COUNTING: {
                Avatar lastAvatar;
                if (this.avatarList.isEmpty()) {
                    return null;
                }
                int avatarNum = this.avatarList.size();
                if (avatarNum % 2 == 0) break;
                result = lastAvatar = this.avatarList.get(avatarNum - 1);
                break;
            }
            case EXECUTION: {
                Avatar lastAvatar;
                if (this.avatarList.isEmpty()) {
                    return null;
                }
                int avatarNum = this.avatarList.size();
                List<Integer> intList = this.getIntegerList();
                int intNum = intList.size();
                assert (intNum > 0);
                if (avatarNum == intNum && intList.get(intNum - 1) > 0) break;
                result = lastAvatar = this.avatarList.get(avatarNum - 1);
                break;
            }
            case COUNTING2: {
                break;
            }
        }
        return result;
    }

    public Set<Avatar> getVoterSet(Set<Avatar> set) {
        Set<Avatar> result = set == null ? new HashSet<Avatar>() : set;
        if (this.sysEventType != SysEventType.COUNTING && this.sysEventType != SysEventType.COUNTING2) {
            return result;
        }
        int size = this.avatarList.size();
        assert (size >= 2);
        int limit = size - 1;
        if (size % 2 != 0) {
            --limit;
        }
        for (int idx = 0; idx <= limit; idx += 2) {
            Avatar avatar = this.avatarList.get(idx);
            result.add(avatar);
        }
        return result;
    }
}

