/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.dxchg;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;

public class ClipboardAction
extends TextAction {
    public static final String ACTION_CUT = "ACTION_CUT";
    public static final String ACTION_COPY = "ACTION_COPY";
    public static final String ACTION_PASTE = "ACTION_PASTE";
    public static final String ACTION_SELALL = "ACTION_SELALL";

    protected ClipboardAction(String name, String command) {
        super(name);
        this.setActionCommand(command);
    }

    public static void copyToClipboard(CharSequence data) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Clipboard clipboard = toolkit.getSystemClipboard();
        StringSelection selection = new StringSelection(((Object)data).toString());
        clipboard.setContents(selection, selection);
    }

    public static ClipboardAction cutAction() {
        return new ClipboardAction("\u9078\u629e\u7bc4\u56f2\u3092\u30ab\u30c3\u30c8", ACTION_CUT);
    }

    public static ClipboardAction copyAction() {
        return new ClipboardAction("\u9078\u629e\u7bc4\u56f2\u3092\u30b3\u30d4\u30fc", ACTION_COPY);
    }

    public static ClipboardAction pasteAction() {
        return new ClipboardAction("\u30da\u30fc\u30b9\u30c8", ACTION_PASTE);
    }

    public static ClipboardAction selectallAction() {
        return new ClipboardAction("\u3059\u3079\u3066\u9078\u629e", ACTION_SELALL);
    }

    private void setActionCommand(String actionCommand) {
        this.putValue("ActionCommandKey", actionCommand);
    }

    protected String getActionCommand() {
        Object value = this.getValue("ActionCommandKey");
        if (!(value instanceof String)) {
            return null;
        }
        String command = (String)value;
        return command;
    }

    public void actionPerformed(ActionEvent event) {
        JTextComponent textComp = this.getTextComponent(event);
        if (textComp == null) {
            return;
        }
        String command = this.getActionCommand();
        if (ACTION_CUT.equals(command)) {
            textComp.cut();
        } else if (ACTION_COPY.equals(command)) {
            textComp.copy();
        } else if (ACTION_PASTE.equals(command)) {
            textComp.paste();
        } else if (ACTION_SELALL.equals(command)) {
            textComp.selectAll();
        }
    }
}

