/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.glyph;

import java.awt.Rectangle;
import java.awt.font.GlyphVector;
import java.text.CharacterIterator;
import jp.sfjp.jindolf.glyph.FontInfo;
import jp.sfjp.jindolf.glyph.SequenceCharacterIterator;
import jp.sfjp.jindolf.glyph.TextRow;

public abstract class AbstractTextRow
implements TextRow {
    protected final Rectangle bounds = new Rectangle();
    protected FontInfo fontInfo;
    private boolean visible = true;

    protected AbstractTextRow() {
        this(FontInfo.DEFAULT_FONTINFO);
    }

    protected AbstractTextRow(FontInfo fontInfo) {
        this.fontInfo = fontInfo;
    }

    public Rectangle setWidth(int newWidth) {
        this.bounds.width = newWidth;
        this.recalcBounds();
        return this.bounds;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setPos(int xPos, int yPos) {
        this.bounds.x = xPos;
        this.bounds.y = yPos;
    }

    public int getWidth() {
        return this.bounds.width;
    }

    public int getHeight() {
        return this.bounds.height;
    }

    public void setFontInfo(FontInfo fontInfo) {
        this.fontInfo = fontInfo;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public GlyphVector createGlyphVector(CharacterIterator iterator) {
        return this.fontInfo.createGlyphVector(iterator);
    }

    public GlyphVector createGlyphVector(CharSequence seq) {
        SequenceCharacterIterator iterator = new SequenceCharacterIterator(seq);
        return this.fontInfo.createGlyphVector(iterator);
    }

    public GlyphVector createGlyphVector(CharSequence seq, int from, int to) {
        SequenceCharacterIterator iterator = new SequenceCharacterIterator(seq, from, to);
        return this.fontInfo.createGlyphVector(iterator);
    }
}

