/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.glyph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import jp.sfjp.jindolf.glyph.FontInfo;
import jp.sfjp.jindolf.glyph.GlyphDraw;

public class FontPreviewer
extends JComponent {
    private static final int MARGIN = 5;
    private final GlyphDraw draw;
    private FontInfo fontInfo;

    public FontPreviewer(CharSequence source, FontInfo fontInfo) {
        this.fontInfo = fontInfo;
        this.draw = new GlyphDraw(source, this.fontInfo);
        this.draw.setFontInfo(this.fontInfo);
        this.draw.setPos(5, 5);
        this.draw.setColor(Color.BLACK);
        this.setBackground(Color.WHITE);
        this.updateBounds();
    }

    private void updateBounds() {
        Rectangle bounds = this.draw.setWidth(Integer.MAX_VALUE);
        Dimension dimension = new Dimension(bounds.width + 10, bounds.height + 10);
        this.setPreferredSize(dimension);
        this.revalidate();
        this.repaint();
    }

    public void setFontInfo(FontInfo newFontInfo) {
        this.fontInfo = newFontInfo;
        this.draw.setFontInfo(this.fontInfo);
        this.updateBounds();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        this.draw.paint(g2d);
    }
}

