/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import jp.sfjp.jindolf.glyph.FontChooser;
import jp.sfjp.jindolf.glyph.FontInfo;
import jp.sfjp.jindolf.net.ProxyChooser;
import jp.sfjp.jindolf.util.GUIUtils;
import jp.sfjp.jindolf.view.DialogPrefPanel;

public class OptionPanel
extends JDialog
implements ActionListener,
WindowListener {
    private final JTabbedPane tabPane = new JTabbedPane();
    private final FontChooser fontChooser;
    private final ProxyChooser proxyChooser;
    private final DialogPrefPanel dialogPrefPanel;
    private final JButton okButton = new JButton("OK");
    private final JButton cancelButton = new JButton("\u30ad\u30e3\u30f3\u30bb\u30eb");
    private boolean isCanceled = false;

    public OptionPanel(Frame owner) {
        super(owner);
        this.setModal(true);
        GUIUtils.modifyWindowAttributes(this, true, false, true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.fontChooser = new FontChooser(FontInfo.DEFAULT_FONTINFO);
        this.proxyChooser = new ProxyChooser();
        this.dialogPrefPanel = new DialogPrefPanel();
        this.tabPane.add("\u30d5\u30a9\u30f3\u30c8", this.fontChooser);
        this.tabPane.add("\u30d7\u30ed\u30af\u30b7", this.proxyChooser);
        this.tabPane.add("\u767a\u8a00\u8868\u793a", this.dialogPrefPanel);
        this.design(this.getContentPane());
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
    }

    private void design(Container content) {
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        content.setLayout(layout);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.insets = new Insets(5, 5, 5, 5);
        content.add((Component)this.tabPane, constraints);
        constraints.weighty = 0.0;
        constraints.fill = 2;
        content.add((Component)new JSeparator(), constraints);
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 13;
        content.add((Component)this.okButton, constraints);
        constraints.weightx = 0.0;
        content.add((Component)this.cancelButton, constraints);
    }

    public FontChooser getFontChooser() {
        return this.fontChooser;
    }

    public ProxyChooser getProxyChooser() {
        return this.proxyChooser;
    }

    public DialogPrefPanel getDialogPrefPanel() {
        return this.dialogPrefPanel;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    private void actionOk() {
        this.isCanceled = false;
        this.setVisible(false);
        this.dispose();
    }

    private void actionCancel() {
        this.isCanceled = true;
        this.setVisible(false);
        this.dispose();
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.okButton) {
            this.actionOk();
        } else if (source == this.cancelButton) {
            this.actionCancel();
        }
    }

    public void windowOpened(WindowEvent event) {
    }

    public void windowClosing(WindowEvent event) {
        this.actionCancel();
    }

    public void windowClosed(WindowEvent event) {
    }

    public void windowActivated(WindowEvent event) {
    }

    public void windowDeactivated(WindowEvent event) {
    }

    public void windowIconified(WindowEvent event) {
    }

    public void windowDeiconified(WindowEvent event) {
    }
}

