/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.view;

import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import jp.sfjp.jindolf.ResourceManager;
import jp.sfjp.jindolf.data.Village;

public class VillageIconRenderer
extends DefaultTreeCellRenderer {
    private static final ImageIcon ICON_PROLOGUE = ResourceManager.getImageIcon("resources/image/vs_prologue.png");
    private static final ImageIcon ICON_PROGRESS = ResourceManager.getImageIcon("resources/image/vs_progress.png");
    private static final ImageIcon ICON_EPILOGUE = ResourceManager.getImageIcon("resources/image/vs_epilogue.png");
    private static final ImageIcon ICON_GAMEOVER = ResourceManager.getImageIcon("resources/image/vs_gameover.png");
    private static final ImageIcon ICON_INVALID = ResourceManager.getImageIcon("resources/image/vs_cross.png");

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (leaf && value instanceof Village) {
            Village village = (Village)value;
            ImageIcon icon = null;
            switch (village.getState()) {
                case PROLOGUE: {
                    icon = ICON_PROLOGUE;
                    break;
                }
                case PROGRESS: {
                    icon = ICON_PROGRESS;
                    break;
                }
                case EPILOGUE: {
                    icon = ICON_EPILOGUE;
                    break;
                }
                case GAMEOVER: {
                    icon = ICON_GAMEOVER;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            if (!village.isValid()) {
                icon = ICON_INVALID;
            }
            this.setLeafIcon(icon);
        }
        Component comp = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        return comp;
    }
}

