/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.parser;

import java.util.regex.Pattern;
import jp.sourceforge.jindolf.corelib.PeriodType;
import jp.sourceforge.jindolf.corelib.VillageState;
import jp.sourceforge.jindolf.parser.AbstractParser;
import jp.sourceforge.jindolf.parser.BasicHandler;
import jp.sourceforge.jindolf.parser.DecodedContent;
import jp.sourceforge.jindolf.parser.HtmlParseException;
import jp.sourceforge.jindolf.parser.PageType;
import jp.sourceforge.jindolf.parser.SeqRange;
import jp.sourceforge.jindolf.parser.SysEventHandler;
import jp.sourceforge.jindolf.parser.SysEventParser;
import jp.sourceforge.jindolf.parser.TalkHandler;
import jp.sourceforge.jindolf.parser.TalkParser;

public class HtmlParser
extends AbstractParser {
    private static final String SP = " ";
    private BasicHandler basicHandler;
    private final TalkParser talkParser = new TalkParser(this);
    private final SysEventParser sysEventParser = new SysEventParser(this);
    private final SeqRange rangepool_1 = new SeqRange();
    private final SeqRange rangepool_2 = new SeqRange();
    private static final Pattern XMLDECL_PATTERN = HtmlParser.compile("<\\?xml ");
    private static final Pattern O_HTML_PATTERN = HtmlParser.compile("<html ");
    private static final Pattern TITLE_PATTERN = HtmlParser.compile("<title>([^<]*)</title>");
    private static final Pattern O_BODY_PATTERN = HtmlParser.compile("<body>");
    private static final Pattern O_DIVMAIN_PATTERN = HtmlParser.compile("<div class=\"main\">");
    private static final Pattern LOGINFORM_PATTERN = HtmlParser.compile("(<form action=\"index\\.rb\" method=\"post\" class=\"login_form\">)|(<div class=\"login_form\">)");
    private static final Pattern C_EDIV_PATTERN = HtmlParser.compile("[ \\t\\n\\r]*<a href=\"[^\"]*\">[^<]*</a>[ \\t\\n\\r]*</div>");
    private static final Pattern USERID_PATTERN = HtmlParser.compile("name=\"user_id\" value=\"([^\"]*)\"");
    private static final Pattern C_FORM_PATTERN = HtmlParser.compile("</form>");
    private static final Pattern VILLAGEINFO_PATTERN = HtmlParser.compile("([^<]+?)[ \\t\\n\\r]*<strong>\uff08([0-9]+)/([0-9]+) (?:(?:(\u5348\u524d)|(\u5348\u5f8c)) )?([0-9]+)(?:\u6642 |\\:)([0-9]+)\u5206? \u306b\u66f4\u65b0\uff09</strong>");
    private static final Pattern O_PARAG_PATTERN = HtmlParser.compile("<p>");
    private static final Pattern PERIODLINK_PATTERN = HtmlParser.compile("(<span class=\"time\">)|(?:<a href=\"([^\"]*)\">)|(</p>)");
    private static final Pattern PERIOD_PATTERN = HtmlParser.compile("(\u30d7\u30ed\u30ed\u30fc\u30b0)|(\u30a8\u30d4\u30ed\u30fc\u30b0)|(\u7d42\u4e86)|([0-9]+)\u65e5\u76ee");
    private static final Pattern C_SPAN_PATTERN = HtmlParser.compile("</span>");
    private static final Pattern C_ANCHOR_PATTERN = HtmlParser.compile("</a>");
    private static final Pattern O_MESSAGE_PATTERN = HtmlParser.compile("<div class=\"message(?: ch[0-9]+)?\">");
    private static final Pattern O_RELOAD_PATTERN = HtmlParser.compile("<div id=\"reload\">");
    private static final Pattern O_MSGKIND_PATTERN = HtmlParser.compile("(?:<div class=\"(?:(announce)|(order)|(extra))\">)|(?:(?:(?:<a name=\"[^\"]*\">)?[ \\t\\n\\r]*<span class=\"mes_no\">([0-9]+)\\.</span>)?[ \\t\\n\\r]*(?:</a>)?[ \\t\\n\\r]*<a name=\"([^\"]*)\"(?: class=\"ch_name\")?>)");
    private static final Pattern C_DIV_PATTERN = HtmlParser.compile("</div>");
    private static final Pattern O_LISTTABLE_PATTERN = HtmlParser.compile("<table class=\"list\">(?:<tr><th>\u6751\u540d</th><th>Mode</th><th>\u66f4\u65b0</th><th>\u72b6\u614b</th></tr>)?");
    private static final Pattern ACTIVEVILLAGE = HtmlParser.compile("(</table>)|(?:<tr><td><a href=\"([^\"]*)\">([^<]*)</a>(?: |</td><td>(?:\u901a\u5e38|[^<]*)</td><td>)<strong>(?:\uff08(?:(\u5348\u524d)|(\u5348\u5f8c)) )?([0-9]+)(?:\u6642 |\\:)([0-9]+)(?: |\u5206 \u66f4\u65b0\uff09)</strong></td><td>(?:(\u53c2\u52a0\u8005\u52df\u96c6\u4e2d(?:\u3067\u3059\u3002)?)|(\u958b\u59cb\u5f85\u3061(?:\u3067\u3059\u3002)?)|(\u9032\u884c\u4e2d(?:\u3067\u3059\u3002)?)|(\u52dd\u6557\u304c\u6c7a\u5b9a\u3057\u307e\u3057\u305f\u3002|\u30a8\u30d4\u30ed\u30fc\u30b0)|(\u7d42\u4e86\u30fb\u30ed\u30b0\u516c\u958b\u4e2d\u3002))</td></tr>)");
    private static final Pattern O_LISTLOG_PATTERN = HtmlParser.compile("<a href=\"(index[^\"]*(?:ready_0|000_ready))\">([^<]*)</a><br />");
    private static final Pattern C_BODY_PATTERN = HtmlParser.compile("</body>");
    private static final Pattern C_HTML_PATTERN = HtmlParser.compile("[ \\t\\n\\r]*</html>[ \\t\\n\\r]*");
    private static final Pattern LISTTITLE_PATTERN = HtmlParser.compile("\u7d42\u4e86\u3057\u305f\u6751\u306e\u8a18\u9332");

    public void setBasicHandler(BasicHandler basicHandler) {
        this.basicHandler = basicHandler;
    }

    public void setTalkHandler(TalkHandler talkHandler) {
        this.talkParser.setTalkHandler(talkHandler);
    }

    public void setSysEventHandler(SysEventHandler handler) {
        this.sysEventParser.setSysEventHandler(handler);
    }

    private void parseHead() throws HtmlParseException {
        this.setContextErrorMessage("lost head part");
        SeqRange titleRange = this.rangepool_1;
        this.lookingAtAffirm(XMLDECL_PATTERN);
        this.shrinkRegion();
        this.findAffirm(O_HTML_PATTERN);
        this.shrinkRegion();
        this.findAffirm(TITLE_PATTERN);
        titleRange.setLastMatchedGroupRange(this.getMatcher(), 1);
        this.shrinkRegion();
        this.basicHandler.pageTitle(this.getContent(), titleRange);
        this.findAffirm(O_BODY_PATTERN);
        this.shrinkRegion();
        this.findAffirm(O_DIVMAIN_PATTERN);
        this.shrinkRegion();
    }

    private void parseLoginForm() throws HtmlParseException {
        this.setContextErrorMessage("lost login form");
        SeqRange accountRange = this.rangepool_1;
        this.findAffirm(LOGINFORM_PATTERN);
        boolean isLand_E_Form = !this.isGroupMatched(1);
        this.shrinkRegion();
        if (isLand_E_Form) {
            this.lookingAtAffirm(C_EDIV_PATTERN);
            this.shrinkRegion();
            return;
        }
        this.findAffirm(USERID_PATTERN);
        accountRange.setLastMatchedGroupRange(this.getMatcher(), 1);
        this.shrinkRegion();
        if (accountRange.length() > 0) {
            this.basicHandler.loginName(this.getContent(), accountRange);
        }
        this.findAffirm(C_FORM_PATTERN);
        this.shrinkRegion();
    }

    private void parseVillageInfo() throws HtmlParseException {
        this.setContextErrorMessage("lose village information");
        SeqRange villageRange = this.rangepool_1;
        this.sweepSpace();
        this.lookingAtAffirm(VILLAGEINFO_PATTERN);
        villageRange.setLastMatchedGroupRange(this.getMatcher(), 1);
        int month = this.parseGroupedInt(2);
        int day = this.parseGroupedInt(3);
        int hour = this.parseGroupedInt(6);
        int minute = this.parseGroupedInt(7);
        if (this.isGroupMatched(5)) {
            hour = (hour + 12) % 24;
        }
        this.shrinkRegion();
        this.basicHandler.villageName(this.getContent(), villageRange);
        this.basicHandler.commitTime(month, day, hour, minute);
    }

    private void parsePeriodLink() throws HtmlParseException {
        this.setContextErrorMessage("lost period link");
        SeqRange anchorRange = this.rangepool_1;
        this.findAffirm(O_PARAG_PATTERN);
        this.shrinkRegion();
        while (true) {
            Pattern closePattern;
            anchorRange.setInvalid();
            this.sweepSpace();
            this.lookingAtAffirm(PERIODLINK_PATTERN);
            if (this.isGroupMatched(1)) {
                closePattern = C_SPAN_PATTERN;
            } else if (this.isGroupMatched(2)) {
                closePattern = C_ANCHOR_PATTERN;
                anchorRange.setLastMatchedGroupRange(this.getMatcher(), 2);
            } else {
                if (this.isGroupMatched(3)) break;
                assert (false);
                throw this.buildParseException();
            }
            this.shrinkRegion();
            int day = -1;
            PeriodType periodType = null;
            this.lookingAtAffirm(PERIOD_PATTERN);
            if (this.isGroupMatched(1)) {
                periodType = PeriodType.PROLOGUE;
            } else if (this.isGroupMatched(2)) {
                periodType = PeriodType.EPILOGUE;
            } else if (this.isGroupMatched(3)) {
                periodType = null;
            } else if (this.isGroupMatched(4)) {
                periodType = PeriodType.PROGRESS;
                day = this.parseGroupedInt(4);
            } else {
                assert (false);
                throw this.buildParseException();
            }
            this.shrinkRegion();
            this.lookingAtAffirm(closePattern);
            this.shrinkRegion();
            this.basicHandler.periodLink(this.getContent(), anchorRange, periodType, day);
        }
        this.shrinkRegion();
    }

    private void parseMessage() throws HtmlParseException {
        this.setContextErrorMessage("lost message");
        boolean skipGarbage = true;
        while (true) {
            boolean matched;
            this.sweepSpace();
            if (skipGarbage) {
                skipGarbage = false;
                matched = this.findProbe(O_MESSAGE_PATTERN);
            } else {
                matched = this.lookingAtProbe(O_MESSAGE_PATTERN);
            }
            if (!matched) {
                matched = this.lookingAtProbe(O_RELOAD_PATTERN);
                if (!matched) break;
                this.shrinkRegion();
                this.findAffirm(C_DIV_PATTERN);
                this.shrinkRegion();
                continue;
            }
            this.shrinkRegion();
            this.dispatchFamily();
            this.lookingAtAffirm(C_DIV_PATTERN);
            this.shrinkRegion();
        }
    }

    private void dispatchFamily() throws HtmlParseException {
        this.sweepSpace();
        SeqRange nameRange = this.rangepool_1;
        this.lookingAtAffirm(O_MSGKIND_PATTERN);
        if (this.isGroupMatched(1)) {
            this.shrinkRegion();
            this.sysEventParser.parseAnnounce();
        } else if (this.isGroupMatched(2)) {
            this.shrinkRegion();
            this.sysEventParser.parseOrder();
        } else if (this.isGroupMatched(3)) {
            this.shrinkRegion();
            this.sysEventParser.parseExtra();
        } else if (this.isGroupMatched(5)) {
            nameRange.setLastMatchedGroupRange(this.getMatcher(), 5);
            int talkNo = -1;
            if (this.isGroupMatched(4)) {
                talkNo = this.parseGroupedInt(4);
            }
            this.shrinkRegion();
            this.talkParser.parseTalk(talkNo, nameRange);
        } else {
            assert (false);
            throw this.buildParseException();
        }
    }

    private void parseTopList() throws HtmlParseException {
        this.setContextErrorMessage("lost village list");
        SeqRange anchorRange = this.rangepool_1;
        SeqRange villageRange = this.rangepool_2;
        if (!this.findProbe(O_LISTTABLE_PATTERN)) {
            return;
        }
        this.shrinkRegion();
        this.sweepSpace();
        while (true) {
            VillageState state;
            this.lookingAtAffirm(ACTIVEVILLAGE);
            if (this.isGroupMatched(1)) break;
            anchorRange.setLastMatchedGroupRange(this.getMatcher(), 2);
            villageRange.setLastMatchedGroupRange(this.getMatcher(), 3);
            int hour = this.parseGroupedInt(6);
            if (this.isGroupMatched(5)) {
                hour = (hour + 12) % 24;
            }
            int minute = this.parseGroupedInt(7);
            if (this.isGroupMatched(8)) {
                state = VillageState.PROLOGUE;
            } else if (this.isGroupMatched(9)) {
                state = VillageState.PROLOGUE;
            } else if (this.isGroupMatched(10)) {
                state = VillageState.PROGRESS;
            } else if (this.isGroupMatched(11)) {
                state = VillageState.EPILOGUE;
            } else if (this.isGroupMatched(12)) {
                state = VillageState.GAMEOVER;
            } else {
                assert (false);
                throw this.buildParseException();
            }
            this.shrinkRegion();
            this.sweepSpace();
            this.basicHandler.villageRecord(this.getContent(), anchorRange, villageRange, hour, minute, state);
        }
    }

    private void parseLogList() throws HtmlParseException {
        this.setContextErrorMessage("lost village list");
        SeqRange anchorRange = this.rangepool_1;
        SeqRange villageRange = this.rangepool_2;
        boolean is1st = true;
        while (true) {
            boolean matched;
            if (is1st) {
                matched = this.findProbe(O_LISTLOG_PATTERN);
                is1st = false;
            } else {
                matched = this.lookingAtProbe(O_LISTLOG_PATTERN);
            }
            if (!matched) break;
            anchorRange.setLastMatchedGroupRange(this.getMatcher(), 1);
            villageRange.setLastMatchedGroupRange(this.getMatcher(), 2);
            this.shrinkRegion();
            this.basicHandler.villageRecord(this.getContent(), anchorRange, villageRange, -1, -1, VillageState.GAMEOVER);
        }
    }

    private void parseTail() throws HtmlParseException {
        this.setContextErrorMessage("lost last part");
        this.findAffirm(C_BODY_PATTERN);
        this.shrinkRegion();
        this.matchesAffirm(C_HTML_PATTERN);
        this.shrinkRegion();
    }

    public void parseAutomatic(DecodedContent content) throws HtmlParseException {
        this.setContent(content);
        this.basicHandler.startParse(this.getContent());
        this.parseHead();
        this.sweepSpace();
        if (this.lookingAtProbe(LISTTITLE_PATTERN)) {
            this.shrinkRegion();
            this.basicHandler.pageType(PageType.VILLAGELIST_PAGE);
            this.parseLogList();
        } else {
            this.parseLoginForm();
            this.sweepSpace();
            if (this.lookingAtProbe(O_PARAG_PATTERN)) {
                this.shrinkRegion();
                this.basicHandler.pageType(PageType.TOP_PAGE);
                this.parseTopList();
            } else {
                this.basicHandler.pageType(PageType.PERIOD_PAGE);
                this.parseVillageInfo();
                this.parsePeriodLink();
                this.parseMessage();
            }
        }
        this.parseTail();
        this.basicHandler.endParse();
        this.reset();
    }
}

