/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jovsonz;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jp.sourceforge.jovsonz.JsComposition;
import jp.sourceforge.jovsonz.JsParseException;
import jp.sourceforge.jovsonz.JsTypes;
import jp.sourceforge.jovsonz.JsValue;
import jp.sourceforge.jovsonz.JsVisitException;
import jp.sourceforge.jovsonz.Json;
import jp.sourceforge.jovsonz.JsonSource;
import jp.sourceforge.jovsonz.UnmodIterator;
import jp.sourceforge.jovsonz.ValueVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsArray
implements JsComposition<JsValue> {
    private static final String ERRMSG_NOARRAYCOMMA = "missing comma in ARRAY";
    private static final String ERRMSG_NOELEM = "missing element in ARRAY";
    private final List<JsValue> valueList = new LinkedList<JsValue>();
    private boolean changed = false;

    static JsArray parseArray(JsonSource source) throws IOException, JsParseException {
        char charHead = source.readOrDie();
        if (charHead != '[') {
            source.unread(charHead);
            return null;
        }
        JsArray result = new JsArray();
        while (true) {
            source.skipWhiteSpace();
            char chData = source.readOrDie();
            if (chData == ']') break;
            if (result.isEmpty()) {
                source.unread(chData);
            } else if (chData != ',') {
                throw new JsParseException(ERRMSG_NOARRAYCOMMA, source.getLineNumber());
            }
            JsValue value = Json.parseValue(source);
            if (value == null) {
                throw new JsParseException(ERRMSG_NOELEM, source.getLineNumber());
            }
            result.add(value);
        }
        return result;
    }

    @Override
    public JsTypes getJsTypes() {
        return JsTypes.ARRAY;
    }

    @Override
    public boolean hasChanged() {
        if (this.changed) {
            return true;
        }
        for (JsValue value : this.valueList) {
            JsComposition composition;
            if (!(value instanceof JsComposition) || !(composition = (JsComposition)value).hasChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setUnchanged() {
        this.changed = false;
        for (JsValue value : this.valueList) {
            if (!(value instanceof JsComposition)) continue;
            JsComposition composition = (JsComposition)value;
            composition.setUnchanged();
        }
    }

    @Override
    public void traverse(ValueVisitor visitor) throws JsVisitException {
        visitor.visitValue(this);
        for (JsValue value : this.valueList) {
            value.traverse(visitor);
        }
        visitor.visitCompositionClose(this);
    }

    @Override
    public int size() {
        return this.valueList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.valueList.isEmpty();
    }

    @Override
    public void clear() {
        if (this.valueList.size() > 0) {
            this.changed = true;
        }
        this.valueList.clear();
    }

    public int hashCode() {
        return ((Object)this.valueList).hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JsArray)) {
            return false;
        }
        JsArray array = (JsArray)obj;
        return ((Object)this.valueList).equals(array.valueList);
    }

    public void add(JsValue value) throws NullPointerException {
        if (value == null) {
            throw new NullPointerException();
        }
        this.valueList.add(value);
        this.changed = true;
    }

    public JsValue get(int index) throws IndexOutOfBoundsException {
        return this.valueList.get(index);
    }

    public boolean remove(JsValue value) {
        boolean removed = false;
        Iterator<JsValue> it = this.valueList.iterator();
        while (it.hasNext()) {
            JsValue elem = it.next();
            if (elem != value) continue;
            it.remove();
            this.changed = true;
            removed = true;
            break;
        }
        return removed;
    }

    public JsValue remove(int index) throws IndexOutOfBoundsException {
        JsValue removed = this.valueList.remove(index);
        this.changed = true;
        return removed;
    }

    @Override
    public Iterator<JsValue> iterator() {
        return UnmodIterator.unmodIterator(this.valueList);
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append("[");
        boolean hasElem = false;
        for (JsValue value : this.valueList) {
            if (hasElem) {
                text.append(',');
            }
            text.append(value);
            hasElem = true;
        }
        text.append("]");
        return text.toString();
    }
}

