/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jovsonz;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import jp.sourceforge.jovsonz.JsParseException;

class JsonSource
implements Closeable {
    private static final int PUSHBACK_TOKENS = 10;
    private static final char LINEFEED = '\n';
    private static final String ERRMSG_OVERFLOW = "Pushback buffer overflow";
    private static final String ERRMSG_CLOSED = "Stream closed";
    private final Reader reader;
    private final char[] charStack = new char[10];
    private int stackPt = 0;
    private int lineNumber = 1;
    private boolean closed = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public JsonSource(Reader reader) throws NullPointerException {
        if (reader == null) {
            throw new NullPointerException();
        }
        this.reader = reader;
    }

    public JsonSource(CharSequence text) {
        this(new StringReader(((Object)text).toString()));
    }

    public static boolean isWhitespace(char ch) {
        switch (ch) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    public static boolean isWhitespace(int ch) {
        if (0 > ch) {
            return false;
        }
        if (65535 < ch) {
            return false;
        }
        return JsonSource.isWhitespace((char)ch);
    }

    public int getPushBackSpared() {
        return 10 - this.stackPt;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException(ERRMSG_CLOSED);
        }
        int chData = this.stackPt > 0 ? this.charStack[--this.stackPt] : this.reader.read();
        if (chData == 10) {
            ++this.lineNumber;
        }
        return chData;
    }

    public char readOrDie() throws IOException, JsParseException {
        int chData = this.read();
        if (chData < 0) {
            throw new JsParseException("We need but no more JSON data", this.lineNumber);
        }
        return (char)chData;
    }

    public boolean matchOrDie(CharSequence seq) throws IOException, JsParseException {
        int length = seq.length();
        for (int pt = 0; pt < length; ++pt) {
            if (this.readOrDie() == seq.charAt(pt)) continue;
            return false;
        }
        return true;
    }

    public void unread(char ch) throws IOException {
        if (this.closed) {
            throw new IOException(ERRMSG_CLOSED);
        }
        if (this.stackPt >= 10) {
            throw new IOException(ERRMSG_OVERFLOW);
        }
        this.charStack[this.stackPt++] = ch;
        if (ch == '\n') {
            --this.lineNumber;
        }
    }

    public void unread(int ch) throws IOException {
        this.unread((char)ch);
    }

    public void skipWhiteSpace() throws IOException {
        int chData;
        while ((chData = this.read()) >= 0) {
            if (JsonSource.isWhitespace(chData)) continue;
            this.unread(chData);
            break;
        }
    }

    public boolean hasMore() throws IOException {
        int chData = this.read();
        if (chData < 0) {
            return false;
        }
        this.unread(chData);
        return true;
    }

    public void close() throws IOException {
        this.closed = true;
        this.stackPt = 0;
        this.reader.close();
    }

    static {
        boolean bl = $assertionsDisabled = !JsonSource.class.desiredAssertionStatus();
        if (!$assertionsDisabled && "\\uXXXX".length() >= 10) {
            throw new AssertionError();
        }
    }
}

