/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.dxchg;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import jp.sourceforge.jindolf.corelib.XmlResource;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlResourceResolver
implements LSResourceResolver,
EntityResolver {
    private static final URI EMPTY_URI = URI.create("");
    private final Map<URI, URI> uriMap = XmlResource.RESOLVE_MAP;

    protected static URI buildBaseRelativeURI(String base, String relative) throws URISyntaxException, IllegalArgumentException {
        URI resultURI;
        URI baseURI = null;
        if (base != null && !(baseURI = new URI(base)).isAbsolute()) {
            throw new IllegalArgumentException();
        }
        URI relativeURI = EMPTY_URI;
        if (relative != null) {
            relativeURI = new URI(relative);
        }
        if (!(resultURI = baseURI == null || relativeURI.isAbsolute() ? relativeURI : baseURI.resolve(relativeURI)).isAbsolute()) {
            throw new IllegalArgumentException();
        }
        resultURI = resultURI.normalize();
        return resultURI;
    }

    public static LSInput createLSInput() {
        LSInputImpl input = new LSInputImpl();
        return input;
    }

    public InputStream getXMLResourceAsStream(URI originalURI) throws IOException {
        URI resourceURI = this.uriMap.get(originalURI.normalize());
        URL resourceURL = resourceURI.toURL();
        InputStream is = resourceURL.openStream();
        return is;
    }

    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        InputStream is;
        URI originalURI;
        if (systemId == null) {
            return null;
        }
        try {
            originalURI = XmlResourceResolver.buildBaseRelativeURI(baseURI, systemId);
        }
        catch (URISyntaxException e) {
            return null;
        }
        try {
            is = this.getXMLResourceAsStream(originalURI);
        }
        catch (IOException e) {
            return null;
        }
        LSInput input = XmlResourceResolver.createLSInput();
        input.setBaseURI(baseURI);
        input.setPublicId(publicId);
        input.setSystemId(systemId);
        input.setByteStream(is);
        return input;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        URI originalUri;
        if (systemId == null) {
            return null;
        }
        try {
            originalUri = new URI(systemId);
        }
        catch (URISyntaxException e) {
            return null;
        }
        InputStream is = this.getXMLResourceAsStream(originalUri);
        InputSource source = new InputSource(is);
        source.setPublicId(publicId);
        source.setSystemId(systemId);
        return source;
    }

    public static class LSInputImpl
    implements LSInput {
        private String baseURI = null;
        private InputStream byteStream = null;
        private boolean certifiedText = false;
        private Reader characterStream = null;
        private String encoding = null;
        private String publicId = null;
        private String stringData = null;
        private String systemId = null;

        public String getBaseURI() {
            return this.baseURI;
        }

        public void setBaseURI(String baseURI) {
            this.baseURI = baseURI;
        }

        public InputStream getByteStream() {
            return this.byteStream;
        }

        public void setByteStream(InputStream byteStream) {
            this.byteStream = byteStream;
        }

        public boolean getCertifiedText() {
            return this.certifiedText;
        }

        public void setCertifiedText(boolean certifiedText) {
            this.certifiedText = certifiedText;
        }

        public Reader getCharacterStream() {
            return this.characterStream;
        }

        public void setCharacterStream(Reader characterStream) {
            this.characterStream = characterStream;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public String getPublicId() {
            return this.publicId;
        }

        public void setPublicId(String publicId) {
            this.publicId = publicId;
        }

        public String getStringData() {
            return this.stringData;
        }

        public void setStringData(String stringData) {
            this.stringData = stringData;
        }

        public String getSystemId() {
            return this.systemId;
        }

        public void setSystemId(String systemId) {
            this.systemId = systemId;
        }
    }
}

