/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JViewport;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import jp.sfjp.jindolf.dxchg.ClipboardAction;
import jp.sfjp.jindolf.dxchg.TextPopup;
import jp.sfjp.jindolf.editor.EditArray;
import jp.sfjp.jindolf.editor.TalkEditor;
import jp.sfjp.jindolf.editor.TextEditor;
import jp.sfjp.jindolf.glyph.FontInfo;
import jp.sfjp.jindolf.util.GUIUtils;
import jp.sourceforge.jovsonz.JsArray;
import jp.sourceforge.jovsonz.JsComposition;
import jp.sourceforge.jovsonz.JsObject;
import jp.sourceforge.jovsonz.JsString;
import jp.sourceforge.jovsonz.JsTypes;
import jp.sourceforge.jovsonz.JsValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TalkPreview
extends JFrame
implements ActionListener,
ChangeListener {
    public static final File DRAFT_FILE = new File("draft.json");
    private static final Color COLOR_EDITORBACK = Color.BLACK;
    private final JTextComponent freeMemo = new TextEditor();
    private final EditArray editArray = new EditArray();
    private final JButton cutButton = new JButton("\u30ab\u30c3\u30c8");
    private final JButton copyButton = new JButton("\u30b3\u30d4\u30fc");
    private final JButton clearButton = new JButton("\u30af\u30ea\u30a2");
    private final JButton cutAllButton = new JButton("\u5168\u30ab\u30c3\u30c8");
    private final JButton copyAllButton = new JButton("\u5168\u30b3\u30d4\u30fc");
    private final JButton clearAllButton = new JButton("\u5168\u30af\u30ea\u30a2");
    private final JButton closeButton = new JButton("\u9589\u3058\u308b");
    private final TitledBorder numberBorder = BorderFactory.createTitledBorder("");
    private final JComponent singleGroup = this.buildSingleGroup();
    private final JComponent multiGroup = this.buildMultiGroup();
    private final JLabel letsBrowser = new JLabel("\u6295\u7a3f\u306fWeb\u30d6\u30e9\u30a6\u30b6\u304b\u3089\u3069\u3046\u305e");
    private JsObject loadedDraft = null;

    public TalkPreview() {
        GUIUtils.modifyWindowAttributes(this, true, false, true);
        this.setDefaultCloseOperation(1);
        this.cutButton.addActionListener(this);
        this.copyButton.addActionListener(this);
        this.clearButton.addActionListener(this);
        this.cutAllButton.addActionListener(this);
        this.copyAllButton.addActionListener(this);
        this.clearAllButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.editArray.addChangeListener(this);
        Container content = this.getContentPane();
        this.design(content);
        this.setBorderNumber(1);
    }

    private void design(Container content) {
        JComponent freeNotePanel = this.buildFreeNotePanel();
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setHorizontalScrollBarPolicy(31);
        JViewport viewPort = new JViewport();
        viewPort.setBackground(COLOR_EDITORBACK);
        viewPort.setView(this.editArray);
        scrollPane.setViewport(viewPort);
        JPanel editPanel = new JPanel();
        BorderLayout layout = new BorderLayout();
        editPanel.setLayout(layout);
        editPanel.add((Component)scrollPane, "Center");
        JComponent buttonPanel = this.buildButtonPanel();
        editPanel.add((Component)buttonPanel, "East");
        AbstractBorder border = BorderFactory.createTitledBorder("\u767a\u8a00\u7de8\u96c6");
        editPanel.setBorder(border);
        JSplitPane split = new JSplitPane();
        split.setOrientation(1);
        split.setContinuousLayout(false);
        split.setDividerSize(10);
        split.setDividerLocation(200);
        split.setOneTouchExpandable(true);
        split.setLeftComponent(freeNotePanel);
        split.setRightComponent(editPanel);
        Border inside = BorderFactory.createBevelBorder(1);
        Border outside = BorderFactory.createEmptyBorder(2, 5, 2, 2);
        border = BorderFactory.createCompoundBorder(inside, outside);
        this.letsBrowser.setBorder(border);
        layout = new BorderLayout();
        content.setLayout(layout);
        content.add((Component)split, "Center");
        content.add((Component)this.letsBrowser, "South");
    }

    private JComponent buildButtonPanel() {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        panel.setLayout(layout);
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = -1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(3, 3, 3, 3);
        panel.add((Component)this.singleGroup, constraints);
        constraints.insets = new Insets(10, 3, 3, 3);
        panel.add((Component)this.multiGroup, constraints);
        constraints.weighty = 1.0;
        constraints.anchor = 15;
        constraints.insets = new Insets(3, 3, 10, 3);
        panel.add((Component)this.closeButton, constraints);
        return panel;
    }

    private JComponent buildSingleGroup() {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        panel.setLayout(layout);
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.gridx = 1;
        constraints.gridy = -1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(3, 3, 3, 3);
        panel.add((Component)this.cutButton, constraints);
        panel.add((Component)this.copyButton, constraints);
        panel.add((Component)this.clearButton, constraints);
        panel.setBorder(this.numberBorder);
        return panel;
    }

    private JComponent buildMultiGroup() {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        panel.setLayout(layout);
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.gridx = 1;
        constraints.gridy = -1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(3, 3, 3, 3);
        panel.add((Component)this.cutAllButton, constraints);
        panel.add((Component)this.copyAllButton, constraints);
        panel.add((Component)this.clearAllButton, constraints);
        TitledBorder border = BorderFactory.createTitledBorder("\u5168\u767a\u8a00\u3092");
        panel.setBorder(border);
        return panel;
    }

    private JComponent buildFreeNotePanel() {
        Insets margin = new Insets(3, 3, 3, 3);
        this.freeMemo.setMargin(margin);
        TextPopup popup = new TextPopup();
        this.freeMemo.setComponentPopupMenu(popup);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setHorizontalScrollBarPolicy(31);
        JViewport viewPort = new JViewport();
        viewPort.setView(this.freeMemo);
        scrollPane.setViewport(viewPort);
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        panel.setLayout(layout);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.insets = new Insets(1, 1, 1, 1);
        panel.add((Component)scrollPane, constraints);
        TitledBorder border = BorderFactory.createTitledBorder("\u30d5\u30ea\u30fc\u30e1\u30e2");
        panel.setBorder(border);
        return panel;
    }

    private void setBorderNumber(int num) {
        String title = "\u767a\u8a00#" + num + " \u3092";
        this.numberBorder.setTitle(title);
        this.singleGroup.revalidate();
        this.singleGroup.repaint();
    }

    public void setFontInfo(FontInfo fontInfo) {
        this.setTextFont(fontInfo.getFont());
    }

    public void setTextFont(Font textFont) {
        this.freeMemo.setFont(textFont);
        this.editArray.setTextFont(textFont);
    }

    public Font getTextFont() {
        return this.editArray.getTextFont();
    }

    private int warnClear() {
        int result = JOptionPane.showConfirmDialog(this, "\u672c\u5f53\u306b\u767a\u8a00\u3092\u30af\u30ea\u30a2\u3057\u3066\u3082\u3088\u3044\u3067\u3059\u304b\uff1f", "\u767a\u8a00\u30af\u30ea\u30a2\u78ba\u8a8d", 2, 3);
        return result;
    }

    public JsObject getJson() {
        JsObject result = new JsObject();
        JsString memo = new JsString(this.freeMemo.getText());
        result.putValue("freeMemo", memo);
        JsArray array = new JsArray();
        JsString text = new JsString(this.editArray.getAllText());
        array.add(text);
        result.putValue("drafts", array);
        return result;
    }

    public void putJson(JsObject root) {
        if (root == null) {
            return;
        }
        JsValue value = root.getValue("freeMemo");
        if (value.getJsTypes() == JsTypes.STRING) {
            JsString memo = (JsString)value;
            this.freeMemo.setText(memo.toRawString());
        }
        if ((value = root.getValue("drafts")).getJsTypes() != JsTypes.ARRAY) {
            return;
        }
        JsArray array = (JsArray)value;
        StringBuilder draftAll = new StringBuilder();
        for (JsValue elem : array) {
            if (elem.getJsTypes() != JsTypes.STRING) continue;
            JsString draft = (JsString)elem;
            draftAll.append(draft.toRawString());
        }
        this.editArray.clearAllEditor();
        this.editArray.setAllText(draftAll);
        this.loadedDraft = root;
    }

    public boolean hasConfChanged(JsComposition<?> conf) {
        return this.loadedDraft != null && this.loadedDraft.equals(conf);
    }

    private void actionCutActive() {
        this.actionCopyActive();
        this.actionClearActive(false);
    }

    private void actionCopyActive() {
        TalkEditor activeEditor = this.editArray.getActiveEditor();
        if (activeEditor == null) {
            return;
        }
        String text = activeEditor.getText();
        ClipboardAction.copyToClipboard(text);
    }

    private void actionClearActive(boolean confirm) {
        if (confirm && this.warnClear() != 0) {
            return;
        }
        TalkEditor activeEditor = this.editArray.getActiveEditor();
        if (activeEditor == null) {
            return;
        }
        activeEditor.clearText();
    }

    private void actionCutAll() {
        this.actionCopyAll();
        this.actionClearAll(false);
    }

    private void actionCopyAll() {
        CharSequence text = this.editArray.getAllText();
        ClipboardAction.copyToClipboard(text);
    }

    private void actionClearAll(boolean confirm) {
        if (confirm && this.warnClear() != 0) {
            return;
        }
        this.editArray.clearAllEditor();
    }

    private void actionClose() {
        this.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.cutButton) {
            this.actionCutActive();
        } else if (source == this.copyButton) {
            this.actionCopyActive();
        } else if (source == this.clearButton) {
            this.actionClearActive(true);
        } else if (source == this.cutAllButton) {
            this.actionCutAll();
        } else if (source == this.copyAllButton) {
            this.actionCopyAll();
        } else if (source == this.clearAllButton) {
            this.actionClearAll(true);
        } else if (source == this.closeButton) {
            this.actionClose();
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        TalkEditor activeEditor = this.editArray.getActiveEditor();
        int seqNo = activeEditor.getSequenceNumber();
        this.setBorderNumber(seqNo);
    }
}

