/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.log;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.logging.Handler;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import jp.sfjp.jindolf.dxchg.TextPopup;
import jp.sfjp.jindolf.log.LogUtils;
import jp.sfjp.jindolf.log.SwingDocHandler;
import jp.sfjp.jindolf.util.GUIUtils;
import jp.sfjp.jindolf.util.Monodizer;

public class LogFrame
extends JDialog
implements WindowListener,
ActionListener,
DocumentListener {
    private static final Document DOC_EMPTY = new PlainDocument();
    private final JTextArea textarea;
    private final Document document = new PlainDocument();
    private final JScrollPane scrollPane;
    private final JScrollBar vertical;
    private final Handler handler;
    private final JButton clearButton = new JButton("\u30af\u30ea\u30a2");
    private final JButton closeButton = new JButton("\u9589\u3058\u308b");

    public LogFrame(Frame owner) {
        super(owner);
        this.setModal(false);
        this.handler = LogUtils.hasLoggingPermission() ? new SwingDocHandler(this.document) : null;
        GUIUtils.modifyWindowAttributes(this, true, false, true);
        this.textarea = new JTextArea();
        this.textarea.setEditable(false);
        this.textarea.setLineWrap(true);
        this.textarea.setDocument(DOC_EMPTY);
        Border border = BorderFactory.createEmptyBorder(3, 3, 3, 3);
        this.textarea.setBorder(border);
        Monodizer.monodize(this.textarea);
        TextPopup popup = new TextPopup();
        this.textarea.setComponentPopupMenu(popup);
        this.scrollPane = new JScrollPane(this.textarea);
        this.vertical = this.scrollPane.getVerticalScrollBar();
        this.design();
        this.clearButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.document.addDocumentListener(this);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
    }

    private void design() {
        Container content = this.getContentPane();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        content.setLayout(layout);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.gridwidth = 0;
        content.add((Component)this.scrollPane, constraints);
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.insets = new Insets(5, 5, 5, 5);
        content.add((Component)new JSeparator(), constraints);
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.gridwidth = 1;
        content.add((Component)this.clearButton, constraints);
        constraints.weightx = 0.0;
        constraints.anchor = 13;
        content.add((Component)this.closeButton, constraints);
    }

    public Handler getHandler() {
        return this.handler;
    }

    private void showLastPos() {
        if (!this.isVisible()) {
            return;
        }
        if (this.textarea.getDocument() != this.document) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                LogFrame.this.vertical.setValue(Integer.MAX_VALUE);
            }
        });
    }

    private void close() {
        this.setVisible(false);
    }

    private void clear() {
        block2: {
            try {
                this.document.remove(0, this.document.getLength());
            }
            catch (BadLocationException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.textarea.setDocument(this.document);
            this.showLastPos();
        } else {
            this.textarea.setDocument(DOC_EMPTY);
        }
    }

    public void windowActivated(WindowEvent event) {
    }

    public void windowDeactivated(WindowEvent event) {
    }

    public void windowIconified(WindowEvent event) {
        this.textarea.setDocument(DOC_EMPTY);
    }

    public void windowDeiconified(WindowEvent event) {
        this.textarea.setDocument(this.document);
        this.showLastPos();
    }

    public void windowOpened(WindowEvent event) {
        this.textarea.setDocument(this.document);
        this.showLastPos();
    }

    public void windowClosed(WindowEvent event) {
    }

    public void windowClosing(WindowEvent event) {
        this.close();
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.clearButton) {
            this.clear();
        } else if (source == this.closeButton) {
            this.close();
        }
    }

    public void changedUpdate(DocumentEvent event) {
        this.showLastPos();
    }

    public void insertUpdate(DocumentEvent event) {
        this.showLastPos();
    }

    public void removeUpdate(DocumentEvent event) {
        this.showLastPos();
    }
}

