/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.log;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MomentaryHandler
extends Handler {
    private final List<LogRecord> logList = Collections.synchronizedList(new LinkedList());
    private final List<LogRecord> unmodList = Collections.unmodifiableList(this.logList);

    public static List<MomentaryHandler> getMomentaryHandlers(Logger logger) {
        LinkedList<MomentaryHandler> result = new LinkedList<MomentaryHandler>();
        for (Handler handler : logger.getHandlers()) {
            if (!(handler instanceof MomentaryHandler)) continue;
            MomentaryHandler momentaryHandler = (MomentaryHandler)handler;
            result.add(momentaryHandler);
        }
        return result;
    }

    public static void removeMomentaryHandlers(Logger logger) {
        for (MomentaryHandler handler : MomentaryHandler.getMomentaryHandlers(logger)) {
            logger.removeHandler(handler);
        }
    }

    public List<LogRecord> getRecordList() {
        return this.unmodList;
    }

    @Override
    public void publish(LogRecord record) {
        if (record == null) {
            return;
        }
        if (!this.isLoggable(record)) {
            return;
        }
        record.getSourceMethodName();
        this.logList.add(record);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        this.setLevel(Level.OFF);
        this.flush();
    }

    public void transfer(Handler handler) throws NullPointerException {
        if (handler == null) {
            throw new NullPointerException();
        }
        if (handler == this) {
            return;
        }
        this.close();
        for (LogRecord record : this.logList) {
            handler.publish(record);
        }
        handler.flush();
        this.logList.clear();
    }
}

