/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.log;

import java.awt.EventQueue;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class SwingDocHandler
extends Handler {
    private static final int DOCLIMIT = 100000;
    private static final float CHOPRATIO = 0.9f;
    private static final int CHOPPEDLEN = 90000;
    private final Document document;

    public SwingDocHandler(Document document) {
        this.document = document;
        SimpleFormatter formatter = new SimpleFormatter();
        this.setFormatter(formatter);
    }

    private void appendLog(String logMessage) {
        block2: {
            try {
                this.document.insertString(this.document.getLength(), logMessage, null);
            }
            catch (BadLocationException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    private void chopHead() {
        block3: {
            int docLength = this.document.getLength();
            if (docLength <= 100000) {
                return;
            }
            int offset = docLength - 90000;
            try {
                this.document.remove(0, offset);
            }
            catch (BadLocationException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        Formatter formatter = this.getFormatter();
        final String message = formatter.format(record);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                SwingDocHandler.this.appendLog(message);
                SwingDocHandler.this.chopHead();
            }
        });
    }

    public void flush() {
    }

    public void close() {
        this.setLevel(Level.OFF);
        this.flush();
    }
}

