/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.net;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sfjp.jindolf.VerInfo;
import jp.sfjp.jindolf.config.EnvInfo;

public final class HttpUtils {
    private static final String TOKEN_REGEX = "([^\\(\\)<>@,;:\\\"/\\[\\]\\?=\\{\\}\\p{Blank}\\p{Cntrl}]+)";
    private static final String MTYPE_REGEX = "[\\p{Blank}]*([^\\(\\)<>@,;:\\\"/\\[\\]\\?=\\{\\}\\p{Blank}\\p{Cntrl}]+)/([^\\(\\)<>@,;:\\\"/\\[\\]\\?=\\{\\}\\p{Blank}\\p{Cntrl}]+)[\\p{Blank}]*";
    private static final String PARAM_REGEX = "[\\p{Blank}]*;[\\p{Blank}]*([^\\(\\)<>@,;:\\\"/\\[\\]\\?=\\{\\}\\p{Blank}\\p{Cntrl}]+)[\\p{Blank}]*=[\\p{Blank}]*(([^\\(\\)<>@,;:\\\"/\\[\\]\\?=\\{\\}\\p{Blank}\\p{Cntrl}]+)|(\"[^\\p{Cntrl}\\\"]*\"))";
    private static final Pattern MTYPE_PATTERN = Pattern.compile("[\\p{Blank}]*([^\\(\\)<>@,;:\\\"/\\[\\]\\?=\\{\\}\\p{Blank}\\p{Cntrl}]+)/([^\\(\\)<>@,;:\\\"/\\[\\]\\?=\\{\\}\\p{Blank}\\p{Cntrl}]+)[\\p{Blank}]*");
    private static final Pattern ATTR_PATTERN = Pattern.compile("[\\p{Blank}]*;[\\p{Blank}]*([^\\(\\)<>@,;:\\\"/\\[\\]\\?=\\{\\}\\p{Blank}\\p{Cntrl}]+)[\\p{Blank}]*=[\\p{Blank}]*(([^\\(\\)<>@,;:\\\"/\\[\\]\\?=\\{\\}\\p{Blank}\\p{Cntrl}]+)|(\"[^\\p{Cntrl}\\\"]*\"))");
    private static final String THROUGHPUT_FORM = "{0,number,#,##0}Bytes {1,number,#,##0.0}{2}Bytes/sec";
    private static final String HTTP_FORM = "{0} {1} [{2} {3}] {4}";

    private HttpUtils() {
        assert (false);
        throw new AssertionError();
    }

    public static String throughput(long size, long nano) {
        if (size <= 0L || nano <= 0L) {
            return "";
        }
        double sec = (double)nano / 1.0E9;
        double rate = (double)size / sec;
        String unit = "";
        if (rate >= 1500.0) {
            rate /= 1000.0;
            unit = "K";
        }
        if (rate >= 1500.0) {
            rate /= 1000.0;
            unit = "M";
        }
        String result = MessageFormat.format(THROUGHPUT_FORM, size, rate, unit);
        return result;
    }

    public static String formatHttpStat(HttpURLConnection conn, long size, long nano) {
        String responseMessage;
        String responseCode;
        String method = conn.getRequestMethod();
        String url = conn.getURL().toString();
        try {
            responseCode = String.valueOf(conn.getResponseCode());
        }
        catch (IOException e) {
            responseCode = "???";
        }
        try {
            responseMessage = conn.getResponseMessage();
        }
        catch (IOException e) {
            responseMessage = "???";
        }
        String throughput = HttpUtils.throughput(size, nano);
        String result = MessageFormat.format(HTTP_FORM, method, url, responseCode, responseMessage, throughput);
        return result;
    }

    public static String getUserAgentName() {
        String comment;
        StringBuilder result = new StringBuilder();
        result.append(VerInfo.TITLE).append("/").append(VerInfo.VERSION);
        StringBuilder rawComment = new StringBuilder();
        if (EnvInfo.OS_NAME != null) {
            if (rawComment.length() > 0) {
                rawComment.append("; ");
            }
            rawComment.append(EnvInfo.OS_NAME);
        }
        if (EnvInfo.OS_VERSION != null) {
            if (rawComment.length() > 0) {
                rawComment.append("; ");
            }
            rawComment.append(EnvInfo.OS_VERSION);
        }
        if (EnvInfo.OS_ARCH != null) {
            if (rawComment.length() > 0) {
                rawComment.append("; ");
            }
            rawComment.append(EnvInfo.OS_ARCH);
        }
        if (EnvInfo.JAVA_VENDOR != null) {
            if (rawComment.length() > 0) {
                rawComment.append("; ");
            }
            rawComment.append(EnvInfo.JAVA_VENDOR);
        }
        if (EnvInfo.JAVA_VERSION != null) {
            if (rawComment.length() > 0) {
                rawComment.append("; ");
            }
            rawComment.append(EnvInfo.JAVA_VERSION);
        }
        if ((comment = HttpUtils.escapeHttpComment(rawComment)) != null) {
            result.append(" ").append((CharSequence)comment);
        }
        return result.toString();
    }

    public static String escapeHttpComment(CharSequence comment) {
        if (comment == null) {
            return null;
        }
        if (comment.length() <= 0) {
            return null;
        }
        String result = ((Object)comment).toString();
        result = result.replaceAll("\\(", "\\\\(");
        result = result.replaceAll("\\)", "\\\\)");
        result = result.replaceAll("[\\u0000-\\u001f]", "?");
        result = result.replaceAll("[\\u007f-\\uffff]", "?");
        result = "(" + result + ")";
        return result;
    }

    public static String getHTMLCharset(URLConnection connection) {
        String contentType = connection.getContentType();
        if (contentType == null) {
            return null;
        }
        return HttpUtils.getHTMLCharset(contentType);
    }

    public static String getHTMLCharset(String contentType) {
        Matcher matcher = MTYPE_PATTERN.matcher(contentType);
        boolean matchResult = matcher.lookingAt();
        if (!matchResult) {
            return null;
        }
        int lastPos = matcher.end();
        String type = matcher.group(1);
        String subtype = matcher.group(2);
        if (!type.equalsIgnoreCase("text")) {
            return null;
        }
        if (!subtype.equalsIgnoreCase("html")) {
            return null;
        }
        matcher.usePattern(ATTR_PATTERN);
        String charset = null;
        while (matchResult = matcher.find(lastPos)) {
            lastPos = matcher.end();
            String attribute = matcher.group(1);
            String value = matcher.group(2);
            if (!attribute.equalsIgnoreCase("charset")) continue;
            charset = value;
        }
        return charset;
    }
}

