/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.util;

import java.awt.Component;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Map;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public final class Monodizer
implements PropertyChangeListener {
    public static final String PROPNAME_FONT = "font";
    public static final String PROPNAME_UI = "UI";
    public static final String FAMILY_MONO = "Monospaced";
    private static final Map<TextAttribute, String> TEXTATTR_MONO = Collections.singletonMap(TextAttribute.FAMILY, "Monospaced");
    private static final Monodizer CHANGER = new Monodizer();

    private Monodizer() {
    }

    public static boolean isMonospaced(Font font) {
        Map<TextAttribute, ?> attrMap = font.getAttributes();
        Object attr = attrMap.get(TextAttribute.FAMILY);
        if (!(attr instanceof String)) {
            return false;
        }
        String family = (String)attr;
        return family.equals(FAMILY_MONO);
    }

    public static Font deriveMonoFont(Font font) {
        Font monofont = font.deriveFont(TEXTATTR_MONO);
        return monofont;
    }

    public static void monodize(JComponent comp) {
        Font oldFont = comp.getFont();
        Font newFont = Monodizer.deriveMonoFont(oldFont);
        comp.setFont(newFont);
        Monodizer.modifyComponent(comp);
        comp.addPropertyChangeListener(PROPNAME_FONT, CHANGER);
        comp.addPropertyChangeListener(PROPNAME_UI, CHANGER);
        comp.revalidate();
    }

    private static void modifyComponent(JComponent comp) {
        if (comp instanceof JTextComponent) {
            JTextComponent textComp = (JTextComponent)comp;
            Monodizer.modifyTextComponent(textComp);
        } else if (comp instanceof JComboBox) {
            JComboBox combo = (JComboBox)comp;
            Monodizer.modifyComboBox(combo);
        }
    }

    private static void modifyTextComponent(JTextComponent textComp) {
        if (textComp.isEditable()) {
            return;
        }
        if (textComp.getCaret() == null) {
            return;
        }
        textComp.setCaretPosition(0);
    }

    private static void modifyComboBox(JComboBox comboBox) {
        ComboBoxEditor editor = comboBox.getEditor();
        if (editor == null) {
            return;
        }
        Component editComp = editor.getEditorComponent();
        if (!(editComp instanceof JTextComponent)) {
            return;
        }
        JTextComponent textEditor = (JTextComponent)editComp;
        Font oldFont = textEditor.getFont();
        Font newFont = Monodizer.deriveMonoFont(oldFont);
        textEditor.setFont(newFont);
        Monodizer.modifyTextComponent(textEditor);
    }

    public void propertyChange(PropertyChangeEvent event) {
        Font newFont;
        Object source = event.getSource();
        if (!(source instanceof JComponent)) {
            return;
        }
        JComponent comp = (JComponent)source;
        String propName = event.getPropertyName();
        if (PROPNAME_FONT.equals(propName)) {
            Object newValue = event.getNewValue();
            if (!(newValue instanceof Font)) {
                return;
            }
            newFont = (Font)newValue;
        } else if (PROPNAME_UI.equals(propName)) {
            newFont = comp.getFont();
        } else {
            return;
        }
        Font monoFont = Monodizer.deriveMonoFont(newFont);
        comp.setFont(monoFont);
        Monodizer.modifyComponent(comp);
    }
}

