/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import jp.sfjp.jindolf.data.DialogPref;

public class DialogPrefPanel
extends JPanel
implements ActionListener,
ItemListener {
    private final JCheckBox useBodyImage = new JCheckBox("\u30c7\u30ab\u30ad\u30e3\u30e9\u30e2\u30fc\u30c9");
    private final JCheckBox useMonoImage = new JCheckBox("\u5893\u77f3\u3092\u907a\u5f71\u306b\u7f6e\u304d\u63db\u3048\u308b");
    private final JCheckBox isSimpleMode = new JCheckBox("\u30b7\u30f3\u30d7\u30eb\u8868\u793a\u30e2\u30fc\u30c9");
    private final JCheckBox alignBaloon = new JCheckBox("\u30d5\u30ad\u30c0\u30b7\u5e45\u3092\u63c3\u3048\u308b");
    private final JButton resetDefault = new JButton("\u51fa\u8377\u6642\u306b\u623b\u3059");

    public DialogPrefPanel() {
        this.resetDefault.addActionListener(this);
        this.isSimpleMode.addItemListener(this);
        this.design(this);
        this.modifyGUIState();
    }

    private void design(Container content) {
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        content.setLayout(layout);
        constraints.insets = new Insets(2, 2, 2, 2);
        constraints.weightx = 0.0;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 18;
        content.add((Component)this.isSimpleMode, constraints);
        content.add((Component)this.alignBaloon, constraints);
        content.add((Component)this.buildIconPanel(), constraints);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 0;
        constraints.anchor = 14;
        content.add((Component)this.resetDefault, constraints);
    }

    private JComponent buildIconPanel() {
        JPanel result = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        result.setLayout(layout);
        constraints.insets = new Insets(1, 1, 1, 1);
        constraints.weightx = 0.0;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 18;
        result.add((Component)this.useBodyImage, constraints);
        result.add((Component)this.useMonoImage, constraints);
        TitledBorder border = BorderFactory.createTitledBorder("\u30a2\u30a4\u30b3\u30f3\u8868\u793a");
        result.setBorder(border);
        return result;
    }

    private void modifyGUIState() {
        if (this.isSimpleMode.isSelected()) {
            this.useBodyImage.setEnabled(false);
            this.useMonoImage.setEnabled(false);
            this.alignBaloon.setEnabled(false);
        } else {
            this.useBodyImage.setEnabled(true);
            this.useMonoImage.setEnabled(true);
            this.alignBaloon.setEnabled(true);
        }
    }

    public boolean useBodyImage() {
        return this.useBodyImage.isSelected();
    }

    public boolean useMonoImage() {
        return this.useMonoImage.isSelected();
    }

    public boolean isSimpleMode() {
        return this.isSimpleMode.isSelected();
    }

    public boolean alignBaloon() {
        return this.alignBaloon.isSelected();
    }

    public void setBodyImageSetting(boolean setting) {
        this.useBodyImage.setSelected(setting);
    }

    public void setMonoImageSetting(boolean setting) {
        this.useMonoImage.setSelected(setting);
    }

    public void setSimpleModeSetting(boolean setting) {
        this.isSimpleMode.setSelected(setting);
        this.modifyGUIState();
    }

    public void setAlignBaloonSetting(boolean setting) {
        this.alignBaloon.setSelected(setting);
    }

    public void setDialogPref(DialogPref pref) {
        this.setBodyImageSetting(pref.useBodyImage());
        this.setMonoImageSetting(pref.useMonoImage());
        this.setSimpleModeSetting(pref.isSimpleMode());
        this.setAlignBaloonSetting(pref.alignBaloonWidth());
        this.modifyGUIState();
    }

    public DialogPref getDialogPref() {
        DialogPref result = new DialogPref();
        result.setBodyImageSetting(this.useBodyImage());
        result.setMonoImageSetting(this.useMonoImage());
        result.setSimpleMode(this.isSimpleMode());
        result.setAlignBalooonWidthSetting(this.alignBaloon());
        return result;
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source != this.resetDefault) {
            return;
        }
        this.useBodyImage.setSelected(false);
        this.useMonoImage.setSelected(false);
        this.isSimpleMode.setSelected(false);
        this.alignBaloon.setSelected(false);
        this.modifyGUIState();
    }

    public void itemStateChanged(ItemEvent event) {
        this.modifyGUIState();
    }
}

