/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.corelib;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DomUtils {
    private DomUtils() {
        assert (false);
    }

    static List<Element> loadElemList(DocumentBuilder builder, URL url, String childName) throws IOException, SAXException {
        Element root = DomUtils.loadElement(builder, url);
        List<Element> result = DomUtils.getChildElemList(root, childName);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Element loadElement(DocumentBuilder builder, URL url) throws IOException, SAXException {
        Document document;
        InputStream istream = url.openStream();
        try {
            document = builder.parse(istream);
        }
        finally {
            istream.close();
        }
        Element root = document.getDocumentElement();
        return root;
    }

    private static List<Element> getChildElemList(Element root, String childName) {
        NodeList nodeList = root.getElementsByTagName(childName);
        int childNum = nodeList.getLength();
        ArrayList<Element> result = new ArrayList<Element>(childNum);
        for (int index = 0; index < childNum; ++index) {
            Node node = nodeList.item(index);
            Element element = (Element)node;
            result.add(element);
        }
        return result;
    }

    static String attrRequired(Element elem, String attrName) throws SAXException {
        Attr attr = elem.getAttributeNode(attrName);
        if (attr == null) {
            throw new SAXException("no attribute[" + attrName + "]");
        }
        String result = attr.getValue();
        if (result == null) {
            throw new SAXException("no value[" + attrName + "]");
        }
        return result;
    }

    static String attrValue(Element elem, String attrName) {
        Attr attr = elem.getAttributeNode(attrName);
        if (attr == null) {
            return null;
        }
        String result = attr.getValue();
        return result;
    }

    static URI attrToUri(Element elem, String attrName) throws SAXException {
        URI uri;
        Attr attr = elem.getAttributeNode(attrName);
        if (attr == null) {
            return null;
        }
        String uriText = attr.getValue();
        if (uriText == null) {
            return null;
        }
        try {
            uri = new URI(uriText).normalize();
        }
        catch (URISyntaxException e) {
            throw new SAXException("illegal URI " + uriText, e);
        }
        return uri;
    }
}

