/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.config;

import java.io.File;
import java.text.NumberFormat;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public final class EnvInfo {
    public static final String OS_NAME;
    public static final String OS_VERSION;
    public static final String OS_ARCH;
    public static final String JAVA_VENDOR;
    public static final String JAVA_VERSION;
    public static final long MAX_MEMORY;
    private static final SortedMap<String, String> propertyMap;
    private static final SortedMap<String, String> environmentMap;
    private static final String[] classpaths;

    private EnvInfo() {
        throw new AssertionError();
    }

    private static String getSecureProperty(String key) {
        String result;
        try {
            result = System.getProperty(key);
            if (result != null) {
                propertyMap.put(key, result);
            }
        }
        catch (SecurityException e) {
            result = null;
        }
        return result;
    }

    private static String getSecureEnvironment(String name) {
        String result;
        try {
            result = System.getenv(name);
            if (result != null) {
                environmentMap.put(name, result);
            }
        }
        catch (SecurityException e) {
            result = null;
        }
        return result;
    }

    public static String getVMInfo() {
        StringBuilder result = new StringBuilder();
        NumberFormat nform = NumberFormat.getNumberInstance();
        result.append("\u6700\u5927\u30d2\u30fc\u30d7\u30e1\u30e2\u30ea\u91cf: ").append(nform.format(MAX_MEMORY)).append(" bytes\n");
        result.append("\n");
        result.append("\u4e3b\u8981\u30b7\u30b9\u30c6\u30e0\u30d7\u30ed\u30d1\u30c6\u30a3:\n");
        Set<String> propKeys = propertyMap.keySet();
        for (String propKey : propKeys) {
            if (propKey.equals("java.class.path")) continue;
            String value = (String)propertyMap.get(propKey);
            result.append("  ");
            result.append(propKey).append("=").append(value).append("\n");
        }
        result.append("\n");
        result.append("\u4e3b\u8981\u74b0\u5883\u5909\u6570:\n");
        Set<String> envKeys = environmentMap.keySet();
        for (String envKey : envKeys) {
            String value = (String)environmentMap.get(envKey);
            result.append("  ");
            result.append(envKey).append("=").append(value).append("\n");
        }
        result.append("\n");
        result.append("\u30af\u30e9\u30b9\u30d1\u30b9:\n");
        for (String path : classpaths) {
            result.append("  ");
            result.append(path).append("\n");
        }
        result.append("\n");
        return result.toString();
    }

    static {
        propertyMap = new TreeMap<String, String>();
        environmentMap = new TreeMap<String, String>();
        OS_NAME = EnvInfo.getSecureProperty("os.name");
        OS_VERSION = EnvInfo.getSecureProperty("os.version");
        OS_ARCH = EnvInfo.getSecureProperty("os.arch");
        JAVA_VENDOR = EnvInfo.getSecureProperty("java.vendor");
        JAVA_VERSION = EnvInfo.getSecureProperty("java.version");
        EnvInfo.getSecureEnvironment("LANG");
        EnvInfo.getSecureEnvironment("DISPLAY");
        Runtime runtime = Runtime.getRuntime();
        MAX_MEMORY = runtime.maxMemory();
        String classpath = EnvInfo.getSecureProperty("java.class.path");
        String[] pathVec = classpath != null ? classpath.split(File.pathSeparator) : new String[]{};
        classpaths = pathVec;
    }
}

