/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;

public class InterVMLock {
    private static final Collection<InterVMLock> OWNEDLOCKSET = Collections.synchronizedCollection(new LinkedList());
    private static final AtomicBoolean SHUTDOWNGOING = new AtomicBoolean(false);
    private final File lockFile;
    private boolean isFileOwner = false;
    private InputStream stream = null;
    private final Object thisLock = new Object();

    public InterVMLock(File lockFile) throws NullPointerException {
        if (lockFile == null) {
            throw new NullPointerException();
        }
        this.lockFile = lockFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void shutdown() {
        if (!SHUTDOWNGOING.compareAndSet(false, true)) {
            return;
        }
        Collection<InterVMLock> collection = OWNEDLOCKSET;
        synchronized (collection) {
            for (InterVMLock lock : OWNEDLOCKSET) {
                lock.releaseImpl();
            }
            OWNEDLOCKSET.clear();
        }
    }

    protected static boolean isShutdownGoing() {
        boolean going = SHUTDOWNGOING.get();
        return going;
    }

    public boolean isFileOwner() {
        boolean result = this.isFileOwner;
        return result;
    }

    public boolean isExistsFile() {
        return this.lockFile.exists();
    }

    public File getLockFile() {
        return this.lockFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream getOpenedStream() {
        InputStream result = null;
        Object object = this.thisLock;
        synchronized (object) {
            if (this.isFileOwner) {
                result = this.stream;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forceRemove() {
        Object object = this.thisLock;
        synchronized (object) {
            if (this.isFileOwner) {
                this.release();
            }
            if (!this.isExistsFile()) {
                return true;
            }
            try {
                boolean result = this.lockFile.delete();
                if (!result) {
                    return false;
                }
            }
            catch (SecurityException e) {
                return false;
            }
            if (this.isExistsFile()) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryLock() {
        if (InterVMLock.isShutdownGoing()) {
            return false;
        }
        Object object = this.thisLock;
        synchronized (object) {
            if (this.hasLockedByMe()) {
                return true;
            }
            if (this.touchLockFile()) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasLockedByMe() {
        boolean result;
        Object object = this.thisLock;
        synchronized (object) {
            if (!this.isFileOwner) {
                result = false;
            } else if (!this.lockFile.exists()) {
                this.isFileOwner = false;
                result = false;
            } else {
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean touchLockFile() {
        Object object = this.thisLock;
        synchronized (object) {
            boolean created = false;
            try {
                created = this.lockFile.createNewFile();
            }
            catch (IOException e) {
            }
            catch (SecurityException e) {
            }
            finally {
                if (created) {
                    this.isFileOwner = true;
                    this.lockFile.deleteOnExit();
                } else {
                    this.isFileOwner = false;
                }
            }
            if (!created) {
                return false;
            }
            try {
                this.stream = new FileInputStream(this.lockFile);
            }
            catch (FileNotFoundException e) {
                this.isFileOwner = false;
                this.stream = null;
                try {
                    this.lockFile.delete();
                }
                catch (SecurityException e2) {
                    // empty catch block
                }
                return false;
            }
            Collection<InterVMLock> collection = OWNEDLOCKSET;
            synchronized (collection) {
                OWNEDLOCKSET.add(this);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (InterVMLock.isShutdownGoing()) {
            return;
        }
        this.releaseImpl();
        Collection<InterVMLock> collection = OWNEDLOCKSET;
        synchronized (collection) {
            OWNEDLOCKSET.remove(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseImpl() {
        Object object = this.thisLock;
        synchronized (object) {
            if (!this.isFileOwner) {
                return;
            }
            try {
                this.stream.close();
            }
            catch (IOException e) {
                this.stream = null;
                try {
                    this.lockFile.delete();
                }
                catch (SecurityException securityException) {
                }
                finally {
                    this.isFileOwner = false;
                }
            }
            finally {
                this.stream = null;
                try {
                    this.lockFile.delete();
                }
                catch (SecurityException e) {
                }
                finally {
                    this.isFileOwner = false;
                }
            }
        }
    }

    static {
        Runtime runtime = Runtime.getRuntime();
        runtime.addShutdownHook(new Thread(){

            @Override
            public void run() {
                InterVMLock.shutdown();
            }
        });
    }
}

