/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.glyph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.io.IOException;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.event.EventListenerList;
import javax.swing.event.MouseInputListener;
import jp.sfjp.jindolf.data.Anchor;
import jp.sfjp.jindolf.data.Avatar;
import jp.sfjp.jindolf.data.DialogPref;
import jp.sfjp.jindolf.data.Period;
import jp.sfjp.jindolf.data.RegexPattern;
import jp.sfjp.jindolf.data.SysEvent;
import jp.sfjp.jindolf.data.Talk;
import jp.sfjp.jindolf.data.Topic;
import jp.sfjp.jindolf.dxchg.ClipboardAction;
import jp.sfjp.jindolf.glyph.AbstractTextRow;
import jp.sfjp.jindolf.glyph.AnchorHitEvent;
import jp.sfjp.jindolf.glyph.AnchorHitListener;
import jp.sfjp.jindolf.glyph.FontInfo;
import jp.sfjp.jindolf.glyph.SysEventDraw;
import jp.sfjp.jindolf.glyph.TalkDraw;
import jp.sfjp.jindolf.glyph.TextRow;
import jp.sfjp.jindolf.util.GUIUtils;
import jp.sfjp.jindolf.view.TopicFilter;

public class Discussion
extends JComponent
implements Scrollable,
MouseInputListener,
ComponentListener {
    private static final Color COLOR_NORMALBG = Color.BLACK;
    private static final Color COLOR_SIMPLEBG = Color.WHITE;
    private static final int MARGINTOP = 50;
    private static final int MARGINBOTTOM = 100;
    private Period period;
    private final List<TextRow> rowList = new LinkedList<TextRow>();
    private final List<TalkDraw> talkDrawList = new LinkedList<TalkDraw>();
    private TopicFilter topicFilter;
    private TopicFilter.FilterContext filterContext;
    private RegexPattern regexPattern;
    private Point dragFrom;
    private FontInfo fontInfo;
    private final RenderingHints hints = new RenderingHints(null);
    private DialogPref dialogPref;
    private Dimension idealSize;
    private int lastWidth = -1;
    private final DiscussionPopup popup = new DiscussionPopup();
    private final EventListenerList thisListenerList = new EventListenerList();
    private final Action copySelectedAction = new ProxyAction("COPY");

    public Discussion() {
        this.fontInfo = FontInfo.DEFAULT_FONTINFO;
        this.dialogPref = new DialogPref();
        this.hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.updateRenderingHints();
        this.setPeriod(null);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addComponentListener(this);
        this.setComponentPopupMenu(this.popup);
        this.updateInputMap();
        ActionMap actionMap = this.getActionMap();
        actionMap.put("copy-to-clipboard", this.copySelectedAction);
        this.setColorDesign();
    }

    private void updateRenderingHints() {
        FontRenderContext context = this.fontInfo.getFontRenderContext();
        Object textAliaseValue = context.isAntiAliased() ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
        this.hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, textAliaseValue);
        Object textFractionalValue = context.usesFractionalMetrics() ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF;
        this.hints.put(RenderingHints.KEY_FRACTIONALMETRICS, textFractionalValue);
    }

    private void setColorDesign() {
        Color fgColor = this.dialogPref.isSimpleMode() ? COLOR_SIMPLEBG : COLOR_NORMALBG;
        this.setForeground(fgColor);
        this.repaint();
    }

    public void setFontInfo(FontInfo newFontInfo) {
        this.fontInfo = newFontInfo;
        this.updateRenderingHints();
        for (TextRow row : this.rowList) {
            row.setFontInfo(this.fontInfo);
        }
        this.setColorDesign();
        this.layoutRows();
        this.revalidate();
        this.repaint();
    }

    public void setDialogPref(DialogPref newPref) {
        this.dialogPref = newPref;
        for (TextRow row : this.rowList) {
            if (row instanceof TalkDraw) {
                TalkDraw talkDraw = (TalkDraw)row;
                talkDraw.setDialogPref(this.dialogPref);
                continue;
            }
            if (!(row instanceof SysEventDraw)) continue;
            SysEventDraw sysDraw = (SysEventDraw)row;
            sysDraw.setDialogPref(this.dialogPref);
        }
        this.setColorDesign();
        this.layoutRows();
        this.revalidate();
        this.repaint();
    }

    public Period getPeriod() {
        return this.period;
    }

    public final void setPeriod(Period period) {
        if (period == null) {
            this.period = null;
            this.rowList.clear();
            this.talkDrawList.clear();
            return;
        }
        if (this.period == period && period.getTopics() == this.rowList.size()) {
            this.filterTopics();
            return;
        }
        this.period = period;
        this.filterContext = null;
        this.rowList.clear();
        this.talkDrawList.clear();
        for (Topic topic : this.period.getTopicList()) {
            AbstractTextRow row;
            if (topic instanceof Talk) {
                Talk talk = (Talk)topic;
                TalkDraw talkDraw = new TalkDraw(talk, this.dialogPref, this.fontInfo);
                this.talkDrawList.add(talkDraw);
                row = talkDraw;
            } else if (topic instanceof SysEvent) {
                SysEvent sysEvent = (SysEvent)topic;
                row = new SysEventDraw(sysEvent, this.dialogPref, this.fontInfo);
            } else {
                assert (false);
                continue;
            }
            this.rowList.add(row);
        }
        this.filterTopics();
        this.clearSizeCache();
        this.layoutRows();
    }

    public void setTopicFilter(TopicFilter filter) {
        this.topicFilter = filter;
        this.filtering();
    }

    public void filtering() {
        if (this.topicFilter != null && this.topicFilter.isSame(this.filterContext)) {
            return;
        }
        this.filterContext = this.topicFilter != null ? this.topicFilter.getFilterContext() : null;
        this.filterTopics();
        this.layoutVertical();
        this.clearSelect();
    }

    public RegexPattern getRegexPattern() {
        return this.regexPattern;
    }

    public int setRegexPattern(RegexPattern newPattern) {
        this.regexPattern = newPattern;
        int total = 0;
        this.clearHotTarget();
        Pattern pattern = null;
        if (this.regexPattern != null) {
            pattern = this.regexPattern.getPattern();
        }
        for (TalkDraw talkDraw : this.talkDrawList) {
            total += talkDraw.setRegex(pattern);
        }
        this.repaint();
        return total;
    }

    public void nextHotTarget() {
        TalkDraw oldTalk = null;
        int oldIndex = -1;
        TalkDraw newTalk = null;
        int newIndex = -1;
        TalkDraw firstTalk = null;
        boolean findOld = true;
        for (TalkDraw talkDraw : this.talkDrawList) {
            int matches = talkDraw.getRegexMatches();
            if (firstTalk == null && matches > 0) {
                firstTalk = talkDraw;
            }
            if (findOld) {
                int index = talkDraw.getHotTargetIndex();
                if (index < 0) continue;
                oldTalk = talkDraw;
                oldIndex = index;
                this.scrollRectWithMargin(talkDraw.getHotTargetRectangle());
                if (oldIndex < matches - 1 && !this.isFiltered(talkDraw)) {
                    newTalk = talkDraw;
                    newIndex = oldIndex + 1;
                    break;
                }
                findOld = false;
                continue;
            }
            if (this.isFiltered(talkDraw) || matches <= 0) continue;
            newTalk = talkDraw;
            newIndex = 0;
            break;
        }
        Rectangle showRect = null;
        if (oldTalk == null && firstTalk != null) {
            firstTalk.setHotTargetIndex(0);
            showRect = firstTalk.getHotTargetRectangle();
        } else if (oldTalk != null && newTalk != null) {
            oldTalk.clearHotTarget();
            newTalk.setHotTargetIndex(newIndex);
            showRect = newTalk.getHotTargetRectangle();
        }
        if (showRect != null) {
            this.scrollRectWithMargin(showRect);
        }
        this.repaint();
    }

    public void prevHotTarget() {
        int matches;
        TalkDraw oldTalk = null;
        int oldIndex = -1;
        TalkDraw newTalk = null;
        int newIndex = -1;
        TalkDraw firstTalk = null;
        boolean findOld = true;
        int size = this.talkDrawList.size();
        ListIterator<TalkDraw> iterator = this.talkDrawList.listIterator(size);
        while (iterator.hasPrevious()) {
            TalkDraw talkDraw = iterator.previous();
            matches = talkDraw.getRegexMatches();
            if (firstTalk == null && matches > 0) {
                firstTalk = talkDraw;
            }
            if (findOld) {
                int index = talkDraw.getHotTargetIndex();
                if (index < 0) continue;
                oldTalk = talkDraw;
                oldIndex = index;
                this.scrollRectWithMargin(talkDraw.getHotTargetRectangle());
                if (oldIndex > 0 && !this.isFiltered(talkDraw)) {
                    newTalk = talkDraw;
                    newIndex = oldIndex - 1;
                    break;
                }
                findOld = false;
                continue;
            }
            if (this.isFiltered(talkDraw) || matches <= 0) continue;
            newTalk = talkDraw;
            newIndex = matches - 1;
            break;
        }
        Rectangle showRect = null;
        if (oldTalk == null && firstTalk != null) {
            matches = firstTalk.getRegexMatches();
            firstTalk.setHotTargetIndex(matches - 1);
            showRect = firstTalk.getHotTargetRectangle();
        } else if (oldTalk != null && newTalk != null) {
            oldTalk.clearHotTarget();
            newTalk.setHotTargetIndex(newIndex);
            showRect = newTalk.getHotTargetRectangle();
        }
        if (showRect != null) {
            this.scrollRectWithMargin(showRect);
        }
        this.repaint();
    }

    public void clearHotTarget() {
        for (TalkDraw talkDraw : this.talkDrawList) {
            talkDraw.clearHotTarget();
        }
        this.repaint();
    }

    private void scrollRectWithMargin(Rectangle rectangle) {
        Rectangle show = new Rectangle(rectangle);
        show.y -= 50;
        show.height += 150;
        this.scrollRectToVisible(show);
    }

    private void clearSizeCache() {
        this.idealSize = null;
        this.lastWidth = -1;
        this.revalidate();
    }

    private boolean isFiltered(TextRow row) {
        Topic topic;
        if (this.topicFilter == null) {
            return false;
        }
        if (row instanceof TalkDraw) {
            topic = ((TalkDraw)row).getTalk();
        } else if (row instanceof SysEventDraw) {
            topic = ((SysEventDraw)row).getSysEvent();
        } else {
            return false;
        }
        return this.topicFilter.isFiltered(topic);
    }

    private void filterTopics() {
        for (TextRow row : this.rowList) {
            if (this.isFiltered(row)) {
                row.setVisible(false);
                continue;
            }
            row.setVisible(true);
        }
    }

    private void setWidth(int width) {
        this.lastWidth = width;
        Insets insets = this.getInsets();
        int rowWidth = width - (insets.left + insets.right);
        for (TextRow row : this.rowList) {
            row.setWidth(rowWidth);
        }
        this.layoutVertical();
    }

    private void layoutVertical() {
        Rectangle unionRect = null;
        Insets insets = this.getInsets();
        int vertPos = insets.top;
        for (TextRow row : this.rowList) {
            if (!row.isVisible()) continue;
            row.setPos(insets.left, vertPos);
            Rectangle rowBound = row.getBounds();
            vertPos += rowBound.height;
            if (unionRect == null) {
                unionRect = new Rectangle(rowBound);
                continue;
            }
            unionRect.add(rowBound);
        }
        if (unionRect == null) {
            unionRect = new Rectangle(insets.left, insets.top, 0, 0);
        }
        if (this.idealSize == null) {
            this.idealSize = new Dimension();
        }
        int newWidth = insets.left + unionRect.width + insets.right;
        int newHeight = insets.top + unionRect.height + insets.bottom;
        this.idealSize.setSize(newWidth, newHeight);
        this.setPreferredSize(this.idealSize);
        this.revalidate();
        this.repaint();
    }

    public void layoutRows() {
        int width = this.getWidth();
        this.setWidth(width);
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHints(this.hints);
        Rectangle clipRect = g2.getClipBounds();
        g2.fillRect(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
        for (TextRow row : this.rowList) {
            Rectangle rowRect;
            if (!row.isVisible() || !(rowRect = row.getBounds()).intersects(clipRect)) continue;
            row.paint(g2);
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return visibleRect.height;
        }
        return 30;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 30;
    }

    public Rectangle getTalkBounds(Talk talk) {
        if (this.topicFilter != null && this.topicFilter.isFiltered(talk)) {
            return null;
        }
        for (TalkDraw talkDraw : this.talkDrawList) {
            if (talkDraw.getTalk() != talk) continue;
            Rectangle rect = talkDraw.getBounds();
            return rect;
        }
        return null;
    }

    private void drag(Point from, Point to) {
        Rectangle dragRegion = new Rectangle();
        dragRegion.setFrameFromDiagonal(from, to);
        for (TextRow row : this.rowList) {
            if (this.isFiltered(row) || !row.getBounds().intersects(dragRegion)) continue;
            row.drag(from, to);
        }
        this.repaint();
    }

    private void clearSelect() {
        for (TextRow row : this.rowList) {
            row.clearSelect();
        }
        this.repaint();
    }

    private TalkDraw getHittedTalkDraw(Point pt) {
        for (TalkDraw talkDraw : this.talkDrawList) {
            Rectangle bounds;
            if (this.isFiltered(talkDraw) || !(bounds = talkDraw.getBounds()).contains(pt)) continue;
            return talkDraw;
        }
        return null;
    }

    private void hitAnchor(Point pt) {
        TalkDraw talkDraw = this.getHittedTalkDraw(pt);
        if (talkDraw == null) {
            return;
        }
        Anchor anchor = talkDraw.getAnchor(pt);
        if (anchor == null) {
            return;
        }
        for (AnchorHitListener listener : this.getAnchorHitListeners()) {
            AnchorHitEvent event = new AnchorHitEvent(this, talkDraw, anchor, pt);
            listener.anchorHitted(event);
        }
    }

    private void hitRegex(Point pt) {
        TalkDraw talkDraw = this.getHittedTalkDraw(pt);
        if (talkDraw == null) {
            return;
        }
        int index = talkDraw.getRegexMatchIndex(pt);
        if (index < 0) {
            return;
        }
        this.clearHotTarget();
        talkDraw.setHotTargetIndex(index);
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        Point pt = event.getPoint();
        if (event.getButton() == 1) {
            this.clearSelect();
            this.hitAnchor(pt);
            this.hitRegex(pt);
        }
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.requestFocusInWindow();
        if (event.getButton() == 1) {
            this.clearSelect();
            this.dragFrom = event.getPoint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (event.getButton() == 1) {
            this.dragFrom = null;
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        if (this.dragFrom == null) {
            return;
        }
        Point dragTo = event.getPoint();
        this.drag(this.dragFrom, dragTo);
    }

    @Override
    public void mouseMoved(MouseEvent event) {
    }

    @Override
    public void componentShown(ComponentEvent event) {
    }

    @Override
    public void componentHidden(ComponentEvent event) {
    }

    @Override
    public void componentMoved(ComponentEvent event) {
    }

    @Override
    public void componentResized(ComponentEvent event) {
        int width = this.getWidth();
        int height = this.getHeight();
        if (width != this.lastWidth) {
            this.setWidth(width);
        }
        if (this.idealSize.width != width || this.idealSize.height != height) {
            this.revalidate();
        }
    }

    public CharSequence getSelected() {
        StringBuilder selected = new StringBuilder();
        for (TextRow row : this.rowList) {
            if (this.isFiltered(row)) continue;
            try {
                row.appendSelected(selected);
            }
            catch (IOException e) {
                assert (false);
                return null;
            }
        }
        if (selected.length() <= 0) {
            return null;
        }
        return selected;
    }

    public CharSequence copySelected() {
        CharSequence selected = this.getSelected();
        if (selected == null) {
            return null;
        }
        ClipboardAction.copyToClipboard(selected);
        return selected;
    }

    public CharSequence copyTalk() {
        TalkDraw talkDraw = this.popup.lastPopupedTalkDraw;
        if (talkDraw == null) {
            return null;
        }
        Talk talk = talkDraw.getTalk();
        StringBuilder selected = new StringBuilder();
        Avatar avatar = talk.getAvatar();
        selected.append(avatar.getName()).append(' ');
        String anchor = talk.getAnchorNotation();
        selected.append(anchor);
        if (talk.hasTalkNo()) {
            selected.append(' ').append(talk.getAnchorNotation_G());
        }
        selected.append('\n');
        selected.append(talk.getDialog());
        if (selected.charAt(selected.length() - 1) != '\n') {
            selected.append('\n');
        }
        ClipboardAction.copyToClipboard(selected);
        return selected;
    }

    public Talk getPopupedTalk() {
        TalkDraw talkDraw = this.popup.lastPopupedTalkDraw;
        if (talkDraw == null) {
            return null;
        }
        Talk talk = talkDraw.getTalk();
        return talk;
    }

    public Anchor getPopupedAnchor() {
        return this.popup.lastPopupedAnchor;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.popup.updateUI();
        this.updateInputMap();
    }

    private void updateInputMap() {
        KeyStroke[] strokes;
        InputMap thisInputMap = this.getInputMap();
        InputMap sampleInputMap = new JTextField().getInputMap();
        for (KeyStroke stroke : strokes = sampleInputMap.allKeys()) {
            Object bind = sampleInputMap.get(stroke);
            if (!bind.equals("copy-to-clipboard")) continue;
            thisInputMap.put(stroke, "copy-to-clipboard");
        }
    }

    public void addActionListener(ActionListener listener) {
        this.thisListenerList.add(ActionListener.class, listener);
        this.popup.menuCopy.addActionListener(listener);
        this.popup.menuSelTalk.addActionListener(listener);
        this.popup.menuJumpAnchor.addActionListener(listener);
        this.popup.menuWebTalk.addActionListener(listener);
        this.popup.menuSummary.addActionListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.thisListenerList.remove(ActionListener.class, listener);
        this.popup.menuCopy.removeActionListener(listener);
        this.popup.menuSelTalk.removeActionListener(listener);
        this.popup.menuJumpAnchor.removeActionListener(listener);
        this.popup.menuWebTalk.removeActionListener(listener);
        this.popup.menuSummary.removeActionListener(listener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.thisListenerList.getListeners(ActionListener.class);
    }

    public void addAnchorHitListener(AnchorHitListener listener) {
        this.thisListenerList.add(AnchorHitListener.class, listener);
    }

    public void removeAnchorHitListener(AnchorHitListener listener) {
        this.thisListenerList.remove(AnchorHitListener.class, listener);
    }

    public AnchorHitListener[] getAnchorHitListeners() {
        return (AnchorHitListener[])this.thisListenerList.getListeners(AnchorHitListener.class);
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        EventListener[] result = this.thisListenerList.getListeners(listenerType);
        if (result.length <= 0) {
            result = super.getListeners(listenerType);
        }
        return result;
    }

    private class DiscussionPopup
    extends JPopupMenu {
        private final JMenuItem menuCopy = new JMenuItem("\u9078\u629e\u7bc4\u56f2\u3092\u30b3\u30d4\u30fc");
        private final JMenuItem menuSelTalk = new JMenuItem("\u3053\u306e\u767a\u8a00\u3092\u30b3\u30d4\u30fc");
        private final JMenuItem menuJumpAnchor = new JMenuItem("\u30a2\u30f3\u30ab\u30fc\u306e\u793a\u3059\u5148\u3078\u30b8\u30e3\u30f3\u30d7");
        private final JMenuItem menuWebTalk = new JMenuItem("\u3053\u306e\u767a\u8a00\u3092\u30d6\u30e9\u30a6\u30b6\u3067\u8868\u793a...");
        private final JMenuItem menuSummary = new JMenuItem("\u767a\u8a00\u3092\u96c6\u8a08...");
        private TalkDraw lastPopupedTalkDraw;
        private Anchor lastPopupedAnchor;

        public DiscussionPopup() {
            this.add(this.menuCopy);
            this.add(this.menuSelTalk);
            this.addSeparator();
            this.add(this.menuJumpAnchor);
            this.add(this.menuWebTalk);
            this.addSeparator();
            this.add(this.menuSummary);
            this.menuCopy.setActionCommand("COPY");
            this.menuSelTalk.setActionCommand("COPYTALK");
            this.menuJumpAnchor.setActionCommand("JUMPANCHOR");
            this.menuWebTalk.setActionCommand("WEBTALK");
            this.menuSummary.setActionCommand("DAYSUMMARY");
            this.menuWebTalk.setIcon(GUIUtils.getWWWIcon());
        }

        @Override
        public void show(Component comp, int x, int y) {
            Point point = new Point(x, y);
            this.lastPopupedTalkDraw = Discussion.this.getHittedTalkDraw(point);
            if (this.lastPopupedTalkDraw != null) {
                this.menuSelTalk.setEnabled(true);
                this.menuWebTalk.setEnabled(true);
            } else {
                this.menuSelTalk.setEnabled(false);
                this.menuWebTalk.setEnabled(false);
            }
            this.lastPopupedAnchor = this.lastPopupedTalkDraw != null ? this.lastPopupedTalkDraw.getAnchor(point) : null;
            if (this.lastPopupedAnchor != null) {
                this.menuJumpAnchor.setEnabled(true);
            } else {
                this.menuJumpAnchor.setEnabled(false);
            }
            if (Discussion.this.getSelected() != null) {
                this.menuCopy.setEnabled(true);
            } else {
                this.menuCopy.setEnabled(false);
            }
            super.show(comp, x, y);
        }
    }

    private class ProxyAction
    extends AbstractAction {
        private final String command;

        public ProxyAction(String command) throws NullPointerException {
            if (command == null) {
                throw new NullPointerException();
            }
            this.command = command;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object source = event.getSource();
            int id = event.getID();
            String actcmd = this.command;
            long when = event.getWhen();
            int modifiers = event.getModifiers();
            for (ActionListener listener : Discussion.this.getActionListeners()) {
                ActionEvent newEvent = new ActionEvent(source, id, actcmd, when, modifiers);
                listener.actionPerformed(newEvent);
            }
        }
    }
}

