/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jovsonz;

import java.io.IOException;
import jp.sourceforge.jovsonz.JsParseException;
import jp.sourceforge.jovsonz.JsTypes;
import jp.sourceforge.jovsonz.JsValue;
import jp.sourceforge.jovsonz.JsVisitException;
import jp.sourceforge.jovsonz.JsonSource;
import jp.sourceforge.jovsonz.ValueVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsString
implements JsValue,
CharSequence,
Comparable<JsString> {
    private static final int HEX_BASE = 16;
    private static final int NIBBLE_WIDE = 4;
    private static final int NIBBLES_CHAR = 4;
    private static final String ERRMSG_INVESC = "invalid escape character";
    private static final String ERRMSG_INVCTR = "invalid control character";
    private final String rawText;

    public JsString() {
        this("");
    }

    public JsString(CharSequence rawSeq) throws NullPointerException {
        if (rawSeq == null) {
            throw new NullPointerException();
        }
        this.rawText = ((Object)rawSeq).toString();
    }

    static char parseHexChar(JsonSource source) throws IOException, JsParseException {
        char hex1Ch = source.readOrDie();
        char hex2Ch = source.readOrDie();
        char hex3Ch = source.readOrDie();
        char hex4Ch = source.readOrDie();
        int digit1 = Character.digit(hex1Ch, 16);
        int digit2 = Character.digit(hex2Ch, 16);
        int digit3 = Character.digit(hex3Ch, 16);
        int digit4 = Character.digit(hex4Ch, 16);
        if (digit1 < 0 || digit2 < 0 || digit3 < 0 || digit4 < 0) {
            throw new JsParseException(ERRMSG_INVESC, source.getLineNumber());
        }
        int digit = 0;
        digit += digit1;
        digit <<= 4;
        digit += digit2;
        digit <<= 4;
        digit += digit3;
        digit <<= 4;
        char result = (char)(digit += digit4);
        return result;
    }

    private static void parseSpecial(JsonSource source, Appendable app) throws IOException, JsParseException {
        char special;
        char chData = source.readOrDie();
        switch (chData) {
            case '\"': {
                special = '\"';
                break;
            }
            case '\\': {
                special = '\\';
                break;
            }
            case '/': {
                special = '/';
                break;
            }
            case 'b': {
                special = '\b';
                break;
            }
            case 'f': {
                special = '\f';
                break;
            }
            case 'n': {
                special = '\n';
                break;
            }
            case 'r': {
                special = '\r';
                break;
            }
            case 't': {
                special = '\t';
                break;
            }
            case 'u': {
                special = JsString.parseHexChar(source);
                break;
            }
            default: {
                throw new JsParseException(ERRMSG_INVESC, source.getLineNumber());
            }
        }
        app.append(special);
    }

    static JsString parseString(JsonSource source) throws IOException, JsParseException {
        char chData;
        char charHead = source.readOrDie();
        if (charHead != '\"') {
            source.unread(charHead);
            return null;
        }
        StringBuilder text = new StringBuilder();
        while ((chData = source.readOrDie()) != '\"') {
            if (chData == '\\') {
                JsString.parseSpecial(source, text);
                continue;
            }
            if (Character.isISOControl(chData)) {
                throw new JsParseException(ERRMSG_INVCTR, source.getLineNumber());
            }
            text.append(chData);
        }
        JsString result = new JsString(text);
        return result;
    }

    private static char escapeSymbol(char ch) {
        char result;
        switch (ch) {
            case '\"': {
                result = '\"';
                break;
            }
            case '\\': {
                result = '\\';
                break;
            }
            case '/': {
                result = '/';
                break;
            }
            case '\b': {
                result = 'b';
                break;
            }
            case '\f': {
                result = 'f';
                break;
            }
            case '\n': {
                result = 'n';
                break;
            }
            case '\r': {
                result = 'r';
                break;
            }
            case '\t': {
                result = 't';
                break;
            }
            default: {
                result = '\u0000';
            }
        }
        return result;
    }

    private static boolean dumpSpecialChar(Appendable appout, char ch) throws IOException {
        char esc1ch = JsString.escapeSymbol(ch);
        if (esc1ch != '\u0000') {
            appout.append('\\').append(esc1ch);
        } else if (Character.isISOControl(ch)) {
            String hex = "0000" + Integer.toHexString(ch);
            hex = hex.substring(hex.length() - 4);
            appout.append("\\u").append(hex);
        } else {
            return false;
        }
        return true;
    }

    public static void dumpString(Appendable appout, CharSequence seq) throws IOException {
        appout.append('\"');
        int length = seq.length();
        for (int pos = 0; pos < length; ++pos) {
            char ch = seq.charAt(pos);
            if (JsString.dumpSpecialChar(appout, ch)) continue;
            appout.append(ch);
        }
        appout.append('\"');
    }

    public static StringBuilder escapeText(CharSequence seq) {
        StringBuilder result = new StringBuilder();
        try {
            JsString.dumpString(result, seq);
        }
        catch (IOException e) {
            assert (false);
            throw new AssertionError((Object)e);
        }
        return result;
    }

    @Override
    public JsTypes getJsTypes() {
        return JsTypes.STRING;
    }

    @Override
    public void traverse(ValueVisitor visitor) throws JsVisitException {
        visitor.visitValue(this);
    }

    public int hashCode() {
        return this.rawText.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JsString)) {
            return false;
        }
        JsString string = (JsString)obj;
        return this.rawText.equals(string.rawText);
    }

    @Override
    public int compareTo(JsString value) {
        if (this == value) {
            return 0;
        }
        if (value == null) {
            return 1;
        }
        return this.rawText.compareTo(value.rawText);
    }

    @Override
    public char charAt(int index) throws IndexOutOfBoundsException {
        return this.rawText.charAt(index);
    }

    @Override
    public int length() {
        return this.rawText.length();
    }

    @Override
    public CharSequence subSequence(int start, int end) throws IndexOutOfBoundsException {
        return this.rawText.subSequence(start, end);
    }

    public String toRawString() {
        return this.rawText;
    }

    @Override
    public String toString() {
        StringBuilder string = JsString.escapeText(this.rawText);
        return string.toString();
    }
}

