/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf;

import java.awt.Component;
import java.io.PrintStream;
import javax.swing.JOptionPane;

public final class JreChecker {
    public static final String REQUIRED_JRE_VER = "1.6";
    public static final int EXIT_CODE_INCOMPAT_JRE = 1;
    private static final PrintStream STDERR = System.err;
    private static final String DIALOG_TITLE = "JRE Incompatibility detected...";
    private static final int MAX_LINE = 40;
    private static final int DEF_LINES = 5;
    private static final int INIT_SBUF = 100;

    private JreChecker() {
    }

    public static boolean hasClass(String klassName) {
        boolean result;
        try {
            Class.forName(klassName);
            result = true;
        }
        catch (ClassNotFoundException e) {
            result = false;
        }
        return result;
    }

    public static boolean has11Runtime() {
        boolean result = JreChecker.hasClass("java.io.Serializable");
        return result;
    }

    public static boolean has12Runtime() {
        boolean result = JreChecker.has11Runtime() ? JreChecker.hasClass("java.util.Iterator") : false;
        return result;
    }

    public static boolean has13Runtime() {
        boolean result = JreChecker.has12Runtime() ? JreChecker.hasClass("java.util.TimerTask") : false;
        return result;
    }

    public static boolean has14Runtime() {
        boolean result = JreChecker.has13Runtime() ? JreChecker.hasClass("java.lang.CharSequence") : false;
        return result;
    }

    public static boolean has15Runtime() {
        boolean result = JreChecker.has14Runtime() ? JreChecker.hasClass("java.lang.Appendable") : false;
        return result;
    }

    public static boolean has16Runtime() {
        boolean result = JreChecker.has15Runtime() ? JreChecker.hasClass("java.util.Deque") : false;
        return result;
    }

    public static String getLangPkgSpec() {
        String result;
        try {
            result = System.getProperty("java.specification.version");
        }
        catch (SecurityException e) {
            result = null;
        }
        if (result != null) {
            return result;
        }
        try {
            result = System.getProperty("java.version");
        }
        catch (SecurityException e) {
            result = null;
        }
        if (result != null) {
            return result;
        }
        Package javaLangPkg = Object.class.getPackage();
        if (javaLangPkg == null) {
            return null;
        }
        result = javaLangPkg.getSpecificationVersion();
        return result;
    }

    public static String getJreHome() {
        String result;
        try {
            result = System.getProperty("java.home");
        }
        catch (SecurityException e) {
            result = null;
        }
        return result;
    }

    public static String buildErrMessage() {
        String jreHome;
        StringBuffer message = new StringBuffer(100);
        message.append("ERROR : Java JRE ").append(REQUIRED_JRE_VER).append(" compatible or later required.");
        String specVer = JreChecker.getLangPkgSpec();
        if (specVer != null) {
            message.append("\nbut ").append(specVer).append(" detected.");
        }
        if ((jreHome = JreChecker.getJreHome()) != null) {
            message.append("  [ ").append(jreHome).append(" ]");
        }
        return message.toString();
    }

    public static String alignLine(String text, int limit) {
        int textLength = text.length();
        StringBuffer message = new StringBuffer(textLength + 5);
        int lineLength = 0;
        for (int idx = 0; idx < textLength; ++idx) {
            if (lineLength >= limit) {
                message.append('\n');
                lineLength = 0;
            }
            char ch = text.charAt(idx);
            message.append(ch);
            if (ch == '\n') {
                lineLength = 0;
                continue;
            }
            ++lineLength;
        }
        String result = message.toString();
        return result;
    }

    public static int checkJre() {
        if (JreChecker.has16Runtime()) {
            return 0;
        }
        String message = JreChecker.buildErrMessage();
        STDERR.println(message);
        STDERR.flush();
        if (JreChecker.has12Runtime()) {
            JreChecker.showErrorDialog(message);
        }
        return 1;
    }

    public static void showErrorDialog(String text) {
        String aligned = JreChecker.alignLine(text, 40);
        Component parent = null;
        JOptionPane.showMessageDialog(parent, aligned, DIALOG_TITLE, 0);
    }
}

