/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf;

import java.text.MessageFormat;
import java.util.Properties;
import jp.sfjp.jindolf.ResourceManager;

public final class VerInfo {
    public static final String TITLE;
    public static final String VERSION;
    public static final String AUTHOR;
    public static final String COPYRIGHT;
    public static final String LICENSE;
    public static final String CONTACT;
    public static final String INCEPTION;
    public static final String COMMENT;
    public static final String ID;
    private static final String RES_VERDEF = "resources/version.properties";
    private static final String PFX_TITLE = "pkg-title.";
    private static final String PFX_VERSION = "pkg-version.";
    private static final String PFX_AUTHOR = "pkg-author.";
    private static final String PFX_LICENSE = "pkg-license.";
    private static final String PFX_CONTACT = "pkg-contact.";
    private static final String PFX_INCEPTION = "pkg-inception.";
    private static final String PFX_COMMENT = "pkg-comment.";

    private VerInfo() {
        assert (false);
    }

    static String getPackageInfo(Properties prop, String prefix, String defValue) {
        String result = VerInfo.getPackageInfo(prop, prefix, ResourceManager.DEF_ROOT_PACKAGE, defValue);
        return result;
    }

    static String getPackageInfo(Properties prop, String prefix, Package pkg, String defValue) {
        String propKeyName = prefix + pkg.getName();
        String result = prop.getProperty(propKeyName, defValue);
        if (VerInfo.isMavenMacro(result)) {
            result = defValue;
        }
        return result;
    }

    public static boolean isMavenMacro(String text) {
        return text.startsWith("${") && text.endsWith("}");
    }

    public static String getFrameTitle(String base) {
        StringBuilder result = new StringBuilder();
        if (base != null) {
            result.append(base).append(" - ");
        }
        result.append(TITLE);
        String message = result.toString();
        return message;
    }

    public static String getAboutMessage() {
        StringBuilder result = new StringBuilder();
        result.append(MessageFormat.format("{0}   Version {1}\n{2}\n\u30e9\u30a4\u30bb\u30f3\u30b9: {3}\n\u9023\u7d61\u5148: {4}", TITLE, VERSION, COPYRIGHT, LICENSE, CONTACT));
        if (COMMENT.length() > 0) {
            result.append('\n').append(COMMENT);
        }
        String message = result.toString();
        return message;
    }

    static {
        Properties verProp = ResourceManager.getProperties(RES_VERDEF);
        if (verProp == null) {
            verProp = new Properties();
        }
        TITLE = VerInfo.getPackageInfo(verProp, PFX_TITLE, "Jindolf");
        VERSION = VerInfo.getPackageInfo(verProp, PFX_VERSION, "0.0.1");
        AUTHOR = VerInfo.getPackageInfo(verProp, PFX_AUTHOR, "nobody");
        LICENSE = VerInfo.getPackageInfo(verProp, PFX_LICENSE, "Unknown");
        CONTACT = VerInfo.getPackageInfo(verProp, PFX_CONTACT, "Where?");
        INCEPTION = VerInfo.getPackageInfo(verProp, PFX_INCEPTION, "2008");
        COMMENT = VerInfo.getPackageInfo(verProp, PFX_COMMENT, "");
        COPYRIGHT = MessageFormat.format("Copyright(c) {0} {1}", INCEPTION, AUTHOR);
        ID = MessageFormat.format("{0} Ver.{1} {2} ({3})", TITLE, VERSION, COPYRIGHT, LICENSE);
    }
}

