/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.config;

import java.awt.Font;
import java.awt.Rectangle;
import java.io.File;
import jp.sfjp.jindolf.config.CmdOption;
import jp.sfjp.jindolf.config.ConfigFile;
import jp.sfjp.jindolf.config.ConfigStore;
import jp.sfjp.jindolf.config.FileUtils;
import jp.sfjp.jindolf.config.OptionInfo;
import jp.sfjp.jindolf.data.DialogPref;
import jp.sfjp.jindolf.glyph.Font2Json;
import jp.sfjp.jindolf.glyph.FontInfo;
import jp.sfjp.jindolf.net.ProxyInfo;
import jp.sourceforge.jovsonz.JsBoolean;
import jp.sourceforge.jovsonz.JsObject;
import jp.sourceforge.jovsonz.JsPair;
import jp.sourceforge.jovsonz.JsValue;

public class AppSetting {
    private static final int DEF_WIDTH = 800;
    private static final int DEF_HEIGHT = 600;
    private static final String HASH_FONT = "font";
    private static final String HASH_USEBODYICON = "useBodyIcon";
    private static final String HASH_USEMONOTOMB = "useMonoTomb";
    private static final String HASH_SIMPLEMODE = "isSimpleMode";
    private static final String HASH_ALIGNBALOON = "alignBaloonWidth";
    private static final String HASH_PROXY = "proxy";
    private final OptionInfo optInfo;
    private final ConfigStore configStore;
    private final Rectangle frameRect;
    private FontInfo fontInfo;
    private ProxyInfo proxyInfo = ProxyInfo.DEFAULT;
    private DialogPref dialogPref = new DialogPref();
    private JsValue loadedNetConfig;
    private JsValue loadedTalkConfig;

    public AppSetting(OptionInfo info) {
        this.optInfo = info;
        this.configStore = AppSetting.parseConfigStore(this.optInfo);
        this.frameRect = AppSetting.parseGeometrySetting(this.optInfo);
    }

    private static ConfigStore parseConfigStore(OptionInfo option) {
        File configPath;
        boolean isImplicitPath;
        boolean useConfig;
        CmdOption opt = option.getExclusiveOption(CmdOption.OPT_CONFDIR, CmdOption.OPT_NOCONF);
        if (opt == CmdOption.OPT_NOCONF) {
            useConfig = false;
            isImplicitPath = true;
            configPath = null;
        } else if (opt == CmdOption.OPT_CONFDIR) {
            useConfig = true;
            isImplicitPath = false;
            String optPath = option.getStringArg(opt);
            configPath = FileUtils.supplyFullPath(new File(optPath));
        } else {
            useConfig = true;
            isImplicitPath = true;
            configPath = ConfigFile.getImplicitConfigDirectory();
        }
        ConfigStore result = new ConfigStore(useConfig, isImplicitPath, configPath);
        return result;
    }

    private static Rectangle parseGeometrySetting(OptionInfo option) {
        Rectangle result = new Rectangle(Integer.MIN_VALUE, Integer.MIN_VALUE, 800, 600);
        Integer ival = option.initialFrameWidth();
        if (ival != null) {
            result.width = ival;
        }
        if ((ival = option.initialFrameHeight()) != null) {
            result.height = ival;
        }
        if ((ival = option.initialFrameXpos()) != null) {
            result.x = ival;
        }
        if ((ival = option.initialFrameYpos()) != null) {
            result.y = ival;
        }
        return result;
    }

    private FontInfo parseFontOption(FontInfo baseFont) {
        Boolean useFractional;
        FontInfo result;
        String fontName = this.optInfo.getStringArg(CmdOption.OPT_INITFONT);
        if (fontName != null) {
            Font font = Font.decode(fontName);
            result = baseFont.deriveFont(font);
        } else {
            result = baseFont;
        }
        Boolean useAntiAlias = this.optInfo.getBooleanArg(CmdOption.OPT_ANTIALIAS);
        if (useAntiAlias == null) {
            useAntiAlias = baseFont.isAntiAliased();
        }
        if ((useFractional = this.optInfo.getBooleanArg(CmdOption.OPT_FRACTIONAL)) == null) {
            useFractional = baseFont.usesFractionalMetrics();
        }
        result = result.deriveRenderContext(useAntiAlias, useFractional);
        return result;
    }

    public OptionInfo getOptionInfo() {
        return this.optInfo;
    }

    public ConfigStore getConfigStore() {
        return this.configStore;
    }

    public int initialFrameWidth() {
        int width = this.frameRect.width;
        return width;
    }

    public int initialFrameHeight() {
        int height = this.frameRect.height;
        return height;
    }

    public int initialFrameXpos() {
        int xPos = this.frameRect.x;
        return xPos;
    }

    public int initialFrameYpos() {
        int yPos = this.frameRect.y;
        return yPos;
    }

    public FontInfo getFontInfo() {
        if (this.fontInfo == null) {
            this.fontInfo = this.parseFontOption(FontInfo.DEFAULT_FONTINFO);
        }
        return this.fontInfo;
    }

    public void setFontInfo(FontInfo fontInfo) {
        this.fontInfo = fontInfo;
    }

    public ProxyInfo getProxyInfo() {
        return this.proxyInfo;
    }

    public void setProxyInfo(ProxyInfo proxyInfo) {
        this.proxyInfo = proxyInfo == null ? ProxyInfo.DEFAULT : proxyInfo;
    }

    public DialogPref getDialogPref() {
        return this.dialogPref;
    }

    public void setDialogPref(DialogPref pref) {
        this.dialogPref = pref == null ? new DialogPref() : pref;
    }

    private void loadNetConfig() {
        JsObject root = this.configStore.loadNetConfig();
        if (root == null) {
            return;
        }
        this.loadedNetConfig = root;
        JsValue value = root.getValue(HASH_PROXY);
        if (!(value instanceof JsObject)) {
            return;
        }
        JsObject proxy = (JsObject)value;
        ProxyInfo info = ProxyInfo.decodeJson(proxy);
        this.setProxyInfo(info);
    }

    private void loadTalkConfig() {
        JsBoolean boolValue;
        JsObject root = this.configStore.loadTalkConfig();
        if (root == null) {
            return;
        }
        this.loadedTalkConfig = root;
        JsValue value = root.getValue(HASH_FONT);
        if (value instanceof JsObject) {
            JsObject font = (JsObject)value;
            FontInfo info = Font2Json.decodeJson(font);
            info = this.parseFontOption(info);
            this.setFontInfo(info);
        }
        DialogPref pref = new DialogPref();
        value = root.getValue(HASH_USEBODYICON);
        if (value instanceof JsBoolean) {
            boolValue = (JsBoolean)value;
            pref.setBodyImageSetting(boolValue.booleanValue());
        }
        if ((value = root.getValue(HASH_USEMONOTOMB)) instanceof JsBoolean) {
            boolValue = (JsBoolean)value;
            pref.setMonoImageSetting(boolValue.booleanValue());
        }
        if ((value = root.getValue(HASH_SIMPLEMODE)) instanceof JsBoolean) {
            boolValue = (JsBoolean)value;
            pref.setSimpleMode(boolValue.booleanValue());
        }
        if ((value = root.getValue(HASH_ALIGNBALOON)) instanceof JsBoolean) {
            boolValue = (JsBoolean)value;
            pref.setAlignBalooonWidthSetting(boolValue.booleanValue());
        }
        this.setDialogPref(pref);
    }

    private void saveNetConfig() {
        if (!this.getConfigStore().useStoreFile()) {
            return;
        }
        JsObject root = new JsObject();
        JsObject proxy = ProxyInfo.buildJson(this.getProxyInfo());
        root.putValue(HASH_PROXY, proxy);
        if (this.loadedNetConfig != null && this.loadedNetConfig.equals(root)) {
            return;
        }
        this.configStore.saveNetConfig(root);
    }

    private void saveTalkConfig() {
        if (!this.getConfigStore().useStoreFile()) {
            return;
        }
        JsObject root = new JsObject();
        JsObject font = Font2Json.buildJson(this.getFontInfo());
        root.putValue(HASH_FONT, font);
        DialogPref pref = this.getDialogPref();
        JsPair useBodyIcon = new JsPair(HASH_USEBODYICON, pref.useBodyImage());
        JsPair useMonoTomb = new JsPair(HASH_USEMONOTOMB, pref.useMonoImage());
        JsPair isSimple = new JsPair(HASH_SIMPLEMODE, pref.isSimpleMode());
        JsPair alignBaloon = new JsPair(HASH_ALIGNBALOON, pref.alignBaloonWidth());
        root.putPair(useBodyIcon);
        root.putPair(useMonoTomb);
        root.putPair(isSimple);
        root.putPair(alignBaloon);
        if (this.loadedTalkConfig != null && this.loadedTalkConfig.equals(root)) {
            return;
        }
        this.configStore.saveTalkConfig(root);
    }

    public void loadConfig() {
        this.loadNetConfig();
        this.loadTalkConfig();
    }

    public void saveConfig() {
        this.saveNetConfig();
        this.saveTalkConfig();
    }
}

