/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.data;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.sfjp.jindolf.data.Anchor;
import jp.sfjp.jindolf.data.Avatar;
import jp.sfjp.jindolf.data.Land;
import jp.sfjp.jindolf.data.Period;
import jp.sfjp.jindolf.data.Talk;
import jp.sfjp.jindolf.data.Topic;
import jp.sfjp.jindolf.net.HtmlSequence;
import jp.sfjp.jindolf.net.ServerAccess;
import jp.sfjp.jindolf.util.GUIUtils;
import jp.sourceforge.jindolf.corelib.LandDef;
import jp.sourceforge.jindolf.corelib.LandState;
import jp.sourceforge.jindolf.corelib.PeriodType;
import jp.sourceforge.jindolf.corelib.VillageState;
import jp.sourceforge.jindolf.parser.DecodedContent;
import jp.sourceforge.jindolf.parser.HtmlAdapter;
import jp.sourceforge.jindolf.parser.HtmlParseException;
import jp.sourceforge.jindolf.parser.HtmlParser;
import jp.sourceforge.jindolf.parser.PageType;
import jp.sourceforge.jindolf.parser.SeqRange;

public class Village
implements Comparable<Village> {
    private static final int GID_MIN = 3;
    private static final Comparator<Village> VILLAGE_COMPARATOR = new VillageComparator();
    private static final HtmlParser PARSER = new HtmlParser();
    private static final VillageHeadHandler HANDLER = new VillageHeadHandler();
    private static final Logger LOGGER = Logger.getAnonymousLogger();
    private final Land parentLand;
    private final String villageID;
    private final int villageIDNum;
    private final String villageName;
    private final boolean isValid;
    private int limitMonth;
    private int limitDay;
    private int limitHour;
    private int limitMinute;
    private VillageState state = VillageState.UNKNOWN;
    private final LinkedList<Period> periodList = new LinkedList();
    private final List<Period> unmodList = Collections.unmodifiableList(this.periodList);
    private final Map<String, Avatar> avatarMap = new HashMap<String, Avatar>();
    private final Map<Avatar, BufferedImage> faceImageMap = new HashMap<Avatar, BufferedImage>();
    private final Map<Avatar, BufferedImage> bodyImageMap = new HashMap<Avatar, BufferedImage>();
    private final Map<Avatar, BufferedImage> faceMonoImageMap = new HashMap<Avatar, BufferedImage>();
    private final Map<Avatar, BufferedImage> bodyMonoImageMap = new HashMap<Avatar, BufferedImage>();

    public Village(Land parentLand, String villageID, String villageName) {
        this.parentLand = parentLand;
        this.villageID = villageID.intern();
        this.villageIDNum = Integer.parseInt(this.villageID);
        this.villageName = villageName.intern();
        this.isValid = this.parentLand.getLandDef().isValidVillageId(this.villageIDNum);
    }

    public static Comparator<Village> comparator() {
        return VILLAGE_COMPARATOR;
    }

    public static synchronized void updateVillage(Village village) throws IOException {
        Land land = village.getParentLand();
        LandDef landDef = land.getLandDef();
        LandState landState = landDef.getLandState();
        ServerAccess server = land.getServerAccess();
        HtmlSequence html = landState == LandState.ACTIVE ? server.getHTMLBoneHead(village) : server.getHTMLVillage(village);
        DecodedContent content = html.getContent();
        HANDLER.setVillage(village);
        try {
            PARSER.parseAutomatic(content);
        }
        catch (HtmlParseException e) {
            LOGGER.log(Level.WARNING, "\u6751\u306e\u72b6\u614b\u304c\u4e0d\u660e", e);
        }
    }

    public Land getParentLand() {
        return this.parentLand;
    }

    public String getVillageID() {
        return this.villageID;
    }

    public int getVillageIDNum() {
        return this.villageIDNum;
    }

    public String getVillageName() {
        StringBuilder name = new StringBuilder();
        LandDef landDef = this.parentLand.getLandDef();
        String prefix = landDef.getLandPrefix();
        name.append(prefix);
        StringBuilder id = new StringBuilder(this.villageID);
        if (landDef.getLandId().equals("wolfg")) {
            while (id.length() < 3) {
                id.insert(0, '0');
            }
        }
        name.append((CharSequence)id);
        String result = name.toString();
        return result;
    }

    public String getVillageFullName() {
        return this.villageName;
    }

    public VillageState getState() {
        return this.state;
    }

    public void setState(VillageState state) {
        this.state = state;
    }

    public Period getPrologue() {
        for (Period period : this.periodList) {
            if (!period.isPrologue()) continue;
            return period;
        }
        return null;
    }

    public Period getEpilogue() {
        for (Period period : this.periodList) {
            if (!period.isEpilogue()) continue;
            return period;
        }
        return null;
    }

    public Period getProgress(int day) {
        for (Period period : this.periodList) {
            if (!period.isProgress() || period.getDay() != day) continue;
            return period;
        }
        return null;
    }

    public int getProgressDays() {
        int result = 0;
        for (Period period : this.periodList) {
            if (!period.isProgress()) continue;
            ++result;
        }
        return result;
    }

    public Period getPeriod(int day) {
        return this.periodList.get(day);
    }

    public Period getPeriod(Anchor anchor) {
        if (anchor.isEpilogueDay()) {
            Period anchorPeriod = this.getEpilogue();
            return anchorPeriod;
        }
        int anchorDay = anchor.getDay();
        Period anchorPeriod = this.getPeriod(anchorDay);
        return anchorPeriod;
    }

    public int getPeriodSize() {
        return this.periodList.size();
    }

    public List<Period> getPeriodList() {
        return this.unmodList;
    }

    public Avatar getAvatar(String fullName) {
        Avatar avatar = Avatar.getPredefinedAvatar(fullName);
        if (avatar != null) {
            this.preloadAvatarFace(avatar);
            return avatar;
        }
        avatar = this.avatarMap.get(fullName);
        if (avatar != null) {
            this.preloadAvatarFace(avatar);
            return avatar;
        }
        return null;
    }

    private void preloadAvatarFace(Avatar avatar) {
        if (this.faceImageMap.get(avatar) != null) {
            return;
        }
        Land land = this.getParentLand();
        LandDef landDef = land.getLandDef();
        String template = landDef.getFaceURITemplate();
        int serialNo = avatar.getIdNum();
        String uri = MessageFormat.format(template, serialNo);
        BufferedImage image = land.downloadImage(uri);
        if (image == null) {
            image = GUIUtils.getNoImage();
        }
        this.faceImageMap.put(avatar, image);
    }

    public void addAvatar(Avatar avatar) {
        if (avatar == null) {
            return;
        }
        String fullName = avatar.getFullName();
        this.avatarMap.put(fullName, avatar);
        this.preloadAvatarFace(avatar);
    }

    public BufferedImage getAvatarFaceImage(Avatar avatar) {
        return this.faceImageMap.get(avatar);
    }

    public BufferedImage getAvatarBodyImage(Avatar avatar) {
        BufferedImage result = this.bodyImageMap.get(avatar);
        if (result != null) {
            return result;
        }
        Land land = this.getParentLand();
        LandDef landDef = land.getLandDef();
        String template = landDef.getBodyURITemplate();
        int serialNo = avatar.getIdNum();
        String uri = MessageFormat.format(template, serialNo);
        result = land.downloadImage(uri);
        if (result == null) {
            result = GUIUtils.getNoImage();
        }
        this.bodyImageMap.put(avatar, result);
        return result;
    }

    public BufferedImage getAvatarFaceMonoImage(Avatar avatar) {
        BufferedImage result = this.faceMonoImageMap.get(avatar);
        if (result == null) {
            result = this.getAvatarFaceImage(avatar);
            result = GUIUtils.createMonoImage(result);
            this.faceMonoImageMap.put(avatar, result);
        }
        return result;
    }

    public BufferedImage getAvatarBodyMonoImage(Avatar avatar) {
        BufferedImage result = this.bodyMonoImageMap.get(avatar);
        if (result == null) {
            result = this.getAvatarBodyImage(avatar);
            result = GUIUtils.createMonoImage(result);
            this.bodyMonoImageMap.put(avatar, result);
        }
        return result;
    }

    public BufferedImage getGraveImage() {
        BufferedImage result = this.getParentLand().getGraveIconImage();
        return result;
    }

    public BufferedImage getGraveBodyImage() {
        BufferedImage result = this.getParentLand().getGraveBodyImage();
        return result;
    }

    public CharSequence getCGIQuery() {
        StringBuilder result = new StringBuilder();
        result.append("?vid=").append(this.getVillageID());
        return result;
    }

    public int getLimitMonth() {
        return this.limitMonth;
    }

    public int getLimitDay() {
        return this.limitDay;
    }

    public int getLimitHour() {
        return this.limitHour;
    }

    public int getLimitMinute() {
        return this.limitMinute;
    }

    public boolean isValid() {
        return this.isValid;
    }

    private void setPeriod(int index, Period period) throws IndexOutOfBoundsException {
        int listSize = this.periodList.size();
        if (index == listSize) {
            this.periodList.add(period);
        } else if (index < listSize) {
            this.periodList.set(index, period);
        } else {
            throw new IndexOutOfBoundsException();
        }
    }

    public List<Talk> getTalkListFromAnchor(Anchor anchor) throws IOException {
        LinkedList<Talk> result = new LinkedList<Talk>();
        if (anchor.hasTalkNo()) {
            for (Period period : this.periodList) {
                Talk talk = period.getNumberedTalk(anchor.getTalkNo());
                if (talk == null) continue;
                result.add(talk);
            }
            return result;
        }
        Period anchorPeriod = this.getPeriod(anchor);
        if (anchorPeriod == null) {
            return result;
        }
        Period.parsePeriod(anchorPeriod, false);
        for (Topic topic : anchorPeriod.getTopicList()) {
            Talk talk;
            if (!(topic instanceof Talk) || (talk = (Talk)topic).getHour() != anchor.getHour() || talk.getMinute() != anchor.getMinute()) continue;
            result.add(talk);
        }
        return result;
    }

    public void unloadPeriods() {
        for (Period period : this.periodList) {
            period.unload();
        }
    }

    @Override
    public int compareTo(Village village) {
        int cmpResult = VILLAGE_COMPARATOR.compare(this, village);
        return cmpResult;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Village)) {
            return false;
        }
        Village village = (Village)obj;
        if (this.getParentLand() != village.getParentLand()) {
            return false;
        }
        int cmpResult = this.compareTo(village);
        return cmpResult == 0;
    }

    public int hashCode() {
        int homeHash = this.getParentLand().hashCode();
        int vidHash = this.getVillageID().hashCode();
        int result = homeHash ^ vidHash;
        return result;
    }

    public String toString() {
        return this.getVillageFullName();
    }

    static {
        PARSER.setBasicHandler(HANDLER);
        PARSER.setSysEventHandler(HANDLER);
        PARSER.setTalkHandler(HANDLER);
    }

    private static class VillageHeadHandler
    extends HtmlAdapter {
        private Village village = null;
        private boolean hasPrologue;
        private boolean hasProgress;
        private boolean hasEpilogue;
        private boolean hasDone;
        private int maxProgress;

        public void setVillage(Village village) {
            this.village = village;
        }

        public void reset() {
            this.hasPrologue = false;
            this.hasProgress = false;
            this.hasEpilogue = false;
            this.hasDone = false;
            this.maxProgress = 0;
        }

        public VillageState getVillageState() {
            if (this.hasDone) {
                return VillageState.GAMEOVER;
            }
            if (this.hasEpilogue) {
                return VillageState.EPILOGUE;
            }
            if (this.hasProgress) {
                return VillageState.PROGRESS;
            }
            if (this.hasPrologue) {
                return VillageState.PROLOGUE;
            }
            return VillageState.UNKNOWN;
        }

        @Override
        public void startParse(DecodedContent content) throws HtmlParseException {
            this.reset();
        }

        @Override
        public void pageType(PageType type) throws HtmlParseException {
            if (type != PageType.PERIOD_PAGE) {
                throw new HtmlParseException("\u65e5\u30da\u30fc\u30b8\u304c\u5fc5\u8981\u3067\u3059\u3002");
            }
        }

        @Override
        public void commitTime(int month, int day, int hour, int minute) throws HtmlParseException {
            this.village.limitMonth = month;
            this.village.limitDay = day;
            this.village.limitHour = hour;
            this.village.limitMinute = minute;
        }

        @Override
        public void periodLink(DecodedContent content, SeqRange anchorRange, PeriodType periodType, int day) throws HtmlParseException {
            if (periodType == null) {
                this.hasDone = true;
                return;
            }
            switch (periodType) {
                case PROLOGUE: {
                    this.hasPrologue = true;
                    break;
                }
                case PROGRESS: {
                    this.hasProgress = true;
                    this.maxProgress = day;
                    break;
                }
                case EPILOGUE: {
                    this.hasEpilogue = true;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        @Override
        public void endParse() throws HtmlParseException {
            Land land = this.village.getParentLand();
            LandDef landDef = land.getLandDef();
            LandState landState = landDef.getLandState();
            VillageState villageState = this.getVillageState();
            if (villageState == VillageState.UNKNOWN) {
                this.village.setState(villageState);
                this.village.periodList.clear();
                LOGGER.warning("\u6751\u306e\u72b6\u6cc1\u3092\u8aad\u307f\u53d6\u308c\u307e\u305b\u3093");
                return;
            }
            if (landState == LandState.ACTIVE) {
                this.village.setState(villageState);
            } else {
                this.village.setState(VillageState.GAMEOVER);
            }
            this.modifyPeriodList();
        }

        private void modifyPeriodList() {
            Period lastPeriod = null;
            if (this.hasPrologue) {
                Period prologue = this.village.getPrologue();
                if (prologue == null) {
                    lastPeriod = new Period(this.village, PeriodType.PROLOGUE, 0);
                    this.village.setPeriod(0, lastPeriod);
                } else {
                    lastPeriod = prologue;
                }
            }
            if (this.hasProgress) {
                for (int day = 1; day <= this.maxProgress; ++day) {
                    Period progress = this.village.getProgress(day);
                    if (progress == null) {
                        lastPeriod = new Period(this.village, PeriodType.PROGRESS, day);
                        this.village.setPeriod(day, lastPeriod);
                        continue;
                    }
                    lastPeriod = progress;
                }
            }
            if (this.hasEpilogue) {
                Period epilogue = this.village.getEpilogue();
                if (epilogue == null) {
                    lastPeriod = new Period(this.village, PeriodType.EPILOGUE, this.maxProgress + 1);
                    this.village.setPeriod(this.maxProgress + 1, lastPeriod);
                } else {
                    lastPeriod = epilogue;
                }
            }
            assert (this.village.getPeriodSize() > 0);
            assert (lastPeriod != null);
            while (this.village.periodList.getLast() != lastPeriod) {
                this.village.periodList.removeLast();
            }
            if (this.village.getState() != VillageState.GAMEOVER) {
                lastPeriod.setHot(true);
            }
        }
    }

    private static class VillageComparator
    implements Comparator<Village> {
        @Override
        public int compare(Village v1, Village v2) {
            int v1Num = v1 == null ? Integer.MIN_VALUE : v1.getVillageIDNum();
            int v2Num = v2 == null ? Integer.MIN_VALUE : v2.getVillageIDNum();
            return v1Num - v2Num;
        }
    }
}

