/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.glyph;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.sfjp.jindolf.ResourceManager;
import jp.sfjp.jindolf.dxchg.TextPopup;
import jp.sfjp.jindolf.glyph.FontInfo;
import jp.sfjp.jindolf.glyph.FontPreviewer;
import jp.sfjp.jindolf.glyph.FontSelectList;
import jp.sfjp.jindolf.util.Monodizer;

public class FontChooser
extends JPanel
implements ListSelectionListener,
ActionListener,
ItemListener {
    private static final int[] POINT_SIZES = new int[]{8, 10, 12, 16, 18, 24, 32, 36, 48, 72};
    private static final CharSequence PREVIEW_CONTENT;
    private static final int UNIT_INC = 8;
    private static final Logger LOGGER;
    private FontInfo fontInfo;
    private FontInfo lastFontInfo;
    private final FontSelectList familySelector;
    private final JComboBox sizeSelector;
    private final JCheckBox isBoldCheck;
    private final JCheckBox isItalicCheck;
    private final JCheckBox useTextAntiAliaseCheck;
    private final JCheckBox useFractionalCheck;
    private final JLabel maxBounds;
    private final JTextField decodeName;
    private final FontPreviewer preview;
    private final JButton resetDefault;
    private boolean maskListener = false;

    public FontChooser() {
        this(FontInfo.DEFAULT_FONTINFO);
    }

    public FontChooser(FontInfo fontInfo) throws NullPointerException {
        if (fontInfo == null) {
            throw new NullPointerException();
        }
        this.fontInfo = fontInfo;
        this.lastFontInfo = fontInfo;
        FontChooser.logging(this.fontInfo);
        this.familySelector = new FontSelectList();
        this.sizeSelector = new JComboBox();
        this.sizeSelector.setEditable(true);
        for (int size : POINT_SIZES) {
            this.sizeSelector.addItem(size);
        }
        this.isBoldCheck = new JCheckBox("\u30dc\u30fc\u30eb\u30c9");
        this.isItalicCheck = new JCheckBox("\u30a4\u30bf\u30ea\u30c3\u30af");
        this.useTextAntiAliaseCheck = new JCheckBox("\u30a2\u30f3\u30c1\u30a8\u30a4\u30ea\u30a2\u30b9");
        this.useFractionalCheck = new JCheckBox("\u30b5\u30d6\u30d4\u30af\u30bb\u30eb\u7cbe\u5ea6");
        this.maxBounds = new JLabel();
        this.decodeName = new JTextField();
        this.decodeName.setEditable(false);
        this.decodeName.setMargin(new Insets(1, 4, 1, 4));
        this.decodeName.setComponentPopupMenu(new TextPopup());
        Monodizer.monodize(this.decodeName);
        this.preview = new FontPreviewer(PREVIEW_CONTENT, this.fontInfo);
        this.resetDefault = new JButton("\u51fa\u8377\u6642\u306b\u623b\u3059");
        this.design(this);
        this.updateControlls();
        this.familySelector.addListSelectionListener(this);
        this.sizeSelector.addActionListener(this);
        this.isBoldCheck.addItemListener(this);
        this.isItalicCheck.addItemListener(this);
        this.useTextAntiAliaseCheck.addItemListener(this);
        this.useFractionalCheck.addItemListener(this);
        this.resetDefault.addActionListener(this);
    }

    private static void logging(FontInfo info) {
        String form = "\u767a\u8a00\u8868\u793a\u30d5\u30a9\u30f3\u30c8\u306b{0}\u304c\u9078\u629e\u3055\u308c\u307e\u3057\u305f\u3002";
        String logMsg = MessageFormat.format(form, info.getFont());
        LOGGER.info(logMsg);
        form = "\u767a\u8a00\u8868\u793a\u306e\u30a2\u30f3\u30c1\u30a8\u30a4\u30ea\u30a2\u30b9\u6307\u5b9a\u306b{0}\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f\u3002";
        logMsg = MessageFormat.format(form, info.isAntiAliased());
        LOGGER.info(logMsg);
        form = "\u767a\u8a00\u8868\u793a\u306eFractional\u6307\u5b9a\u306b{0}\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f\u3002";
        logMsg = MessageFormat.format(form, info.usesFractionalMetrics());
        LOGGER.info(logMsg);
    }

    private void design(Container content) {
        GridBagLayout layout = new GridBagLayout();
        content.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        content.add((Component)this.createFontPrefPanel(), constraints);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        content.add((Component)this.createPreviewPanel(), constraints);
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        content.add((Component)this.createFontDecodePanel(), constraints);
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.fill = 2;
        content.add((Component)this.maxBounds, constraints);
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        content.add((Component)this.resetDefault, constraints);
    }

    private JPanel createFontPrefPanel() {
        JPanel result = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        result.setLayout(layout);
        JPanel familyBorderPanel = new JPanel();
        TitledBorder familyBorder = BorderFactory.createTitledBorder("\u30d5\u30a9\u30f3\u30c8\u30d5\u30a1\u30df\u30ea\u9078\u629e");
        familyBorderPanel.setBorder(familyBorder);
        JPanel sizeBorderPanel = new JPanel();
        TitledBorder sizeBorder = BorderFactory.createTitledBorder("\u30dd\u30a4\u30f3\u30c8\u30b5\u30a4\u30ba\u6307\u5b9a");
        sizeBorderPanel.setBorder(sizeBorder);
        Border scrollBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        this.familySelector.setBorder(scrollBorder);
        JScrollPane familyScroller = new JScrollPane(this.familySelector);
        familyBorderPanel.setLayout(new BorderLayout());
        familyBorderPanel.add(familyScroller);
        constraints.insets = new Insets(0, 0, 0, 5);
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridheight = 0;
        constraints.fill = 1;
        result.add((Component)familyBorderPanel, constraints);
        sizeBorderPanel.setLayout(new BorderLayout());
        sizeBorderPanel.add(this.sizeSelector);
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.weightx = 0.0;
        constraints.gridheight = 1;
        constraints.fill = 2;
        constraints.anchor = 17;
        result.add((Component)sizeBorderPanel, constraints);
        constraints.anchor = 18;
        result.add((Component)this.isBoldCheck, constraints);
        result.add((Component)this.isItalicCheck, constraints);
        result.add((Component)this.useTextAntiAliaseCheck, constraints);
        result.add((Component)this.useFractionalCheck, constraints);
        return result;
    }

    private JPanel createPreviewPanel() {
        JPanel result = new JPanel();
        TitledBorder border = BorderFactory.createTitledBorder("\u30d5\u30a9\u30f3\u30c8\u30d7\u30ec\u30d3\u30e5\u30fc");
        result.setBorder(border);
        JScrollPane scroller = new JScrollPane(this.preview);
        scroller.getVerticalScrollBar().setUnitIncrement(8);
        result.setLayout(new BorderLayout());
        result.add(scroller);
        return result;
    }

    private JPanel createFontDecodePanel() {
        JPanel result = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        result.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel label = new JLabel("Font.deode() \u8b58\u5225\u540d:");
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        result.add((Component)label, constraints);
        constraints.weightx = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        result.add((Component)this.decodeName, constraints);
        return result;
    }

    public FontInfo getFontInfo() {
        return this.fontInfo;
    }

    public void setFontInfo(FontInfo newInfo) throws NullPointerException {
        if (newInfo == null) {
            throw new NullPointerException();
        }
        FontInfo old = this.fontInfo;
        if (old.equals(newInfo)) {
            return;
        }
        this.fontInfo = newInfo;
        this.updateControlls();
    }

    private void updateControlls() {
        this.maskListener = true;
        Font currentFont = this.getFontInfo().getFont();
        String defaultFamily = currentFont.getFamily();
        this.familySelector.setSelectedFamily(defaultFamily);
        Integer selectedInteger = currentFont.getSize();
        this.sizeSelector.setSelectedItem(selectedInteger);
        int sizeItems = this.sizeSelector.getItemCount();
        for (int index = 0; index < sizeItems; ++index) {
            Object sizeItem = this.sizeSelector.getItemAt(index);
            if (!sizeItem.equals(selectedInteger)) continue;
            this.sizeSelector.setSelectedIndex(index);
            break;
        }
        this.isBoldCheck.setSelected(currentFont.isBold());
        this.isItalicCheck.setSelected(currentFont.isItalic());
        this.useTextAntiAliaseCheck.setSelected(this.fontInfo.isAntiAliased());
        this.useFractionalCheck.setSelected(this.fontInfo.usesFractionalMetrics());
        this.decodeName.setText(this.getFontInfo().getFontDecodeName());
        this.decodeName.setCaretPosition(0);
        String form = "\u6700\u5927\u6587\u5b57\u5bf8\u6cd5 : {0} pixel\u5e45 \u00d7 {1} pixel\u9ad8";
        Rectangle rect = this.fontInfo.getMaxCharBounds();
        String boundInfo = MessageFormat.format(form, rect.width, rect.height);
        this.maxBounds.setText(boundInfo);
        this.preview.setFontInfo(this.fontInfo);
        this.maskListener = false;
    }

    @Override
    public void setVisible(boolean isVisible) {
        if (isVisible) {
            this.updateControlls();
        }
        this.lastFontInfo = this.fontInfo;
        super.setVisible(isVisible);
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        if (this.maskListener) {
            return;
        }
        if (event.getSource() != this.familySelector) {
            return;
        }
        if (event.getValueIsAdjusting()) {
            return;
        }
        String familyName = this.familySelector.getSelectedFamily();
        if (familyName == null) {
            return;
        }
        Font currentFont = this.getFontInfo().getFont();
        int style = currentFont.getStyle();
        int size = currentFont.getSize();
        Font newFont = new Font(familyName, style, size);
        FontInfo newInfo = this.fontInfo.deriveFont(newFont);
        this.setFontInfo(newInfo);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.maskListener) {
            return;
        }
        Object source = event.getSource();
        if (source == this.sizeSelector) {
            this.actionFontSizeSelected();
        } else if (source == this.resetDefault) {
            this.setFontInfo(FontInfo.DEFAULT_FONTINFO);
        }
    }

    private void actionFontSizeSelected() {
        Integer selectedInteger;
        Object selected = this.sizeSelector.getSelectedItem();
        if (selected == null) {
            return;
        }
        if (selected instanceof Integer) {
            selectedInteger = (Integer)selected;
        } else {
            try {
                selectedInteger = Integer.valueOf(selected.toString());
            }
            catch (NumberFormatException e) {
                selectedInteger = this.lastFontInfo.getFont().getSize();
            }
        }
        if (selectedInteger <= 0) {
            selectedInteger = this.lastFontInfo.getFont().getSize();
        }
        float fontSize = selectedInteger.floatValue();
        Font newFont = this.getFontInfo().getFont().deriveFont(fontSize);
        FontInfo newInfo = this.getFontInfo().deriveFont(newFont);
        this.setFontInfo(newInfo);
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        Font newFont;
        if (this.maskListener) {
            return;
        }
        Object source = event.getSource();
        if (source != this.isBoldCheck && source != this.isItalicCheck && source != this.useTextAntiAliaseCheck && source != this.useFractionalCheck) {
            return;
        }
        FontInfo newInfo = this.getFontInfo();
        int style = 0;
        if (this.isBoldCheck.isSelected()) {
            style |= 1;
        }
        if (this.isItalicCheck.isSelected()) {
            style |= 2;
        }
        if ((newFont = newInfo.getFont()).getStyle() != style) {
            newFont = newFont.deriveFont(style);
            newInfo = newInfo.deriveFont(newFont);
        }
        boolean isAntiAliases = this.useTextAntiAliaseCheck.isSelected();
        boolean useFractional = this.useFractionalCheck.isSelected();
        newInfo = newInfo.deriveRenderContext(isAntiAliases, useFractional);
        this.setFontInfo(newInfo);
    }

    static {
        LOGGER = Logger.getAnonymousLogger();
        PREVIEW_CONTENT = ResourceManager.getTextFile("resources/font/preview.txt");
    }
}

