/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.glyph;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class FontEnv {
    public static final FontEnv DEFAULT;
    private static final String FAMILY_DIALOG = "Dialog";
    private static final String[] INIT_FAMILY_NAMES;
    private static final String JPCHECK_CODE = "\u3042\u51dc\u7199\u5ce0\u3091\u30a2\uff71\u30f4\u30f0\u253c\u0416\u03a99A";
    private static final Locale LOCALE_ROOT;
    private static final int POOL_SZ = 2;
    private static final int STRIDE = 15;
    private final String proveChars;
    private final List<String> fontFamilyList;
    private final Future<List<String>> listLoadFuture;
    private final Future<String> fontSelectFuture;

    public FontEnv(String proveChars, List<String> fontFamilyList) throws NullPointerException {
        if (proveChars == null || fontFamilyList == null) {
            throw new NullPointerException();
        }
        this.proveChars = proveChars;
        this.fontFamilyList = fontFamilyList;
        ExecutorService service = Executors.newFixedThreadPool(2);
        FontListLoader loadTask = new FontListLoader();
        this.listLoadFuture = service.submit(loadTask);
        FontSelector selectTask = new FontSelector();
        this.fontSelectFuture = service.submit(selectTask);
        service.shutdown();
    }

    public FontEnv(String proveChars, String ... fontFamilyList) throws NullPointerException {
        this(proveChars, Arrays.asList(fontFamilyList));
    }

    protected static void yield() {
        Thread.yield();
    }

    protected static Collection<String> createFontSet(String checkChars) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] allFonts = ge.getAllFonts();
        FontEnv.yield();
        HashSet<String> result = new HashSet<String>();
        int ct = 0;
        for (Font font : allFonts) {
            String familyName;
            if (++ct % 15 == 0) {
                FontEnv.yield();
            }
            if (result.contains(familyName = font.getFamily()) || font.canDisplayUpTo(checkChars) >= 0) continue;
            result.add(familyName);
        }
        return result;
    }

    protected static boolean isValidFamilyName(String familyName) {
        int style = 0;
        int size = 1;
        Font dummyFont = new Font(familyName, style, size);
        String dummyFamilyName = dummyFont.getFamily(LOCALE_ROOT);
        if (dummyFamilyName.equals(familyName)) {
            return true;
        }
        String dummyLocalFamilyName = dummyFont.getFamily();
        return dummyLocalFamilyName.equals(familyName);
    }

    protected static String availableFontFamily(Iterable<String> fontList) {
        String defaultFamilyName = FAMILY_DIALOG;
        for (String familyName : fontList) {
            if (!FontEnv.isValidFamilyName(familyName)) continue;
            defaultFamilyName = familyName;
            break;
        }
        return defaultFamilyName;
    }

    public List<String> getFontFamilyList() throws IllegalStateException {
        List<String> result;
        try {
            result = this.listLoadFuture.get();
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    public String selectFontFamily() throws IllegalStateException {
        String result;
        try {
            result = this.fontSelectFuture.get();
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    static {
        INIT_FAMILY_NAMES = new String[]{"Hiragino Kaku Gothic Pro", "Hiragino Kaku Gothic Std", "Osaka", "MS PGothic", "MS Gothic", "IPAMonaPGothic"};
        LOCALE_ROOT = new Locale("", "", "");
        DEFAULT = new FontEnv(JPCHECK_CODE, INIT_FAMILY_NAMES);
    }

    protected final class FontSelector
    implements Callable<String> {
        protected FontSelector() {
        }

        @Override
        public String call() {
            String result = FontEnv.availableFontFamily(FontEnv.this.fontFamilyList);
            return result;
        }
    }

    protected final class FontListLoader
    implements Callable<List<String>> {
        protected FontListLoader() {
        }

        @Override
        public List<String> call() {
            Collection<String> fontSet = FontEnv.createFontSet(FontEnv.this.proveChars);
            FontEnv.yield();
            List<String> result = new ArrayList<String>(fontSet);
            Collections.sort(result);
            FontEnv.yield();
            result = Collections.unmodifiableList(result);
            return result;
        }
    }
}

