/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.glyph;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.DateFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import jp.sfjp.jindolf.data.Anchor;
import jp.sfjp.jindolf.data.Avatar;
import jp.sfjp.jindolf.data.DialogPref;
import jp.sfjp.jindolf.data.Period;
import jp.sfjp.jindolf.data.Talk;
import jp.sfjp.jindolf.data.Village;
import jp.sfjp.jindolf.glyph.AbstractTextRow;
import jp.sfjp.jindolf.glyph.AnchorDraw;
import jp.sfjp.jindolf.glyph.FontInfo;
import jp.sfjp.jindolf.glyph.GlyphDraw;
import jp.sfjp.jindolf.util.GUIUtils;
import jp.sourceforge.jindolf.corelib.TalkType;

public class TalkDraw
extends AbstractTextRow {
    public static final Color COLOR_PUBLIC = new Color(0xFFFFFF);
    public static final Color COLOR_WOLFONLY = new Color(0xFF7777);
    public static final Color COLOR_PRIVATE = new Color(0x939393);
    public static final Color COLOR_GRAVE = new Color(10467279);
    private static final Color COLOR_CAPTIONFG = Color.WHITE;
    private static final Color COLOR_DIALOGFG = Color.BLACK;
    private static final Color COLOR_SIMPLEFG = Color.BLACK;
    private static final Color COLOR_SIMPLEBG = Color.WHITE;
    private static final int BALOONTIP_WIDTH = 16;
    private static final int BALOONTIP_HEIGHT = 8;
    private static final int UPPER_MARGIN = 5;
    private static final int UNDER_MARGIN = 10;
    private static final int OFFSET_ANCHOR = 36;
    private static final int CAPTION_DIALOG_GAP = 3;
    private static final Color COLOR_TRANS = new Color(0, 0, 0, 0);
    private static final int BALOON_R = 10;
    private static final BufferedImage BALOON_PUBLIC = TalkDraw.createWedgeImage(COLOR_PUBLIC);
    private static final BufferedImage BALOON_WOLFONLY = TalkDraw.createBubbleImage(COLOR_WOLFONLY);
    private static final BufferedImage BALOON_GRAVE;
    private static final BufferedImage BALOON_PRIVATE;
    private static final BufferedImage SQUARE_PUBLIC;
    private static final BufferedImage SQUARE_WOLFONLY;
    private static final BufferedImage SQUARE_GRAVE;
    private static final BufferedImage SQUARE_PRIVATE;
    private static final float ANCHOR_FONT_RATIO = 0.9f;
    private final Talk talk;
    private Anchor showingAnchor;
    private final GlyphDraw caption;
    private BufferedImage faceImage;
    private final GlyphDraw dialog;
    private final List<AnchorDraw> anchorTalks = new LinkedList<AnchorDraw>();
    private Point imageOrigin;
    private Point dialogOrigin;
    private Point tipOrigin;
    private int baloonWidth;
    private int baloonHeight;
    private FontInfo anchorFontInfo;
    private DialogPref dialogPref;

    public TalkDraw(Talk talk) {
        this(talk, new DialogPref(), FontInfo.DEFAULT_FONTINFO);
    }

    public TalkDraw(Talk talk, DialogPref dialogPref, FontInfo fontInfo) {
        super(fontInfo);
        this.talk = talk;
        this.anchorFontInfo = TalkDraw.deriveAnchorFontInfo(this.fontInfo);
        this.dialogPref = dialogPref;
        this.faceImage = this.getFaceImage();
        this.caption = new GlyphDraw(this.getCaptionString(), this.fontInfo);
        this.dialog = new GlyphDraw(this.talk.getDialog(), this.fontInfo);
        this.setColorDesign();
        Period period = this.talk.getPeriod();
        List<Anchor> anchorList = Anchor.getAnchorList(this.talk.getDialog(), period.getDay());
        this.dialog.setAnchorSet(anchorList);
    }

    private static BufferedImage createWedgeImage(Color color) {
        BufferedImage image = new BufferedImage(16, 8, 2);
        Graphics2D g2 = image.createGraphics();
        RenderingHints renderHints = GUIUtils.getQualityHints();
        g2.addRenderingHints(renderHints);
        g2.setColor(COLOR_TRANS);
        g2.fillRect(0, 0, 16, 8);
        g2.setColor(color);
        Polygon poly = new Polygon();
        poly.addPoint(8, 8);
        poly.addPoint(16, 8);
        poly.addPoint(16, 0);
        g2.fillPolygon(poly);
        return image;
    }

    private static BufferedImage createBubbleImage(Color color) {
        BufferedImage image = new BufferedImage(16, 8, 2);
        Graphics2D g2 = image.createGraphics();
        RenderingHints renderHints = GUIUtils.getQualityHints();
        g2.addRenderingHints(renderHints);
        g2.setColor(COLOR_TRANS);
        g2.fillRect(0, 0, 16, 8);
        g2.setColor(color);
        g2.fillOval(2, 4, 4, 4);
        g2.fillOval(8, 2, 6, 6);
        return image;
    }

    private static BufferedImage createSquareImage(Color color) {
        BufferedImage image = new BufferedImage(16, 8, 2);
        Graphics2D g2 = image.createGraphics();
        RenderingHints renderHints = GUIUtils.getQualityHints();
        g2.addRenderingHints(renderHints);
        g2.setColor(color);
        g2.fillRect(0, 0, 16, 8);
        return image;
    }

    private static Font deriveAnchorFont(Font font) {
        float fontSize = font.getSize2D();
        float newSize = fontSize * 0.9f;
        return font.deriveFont(newSize);
    }

    private static FontInfo deriveAnchorFontInfo(FontInfo info) {
        Font newFont = TalkDraw.deriveAnchorFont(info.getFont());
        FontInfo result = info.deriveFont(newFont);
        return result;
    }

    public static Color getTypedColor(TalkType type) {
        Color result;
        switch (type) {
            case PUBLIC: {
                result = COLOR_PUBLIC;
                break;
            }
            case WOLFONLY: {
                result = COLOR_WOLFONLY;
                break;
            }
            case GRAVE: {
                result = COLOR_GRAVE;
                break;
            }
            case PRIVATE: {
                result = COLOR_PRIVATE;
                break;
            }
            default: {
                return null;
            }
        }
        return result;
    }

    private void setColorDesign() {
        if (this.dialogPref.isSimpleMode()) {
            this.caption.setColor(COLOR_SIMPLEFG);
        } else {
            this.caption.setColor(COLOR_CAPTIONFG);
        }
        this.dialog.setColor(COLOR_DIALOGFG);
    }

    public Talk getTalk() {
        return this.talk;
    }

    private BufferedImage getFaceImage() {
        Village village = this.talk.getPeriod().getVillage();
        Avatar avatar = this.talk.getAvatar();
        boolean useBodyImage = this.dialogPref.useBodyImage();
        boolean useMonoImage = this.dialogPref.useMonoImage();
        BufferedImage image = this.talk.isGrave() ? (useMonoImage ? (useBodyImage ? village.getAvatarBodyMonoImage(avatar) : village.getAvatarFaceMonoImage(avatar)) : (useBodyImage ? village.getGraveBodyImage() : village.getGraveImage())) : (useBodyImage ? village.getAvatarBodyImage(avatar) : village.getAvatarFaceImage(avatar));
        return image;
    }

    private CharSequence getCaptionString() {
        int charNum;
        StringBuilder result = new StringBuilder();
        Avatar avatar = this.talk.getAvatar();
        if (this.talk.hasTalkNo()) {
            result.append(this.talk.getAnchorNotation_G()).append(' ');
        }
        result.append(avatar.getFullName()).append(' ');
        result.append(this.talk.getAnchorNotation());
        result.append('\n');
        DateFormat dform = DateFormat.getDateTimeInstance(2, 2);
        long epoch = this.talk.getTimeFromID();
        String decoded = dform.format(epoch);
        result.append(decoded);
        int count = this.talk.getTalkCount();
        if (count > 0) {
            TalkType type = this.talk.getTalkType();
            result.append(" (").append(Talk.encodeColorName(type));
            result.append('#').append(count).append(')');
        }
        if ((charNum = this.talk.getTotalChars()) > 0) {
            result.append(' ').append(charNum).append('\u5b57');
        }
        return result;
    }

    protected Color getTalkBgColor() {
        if (this.dialogPref.isSimpleMode()) {
            return COLOR_SIMPLEBG;
        }
        TalkType type = this.talk.getTalkType();
        Color result = TalkDraw.getTypedColor(type);
        return result;
    }

    @Override
    public Rectangle recalcBounds() {
        int tipWidth;
        int minWidth;
        int newWidth = this.getWidth();
        int imageWidth = 0;
        int imageHeight = 0;
        if (!this.dialogPref.isSimpleMode()) {
            imageWidth = this.faceImage.getWidth(null);
            imageHeight = this.faceImage.getHeight(null);
        }
        int modWidth = newWidth < (minWidth = imageWidth + (tipWidth = BALOON_WOLFONLY.getWidth()) + 20) ? minWidth : newWidth;
        this.caption.setWidth(modWidth);
        int captionWidth = this.caption.getWidth();
        int captionHeight = this.caption.getHeight() + 3;
        this.dialog.setWidth(modWidth - minWidth);
        int dialogWidth = this.dialog.getWidth();
        int dialogHeight = this.dialog.getHeight();
        this.baloonWidth = this.dialogPref.alignBaloonWidth() ? modWidth - minWidth + 20 : dialogWidth + 20;
        this.baloonHeight = dialogHeight + 20;
        int imageAndDialogWidth = imageWidth + tipWidth + this.baloonWidth;
        int totalWidth = Math.max(captionWidth, imageAndDialogWidth);
        int totalHeight = captionHeight;
        totalHeight += Math.max(imageHeight, this.baloonHeight);
        int imageYpos = captionHeight;
        int dialogYpos = captionHeight;
        int tipYpos = captionHeight;
        if (imageHeight < this.baloonHeight) {
            imageYpos += (this.baloonHeight - imageHeight) / 2;
            tipYpos += (this.baloonHeight - BALOON_WOLFONLY.getHeight()) / 2;
            dialogYpos += 10;
        } else {
            dialogYpos += (imageHeight - this.baloonHeight) / 2 + 10;
            tipYpos += (imageHeight - BALOON_WOLFONLY.getHeight()) / 2;
        }
        this.imageOrigin = new Point(0, imageYpos);
        this.caption.setPos(this.bounds.x + 0, this.bounds.y + 0);
        this.dialogOrigin = new Point(imageWidth + tipWidth + 10, dialogYpos);
        this.dialog.setPos(this.bounds.x + imageWidth + tipWidth + 10, this.bounds.y + dialogYpos);
        this.tipOrigin = new Point(imageWidth, tipYpos);
        for (AnchorDraw anchorDraw : this.anchorTalks) {
            anchorDraw.setWidth(modWidth - 36);
            totalHeight += anchorDraw.getHeight();
        }
        this.bounds.width = this.dialogPref.isSimpleMode() || this.dialogPref.alignBaloonWidth() ? newWidth : totalWidth;
        this.bounds.height = 5 + totalHeight + 10;
        return this.bounds;
    }

    @Override
    public void setPos(int xPos, int yPos) {
        super.setPos(xPos, yPos);
        this.caption.setPos(this.bounds.x, this.bounds.y + 5);
        this.dialog.setPos(this.bounds.x + this.dialogOrigin.x, this.bounds.y + this.dialogOrigin.y + 5);
    }

    private BufferedImage getTipImage() {
        BufferedImage tip;
        TalkType type = this.talk.getTalkType();
        if (this.dialogPref.isSimpleMode()) {
            switch (type) {
                case PUBLIC: {
                    tip = SQUARE_PUBLIC;
                    break;
                }
                case WOLFONLY: {
                    tip = SQUARE_WOLFONLY;
                    break;
                }
                case GRAVE: {
                    tip = SQUARE_GRAVE;
                    break;
                }
                case PRIVATE: {
                    tip = SQUARE_PRIVATE;
                    break;
                }
                default: {
                    assert (false);
                    tip = null;
                    break;
                }
            }
        } else {
            switch (type) {
                case PUBLIC: {
                    tip = BALOON_PUBLIC;
                    break;
                }
                case WOLFONLY: {
                    tip = BALOON_WOLFONLY;
                    break;
                }
                case GRAVE: {
                    tip = BALOON_GRAVE;
                    break;
                }
                case PRIVATE: {
                    tip = BALOON_PRIVATE;
                    break;
                }
                default: {
                    assert (false);
                    tip = null;
                }
            }
        }
        return tip;
    }

    @Override
    public void paint(Graphics2D g) {
        int xPos = this.bounds.x;
        int yPos = this.bounds.y + 5;
        this.caption.paint(g);
        if (this.dialogPref.isSimpleMode()) {
            g.drawLine(xPos, this.bounds.y, xPos + this.bounds.width, this.bounds.y);
        } else {
            g.drawImage((Image)this.faceImage, xPos + this.imageOrigin.x, yPos + this.imageOrigin.y, null);
        }
        BufferedImage tip = this.getTipImage();
        g.drawImage((Image)tip, xPos + this.tipOrigin.x, yPos + this.tipOrigin.y, null);
        g.setColor(this.getTalkBgColor());
        g.fillRoundRect(xPos + this.dialogOrigin.x - 10, yPos + this.dialogOrigin.y - 10, this.baloonWidth, this.baloonHeight, 10, 10);
        this.dialog.paint(g);
        int anchorX = xPos + 36;
        int anchorY = yPos + this.dialogOrigin.y + this.baloonHeight;
        for (AnchorDraw anchorDraw : this.anchorTalks) {
            anchorDraw.setPos(anchorX, anchorY);
            anchorDraw.paint(g);
            anchorY += anchorDraw.getHeight();
        }
    }

    @Override
    public void setFontInfo(FontInfo fontInfo) {
        super.setFontInfo(fontInfo);
        this.anchorFontInfo = TalkDraw.deriveAnchorFontInfo(this.fontInfo);
        this.caption.setFontInfo(this.fontInfo);
        this.dialog.setFontInfo(this.fontInfo);
        for (AnchorDraw anchorDraw : this.anchorTalks) {
            anchorDraw.setFontInfo(this.anchorFontInfo);
        }
        this.recalcBounds();
    }

    public void setDialogPref(DialogPref pref) {
        this.dialogPref = pref;
        this.faceImage = this.getFaceImage();
        for (AnchorDraw anchorDraw : this.anchorTalks) {
            anchorDraw.setDialogPref(this.dialogPref);
        }
        this.setColorDesign();
        this.recalcBounds();
    }

    @Override
    public void drag(Point from, Point to) {
        this.caption.drag(from, to);
        this.dialog.drag(from, to);
        for (AnchorDraw anchorDraw : this.anchorTalks) {
            anchorDraw.drag(from, to);
        }
    }

    @Override
    public Appendable appendSelected(Appendable appendable) throws IOException {
        this.caption.appendSelected(appendable);
        this.dialog.appendSelected(appendable);
        for (AnchorDraw anchorDraw : this.anchorTalks) {
            anchorDraw.appendSelected(appendable);
        }
        return appendable;
    }

    @Override
    public void clearSelect() {
        this.caption.clearSelect();
        this.dialog.clearSelect();
        for (AnchorDraw anchorDraw : this.anchorTalks) {
            anchorDraw.clearSelect();
        }
    }

    public Anchor getAnchor(Point pt) {
        Anchor result = this.dialog.getAnchor(pt);
        return result;
    }

    public void showAnchorTalks(Anchor anchor, List<Talk> talkList) {
        if (anchor == null || this.showingAnchor == anchor) {
            this.showingAnchor = null;
            this.anchorTalks.clear();
            this.recalcBounds();
            return;
        }
        this.showingAnchor = anchor;
        this.anchorTalks.clear();
        for (Talk anchorTalk : talkList) {
            AnchorDraw anchorDraw = new AnchorDraw(anchorTalk, this.dialogPref, this.anchorFontInfo);
            this.anchorTalks.add(anchorDraw);
        }
        this.recalcBounds();
    }

    public int getRegexMatchIndex(Point pt) {
        int index = this.dialog.getRegexMatchIndex(pt);
        return index;
    }

    public int setRegex(Pattern searchRegex) {
        int total = 0;
        return total += this.dialog.setRegex(searchRegex);
    }

    public int getHotTargetIndex() {
        return this.dialog.getHotTargetIndex();
    }

    public void setHotTargetIndex(int index) {
        this.dialog.setHotTargetIndex(index);
    }

    public int getRegexMatches() {
        return this.dialog.getRegexMatches();
    }

    public void clearHotTarget() {
        this.dialog.clearHotTarget();
    }

    public Rectangle getHotTargetRectangle() {
        return this.dialog.getHotTargetRectangle();
    }

    static {
        BALOON_PRIVATE = TalkDraw.createBubbleImage(COLOR_PRIVATE);
        BALOON_GRAVE = TalkDraw.createBubbleImage(COLOR_GRAVE);
        SQUARE_PUBLIC = TalkDraw.createSquareImage(COLOR_PUBLIC);
        SQUARE_WOLFONLY = TalkDraw.createSquareImage(COLOR_WOLFONLY);
        SQUARE_GRAVE = TalkDraw.createSquareImage(COLOR_GRAVE);
        SQUARE_PRIVATE = TalkDraw.createSquareImage(COLOR_PRIVATE);
    }
}

