/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.log;

import java.io.PrintStream;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Logger;
import java.util.logging.LoggingPermission;
import jp.sfjp.jindolf.log.MomentaryHandler;

public final class LogUtils {
    public static final LoggingPermission PERM_LOGCTL = new LoggingPermission("control", null);
    private static final PrintStream STDERR = System.err;
    private static final String ERRMSG_LOGSECURITY = "\u30bb\u30ad\u30e5\u30ea\u30c6\u30a3\u8a2d\u5b9a\u306b\u3088\u308a\u3001\u30ed\u30b0\u8a2d\u5b9a\u3092\u5909\u66f4\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f";

    private LogUtils() {
        assert (false);
    }

    public static boolean hasLoggingPermission() {
        SecurityManager manager = System.getSecurityManager();
        boolean result = LogUtils.hasLoggingPermission(manager);
        return result;
    }

    public static boolean hasLoggingPermission(SecurityManager manager) {
        if (manager == null) {
            return true;
        }
        try {
            manager.checkPermission(PERM_LOGCTL);
        }
        catch (SecurityException e) {
            return false;
        }
        return true;
    }

    public static Logger getRootLogger() {
        Logger rootLogger = Logger.getLogger("");
        return rootLogger;
    }

    public static void initRootLogger(boolean useConsoleLog) {
        Handler[] oldHandlers;
        if (!LogUtils.hasLoggingPermission()) {
            STDERR.println(ERRMSG_LOGSECURITY);
            return;
        }
        Logger rootLogger = LogUtils.getRootLogger();
        for (Handler handler : oldHandlers = rootLogger.getHandlers()) {
            rootLogger.removeHandler(handler);
        }
        MomentaryHandler momentaryHandler = new MomentaryHandler();
        rootLogger.addHandler(momentaryHandler);
        if (useConsoleLog) {
            ConsoleHandler consoleHandler = new ConsoleHandler();
            rootLogger.addHandler(consoleHandler);
        }
    }

    public static void switchHandler(Handler newHandler) {
        if (!LogUtils.hasLoggingPermission()) {
            return;
        }
        Logger logger = LogUtils.getRootLogger();
        List<MomentaryHandler> momentaryHandlers = MomentaryHandler.getMomentaryHandlers(logger);
        MomentaryHandler.removeMomentaryHandlers(logger);
        logger.addHandler(newHandler);
        for (MomentaryHandler momentaryHandler : momentaryHandlers) {
            momentaryHandler.transfer(newHandler);
            momentaryHandler.close();
        }
    }
}

