/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.net;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.logging.Logger;
import jp.sfjp.jindolf.net.HttpUtils;

public class TallyOutputStream
extends OutputStream {
    private static final int BUFSIZE = 512;
    private static final Logger LOGGER = Logger.getAnonymousLogger();
    private final HttpURLConnection conn;
    private final OutputStream out;
    private long counter;
    private long nanoLap;

    protected TallyOutputStream(HttpURLConnection conn) throws IOException {
        this.conn = conn;
        this.counter = 0L;
        this.nanoLap = 0L;
        OutputStream os = this.conn.getOutputStream();
        this.out = os = new BufferedOutputStream(os, 512);
    }

    public static OutputStream getOutputStream(HttpURLConnection conn) throws IOException {
        return new TallyOutputStream(conn);
    }

    protected long getCount() {
        return this.counter;
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        long size = this.getCount();
        long span = System.nanoTime() - this.nanoLap;
        String message = HttpUtils.formatHttpStat(this.conn, size, span);
        LOGGER.info(message);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.counter <= 0L) {
            this.nanoLap = System.nanoTime();
        }
        this.out.write(b);
        this.counter += (long)b.length;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.counter <= 0L) {
            this.nanoLap = System.nanoTime();
        }
        this.out.write(b, off, len);
        this.counter += (long)len;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.counter <= 0L) {
            this.nanoLap = System.nanoTime();
        }
        this.out.write(b);
        ++this.counter;
    }
}

