/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.MatteBorder;
import jp.sfjp.jindolf.data.DialogPref;
import jp.sfjp.jindolf.data.Period;
import jp.sfjp.jindolf.data.Talk;
import jp.sfjp.jindolf.data.Topic;
import jp.sfjp.jindolf.data.Village;
import jp.sfjp.jindolf.glyph.Discussion;
import jp.sfjp.jindolf.glyph.FontInfo;
import jp.sfjp.jindolf.glyph.TalkDraw;
import jp.sourceforge.jindolf.corelib.TalkType;

public class PeriodView
extends JPanel
implements ItemListener {
    private static final Color COLOR_SELECT = new Color(0xFFFF80);
    private static final Color COLOR_NORMALBG = Color.BLACK;
    private static final Color COLOR_SIMPLEBG = Color.WHITE;
    private Period period;
    private final Discussion discussion;
    private final JScrollPane scroller = new JScrollPane();
    private final JLabel caption = new JLabel();
    private final JLabel limit = new JLabel();
    private final JComboBox talkSelector = new JComboBox();
    private final DefaultComboBoxModel model = new DefaultComboBoxModel();
    private DialogPref dialogPref = new DialogPref();

    public PeriodView(Period period) {
        this.period = period;
        this.talkSelector.setEditable(false);
        this.talkSelector.setMaximumRowCount(20);
        this.talkSelector.setModel(this.model);
        this.talkSelector.setRenderer(new AnchorRenderer());
        this.talkSelector.addItemListener(this);
        this.discussion = new Discussion();
        MatteBorder border = BorderFactory.createMatteBorder(15, 15, 15, 15, Color.BLACK);
        this.discussion.setBorder(border);
        this.discussion.setPeriod(this.period);
        JViewport viewPort = this.scroller.getViewport();
        viewPort.setBackground(Color.BLACK);
        viewPort.setView(this.discussion);
        this.scroller.setHorizontalScrollBarPolicy(31);
        this.scroller.setVerticalScrollBarPolicy(22);
        this.design();
        this.setColorDesign();
    }

    private void design() {
        JPanel topPanel = new JPanel();
        LayoutManager2 layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        topPanel.setLayout(layout);
        constraints.insets = new Insets(1, 3, 1, 3);
        constraints.weightx = 1.0;
        constraints.anchor = 17;
        constraints.fill = 0;
        topPanel.add((Component)this.caption, constraints);
        constraints.weightx = 0.0;
        constraints.anchor = 13;
        topPanel.add((Component)this.limit, constraints);
        constraints.weightx = 0.0;
        topPanel.add((Component)this.talkSelector, constraints);
        layout = new BorderLayout();
        this.setLayout(layout);
        this.add((Component)topPanel, "North");
        this.add((Component)this.scroller, "Center");
    }

    private void setColorDesign() {
        Color bgColor = this.dialogPref.isSimpleMode() ? COLOR_SIMPLEBG : COLOR_NORMALBG;
        JViewport viewPort = this.scroller.getViewport();
        viewPort.setBackground(bgColor);
        MatteBorder border = BorderFactory.createMatteBorder(15, 15, 15, 15, bgColor);
        this.discussion.setBorder(border);
        this.repaint();
    }

    public void setPeriod(Period period) {
        this.discussion.setPeriod(period);
        this.period = period;
        this.updateTopPanel();
    }

    public Period getPeriod() {
        return this.discussion.getPeriod();
    }

    private void updateTopPanel() {
        if (this.period == null) {
            this.caption.setText("");
            this.limit.setText("");
            this.model.removeAllElements();
            return;
        }
        Village village = this.period.getVillage();
        String villageName = village.getVillageName();
        String dayCaption = this.period.getCaption();
        String limitCaption = this.period.getLimit();
        String account = this.period.getLoginName();
        String loginout = this.period.isFullOpen() ? "" : (account != null ? " (\u30ed\u30b0\u30a4\u30f3\u4e2d)" : " (\u30ed\u30b0\u30a2\u30a6\u30c8\u4e2d)");
        String info = villageName + "\u6751 " + dayCaption + loginout;
        this.caption.setText(info);
        this.limit.setText("\u66f4\u65b0\u6642\u523b " + limitCaption);
        this.model.removeAllElements();
        this.model.addElement(" ");
        List<Topic> topicList = this.period.getTopicList();
        for (Topic topic : topicList) {
            Talk talk;
            if (!(topic instanceof Talk) || (talk = (Talk)topic).getTalkCount() <= 0) continue;
            this.model.addElement(talk);
        }
    }

    public void showTopics() {
        Period newPeriod = this.discussion.getPeriod();
        this.setPeriod(newPeriod);
    }

    public void setFontInfo(FontInfo fontInfo) {
        this.discussion.setFontInfo(fontInfo);
        this.revalidate();
        this.repaint();
    }

    public void setDialogPref(DialogPref pref) {
        this.dialogPref = pref;
        this.discussion.setDialogPref(this.dialogPref);
        this.setColorDesign();
        this.revalidate();
        this.repaint();
    }

    public Discussion getDiscussion() {
        return this.discussion;
    }

    public int getVerticalPosition() {
        JScrollBar vt = this.scroller.getVerticalScrollBar();
        int pos = vt.getValue();
        return pos;
    }

    public void setVerticalPosition(int pos) {
        JScrollBar vt = this.scroller.getVerticalScrollBar();
        vt.setValue(pos);
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getStateChange() != 1) {
            return;
        }
        Object selected = this.talkSelector.getSelectedItem();
        if (!(selected instanceof Talk)) {
            return;
        }
        Talk talk = (Talk)selected;
        this.scrollToTalk(talk);
    }

    public void scrollToTalk(Talk talk) {
        if (talk == null) {
            return;
        }
        if (talk.getPeriod() != this.period) {
            return;
        }
        Rectangle rect = this.discussion.getTalkBounds(talk);
        if (rect == null) {
            return;
        }
        Rectangle showRect = new Rectangle(rect);
        showRect.y -= 15;
        showRect.height = this.scroller.getHeight();
        this.discussion.scrollRectToVisible(showRect);
    }

    private static class AnchorRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Talk talk = null;
            Object newValue = value;
            if (value instanceof Talk) {
                talk = (Talk)value;
                newValue = talk.getAnchorNotation() + ' ' + talk.getAvatar().getName();
            }
            Component superResult = super.getListCellRendererComponent((JList<?>)list, newValue, index, isSelected, cellHasFocus);
            if (talk != null) {
                Color bgColor = null;
                if (isSelected) {
                    bgColor = COLOR_SELECT;
                } else {
                    TalkType type = talk.getTalkType();
                    bgColor = TalkDraw.getTypedColor(type);
                }
                superResult.setForeground(Color.BLACK);
                superResult.setBackground(bgColor);
            }
            return superResult;
        }
    }
}

