/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.parser;

import jp.sourceforge.jindolf.parser.ContentBuilder;
import jp.sourceforge.jindolf.parser.DecodeException;

public class ContentBuilderUCS2
extends ContentBuilder {
    private static final int DEF_BUF_SZ = 128;

    public ContentBuilderUCS2() {
        this(128);
    }

    public ContentBuilderUCS2(int capacity) throws NegativeArraySizeException {
        super(capacity);
        this.initImpl();
    }

    public static byte[] charToUTF16(char ch) {
        byte[] result = new byte[]{(byte)(ch >> 8), (byte)(ch & 0xFF)};
        return result;
    }

    private void initImpl() {
        this.getContent().init();
    }

    protected void init() {
        this.initImpl();
    }

    public void charContent(CharSequence seq) throws DecodeException {
        this.flushError();
        int length = seq.length();
        int startPos = 0;
        for (int pos = 0; pos < length; ++pos) {
            byte[] barr;
            char ch = seq.charAt(pos);
            if (!Character.isHighSurrogate(ch) && !Character.isLowSurrogate(ch)) continue;
            if (startPos < pos) {
                CharSequence chopped = seq.subSequence(startPos, pos);
                this.getContent().append(chopped);
                startPos = pos + 1;
            }
            for (byte bval : barr = ContentBuilderUCS2.charToUTF16(ch)) {
                this.getContent().addDecodeError(bval);
            }
        }
        if (startPos < length) {
            CharSequence chopped = seq.subSequence(startPos, length);
            this.getContent().append(chopped);
        }
    }

    public void decodingError(byte[] errorArray, int offset, int length) throws DecodeException {
        int limit = offset + length;
        for (int bpos = offset; bpos < limit; ++bpos) {
            byte bval = errorArray[bpos];
            this.getContent().addDecodeError(bval);
        }
    }
}

