/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import jp.sourceforge.jindolf.parser.DecodeErrorInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecodedContent
implements CharSequence,
Appendable {
    public static final char ALTCHAR = '?';
    private static final String NULLTEXT = "null";
    private static final List<DecodeErrorInfo> EMPTY_LIST = Collections.emptyList();
    private static final int BSEARCH_THRESHOLD = 16;
    private final StringBuilder rawContent = new StringBuilder();
    private List<DecodeErrorInfo> decodeError;

    public DecodedContent() {
        this("");
    }

    public DecodedContent(CharSequence seq) throws NullPointerException {
        if (seq == null) {
            throw new NullPointerException();
        }
        this.initImpl();
        this.rawContent.append(seq);
    }

    public DecodedContent(int capacity) throws NegativeArraySizeException {
        if (capacity < 0) {
            throw new NegativeArraySizeException();
        }
        this.initImpl();
        this.rawContent.ensureCapacity(capacity);
    }

    protected static int lsearchErrorIndex(List<DecodeErrorInfo> errList, int startPos) {
        DecodeErrorInfo einfo;
        int errPos;
        int idx;
        int errSize = errList.size();
        for (idx = 0; idx < errSize && startPos > (errPos = (einfo = errList.get(idx)).getCharPosition()); ++idx) {
        }
        return idx;
    }

    protected static int bsearchErrorIndex(List<DecodeErrorInfo> errList, int startPos) {
        int floor = 0;
        int roof = errList.size() - 1;
        while (floor <= roof) {
            int midpoint = (floor + roof) / 2;
            DecodeErrorInfo einfo = errList.get(midpoint);
            int cmp = einfo.getCharPosition() - startPos;
            if (cmp == 0) {
                return midpoint;
            }
            if (cmp < 0) {
                floor = midpoint + 1;
                continue;
            }
            if (cmp <= 0) continue;
            roof = midpoint - 1;
        }
        return floor;
    }

    protected static int searchErrorIndex(List<DecodeErrorInfo> errList, int startPos) {
        int errSize = errList.size();
        int result = errSize < 16 ? DecodedContent.lsearchErrorIndex(errList, startPos) : DecodedContent.bsearchErrorIndex(errList, startPos);
        return result;
    }

    protected static List<DecodeErrorInfo> appendGappedErrorInfo(DecodedContent sourceContent, int startPos, int endPos, List<DecodeErrorInfo> targetError, int gap) {
        List<DecodeErrorInfo> sourceError = sourceContent.decodeError;
        List<DecodeErrorInfo> result = targetError;
        int startErrorIdx = DecodedContent.searchErrorIndex(sourceError, startPos);
        int endErrorIdx = sourceError.size() - 1;
        assert (endErrorIdx >= 0);
        for (int index = startErrorIdx; index <= endErrorIdx; ++index) {
            DecodeErrorInfo einfo = sourceError.get(index);
            int pos = einfo.getCharPosition();
            if (pos < startPos) continue;
            if (pos >= endPos) break;
            DecodeErrorInfo newInfo = einfo.createGappedClone(gap);
            if (result == null) {
                result = DecodedContent.createErrorList();
            }
            result.add(newInfo);
        }
        return result;
    }

    private static List<DecodeErrorInfo> createErrorList() {
        ArrayList<DecodeErrorInfo> result = new ArrayList<DecodeErrorInfo>();
        return result;
    }

    private void initImpl() {
        this.rawContent.setLength(0);
        if (this.decodeError != null) {
            this.decodeError.clear();
        }
    }

    public void ensureCapacity(int minimumCapacity) {
        this.rawContent.ensureCapacity(minimumCapacity);
    }

    public void init() {
        this.initImpl();
    }

    public boolean hasDecodeError() {
        if (this.decodeError == null) {
            return false;
        }
        return !this.decodeError.isEmpty();
    }

    public List<DecodeErrorInfo> getDecodeErrorList() {
        if (!this.hasDecodeError()) {
            return EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.decodeError);
    }

    public CharSequence getRawContent() {
        return this.rawContent;
    }

    public void setCharAt(int index, char ch) throws IndexOutOfBoundsException {
        this.rawContent.setCharAt(index, ch);
    }

    @Override
    public char charAt(int index) {
        return this.rawContent.charAt(index);
    }

    @Override
    public int length() {
        return this.rawContent.length();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.rawContent.subSequence(start, end);
    }

    public DecodedContent subContent(int start, int end) throws IndexOutOfBoundsException {
        int length = end - start;
        if (length < 0) {
            throw new IndexOutOfBoundsException();
        }
        DecodedContent result = new DecodedContent(length);
        result.append(this, start, end);
        return result;
    }

    @Override
    public DecodedContent append(char letter) {
        this.rawContent.append(letter);
        return this;
    }

    @Override
    public DecodedContent append(CharSequence seq) {
        if (seq == null) {
            this.rawContent.append(NULLTEXT);
        } else if (seq instanceof DecodedContent) {
            this.append((DecodedContent)seq, 0, seq.length());
        } else {
            this.rawContent.append(seq);
        }
        return this;
    }

    @Override
    public DecodedContent append(CharSequence seq, int startPos, int endPos) throws IndexOutOfBoundsException {
        if (seq == null) {
            this.rawContent.append(NULLTEXT, startPos, endPos);
        } else if (seq instanceof DecodedContent) {
            this.append((DecodedContent)seq, startPos, endPos);
        } else {
            this.rawContent.append(seq, startPos, endPos);
        }
        return this;
    }

    public DecodedContent append(DecodedContent source, int startPos, int endPos) throws IndexOutOfBoundsException {
        if (source == null) {
            return this.append(NULLTEXT, startPos, endPos);
        }
        int gap = startPos - this.rawContent.length();
        this.rawContent.append(source.rawContent, startPos, endPos);
        if (!source.hasDecodeError()) {
            return this;
        }
        List<DecodeErrorInfo> targetErrorList = source != this ? this.decodeError : null;
        if ((targetErrorList = DecodedContent.appendGappedErrorInfo(source, startPos, endPos, targetErrorList, gap)) == null) {
            return this;
        }
        if (targetErrorList == this.decodeError) {
            return this;
        }
        if (this.decodeError == null) {
            this.decodeError = targetErrorList;
        } else {
            this.decodeError.addAll(targetErrorList);
        }
        return this;
    }

    private void addDecodeError(DecodeErrorInfo errorInfo) {
        if (this.decodeError == null) {
            this.decodeError = DecodedContent.createErrorList();
        }
        this.decodeError.add(errorInfo);
        this.rawContent.append('?');
    }

    public void addDecodeError(byte b1st) {
        DecodeErrorInfo errInfo = new DecodeErrorInfo(this.rawContent.length(), b1st);
        this.addDecodeError(errInfo);
    }

    public void addDecodeError(byte b1st, byte b2nd) {
        DecodeErrorInfo errInfo = new DecodeErrorInfo(this.rawContent.length(), b1st, b2nd);
        this.addDecodeError(errInfo);
    }

    @Override
    public String toString() {
        return this.rawContent.toString();
    }

    static {
        assert (DecodedContent.createErrorList() instanceof RandomAccess);
    }
}

