/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jovsonz;

import java.io.IOException;
import jp.sourceforge.jovsonz.JsBoolean;
import jp.sourceforge.jovsonz.JsNumber;
import jp.sourceforge.jovsonz.JsString;
import jp.sourceforge.jovsonz.JsValue;

public class JsPair {
    private final String name;
    private final JsValue value;

    public JsPair(String name, JsValue value) throws NullPointerException {
        if (name == null || value == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.value = value;
    }

    public JsPair(String name, CharSequence text) throws NullPointerException {
        this(name, new JsString(text));
    }

    public JsPair(String name, boolean bool) throws NullPointerException {
        this(name, JsBoolean.valueOf(bool));
    }

    public JsPair(String name, long number) throws NullPointerException {
        this(name, new JsNumber(number));
    }

    public JsPair(String name, double number) throws NullPointerException {
        this(name, new JsNumber(number));
    }

    public String getName() {
        return this.name;
    }

    public JsValue getValue() {
        return this.value;
    }

    public int hashCode() {
        int nameHash = this.name.hashCode();
        int valHash = this.value.hashCode();
        return nameHash ^ valHash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JsPair)) {
            return false;
        }
        JsPair target = (JsPair)obj;
        if (!this.name.equals(target.name)) {
            return false;
        }
        return this.value.equals(target.value);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        try {
            JsString.dumpString(result, this.name);
        }
        catch (IOException e) {
            assert (false);
            throw new AssertionError((Object)e);
        }
        result.append(':').append(this.value.toString());
        return result.toString();
    }
}

