/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.NavigationFilter;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import jp.sfjp.jindolf.dxchg.TextPopup;
import jp.sfjp.jindolf.editor.BalloonBorder;
import jp.sfjp.jindolf.editor.TextEditor;

public class TalkEditor
extends JPanel
implements DocumentListener {
    private static final int MAX_CHARS = 200;
    private static final int MAX_LINES = 10;
    private static final Color COLOR_ACTIVATED = Color.GRAY;
    private final PlainDocument document = new PlainDocument();
    private int sequenceNumber;
    private boolean isActive = false;
    private final JLabel seqCount = new JLabel();
    private final JLabel talkStat = new JLabel();
    private final TextEditor textEditor = new TextEditor();
    private Font textFont;

    public TalkEditor() {
        this(0);
    }

    private TalkEditor(int seqNumber) {
        this.setOpaque(true);
        this.document.addDocumentListener(this);
        this.seqCount.setForeground(Color.WHITE);
        this.talkStat.setForeground(Color.WHITE);
        this.seqCount.setOpaque(false);
        this.talkStat.setOpaque(false);
        this.textEditor.setMargin(new Insets(3, 3, 3, 3));
        this.textEditor.setDocument(this.document);
        TextPopup popup = new TextPopup();
        this.textEditor.setComponentPopupMenu(popup);
        this.textFont = this.textEditor.getFont();
        this.setSequenceNumber(seqNumber);
        this.updateStat();
        this.setActive(false);
        this.design();
    }

    public static int choplimit(CharSequence source, int start) {
        char ch;
        int length = source.length();
        if (start >= length) {
            return 0;
        }
        int chars = 0;
        int lines = 0;
        for (int pos = start; pos < length && ++chars < 200 && ((ch = source.charAt(pos)) != '\n' || ++lines < 10); ++pos) {
        }
        return chars;
    }

    private void design() {
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        this.setLayout(layout);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 0, 1, 3);
        this.add((Component)this.seqCount, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 0, 0, 0);
        JComponent decorated = BalloonBorder.decorateTransparentBorder(this.textEditor);
        this.add((Component)decorated, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 12;
        constraints.insets = new Insets(0, 0, 0, 3);
        this.add((Component)this.talkStat, constraints);
        Border border = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.setBorder(border);
    }

    public void setTextFont(Font textFont) {
        this.textFont = textFont;
        this.textEditor.setFont(this.textFont);
        this.textEditor.repaint();
        this.revalidate();
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void setNavigationFilter(NavigationFilter navigator) {
        this.textEditor.setNavigationFilter(navigator);
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(int seqNumber) {
        this.sequenceNumber = seqNumber;
        String seqText = "=== #" + this.sequenceNumber + " ===";
        this.seqCount.setText(seqText);
    }

    public Document getDocument() {
        return this.document;
    }

    public String getText() {
        String result;
        block2: {
            int length = this.document.getLength();
            result = "";
            try {
                result = this.document.getText(0, length);
            }
            catch (BadLocationException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return result;
    }

    public int getTextLength() {
        return this.document.getLength();
    }

    private int getTextLines() {
        int lines = 0;
        Segment segment = new Segment();
        segment.setPartialReturn(true);
        boolean hasLineContents = false;
        int pos = 0;
        for (int remain = this.getTextLength(); remain > 0; remain -= segment.count) {
            char ch;
            block8: {
                try {
                    this.document.getText(pos, remain, segment);
                }
                catch (BadLocationException e) {
                    if ($assertionsDisabled) break block8;
                    throw new AssertionError();
                }
            }
            while ((ch = segment.current()) != '\uffff') {
                if (ch == '\n') {
                    if (!hasLineContents) {
                        ++lines;
                    }
                    hasLineContents = false;
                } else if (!hasLineContents) {
                    hasLineContents = true;
                    ++lines;
                }
                segment.next();
            }
            pos += segment.count;
        }
        return lines;
    }

    public void appendHead(CharSequence text) {
        block4: {
            if (text == null) {
                return;
            }
            if (text.length() <= 0) {
                return;
            }
            try {
                this.document.insertString(0, text.toString(), null);
            }
            catch (BadLocationException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    public void appendTail(CharSequence text) {
        block4: {
            if (text == null) {
                return;
            }
            if (text.length() <= 0) {
                return;
            }
            int offset = this.getTextLength();
            try {
                this.document.insertString(offset, text.toString(), null);
            }
            catch (BadLocationException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    public void chopHead(int chopLength) {
        block3: {
            if (chopLength <= 0) {
                return;
            }
            int textLength = this.getTextLength();
            int modLength = chopLength > textLength ? textLength : chopLength;
            try {
                this.document.remove(0, modLength);
            }
            catch (BadLocationException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    public void clearText() {
        block2: {
            int textLength = this.document.getLength();
            try {
                this.document.remove(0, textLength);
            }
            catch (BadLocationException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public void setActive(boolean isActiveArg) {
        this.isActive = isActiveArg;
        if (this.isActive) {
            this.setOpaque(true);
            this.setBackground(COLOR_ACTIVATED);
            Dimension size = this.getSize();
            Rectangle bounds = new Rectangle(size);
            this.scrollRectToVisible(bounds);
            this.textEditor.scrollCaretToVisible();
        } else {
            this.setOpaque(false);
        }
        this.repaint();
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean onIMEoperation() {
        boolean result = this.textEditor.onIMEoperation();
        return result;
    }

    public int getCaretPosition() {
        int caretPos = this.textEditor.getCaretPosition();
        return caretPos;
    }

    public void setCaretPosition(int pos) throws IllegalArgumentException {
        this.textEditor.setCaretPosition(pos);
    }

    private void updateStat() {
        if (this.onIMEoperation()) {
            return;
        }
        int charTotal = this.getTextLength();
        int lineNumber = this.getTextLines();
        StringBuilder statistics = new StringBuilder();
        statistics.append(charTotal).append("\u5b57 ").append(lineNumber).append("\u884c");
        this.talkStat.setText(statistics.toString());
    }

    public String chopRest() {
        String rest;
        block3: {
            int choppedlen;
            String text = this.getText();
            int textLength = this.getTextLength();
            int restLength = textLength - (choppedlen = TalkEditor.choplimit(text, 0));
            if (restLength <= 0) {
                return null;
            }
            rest = null;
            try {
                rest = this.document.getText(choppedlen, restLength);
                this.document.remove(choppedlen, restLength);
            }
            catch (BadLocationException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
        return rest;
    }

    public boolean requestEditorFocus() {
        boolean result = this.textEditor.requestFocusInWindow();
        return result;
    }

    public boolean hasEditorFocus() {
        boolean result = this.textEditor.hasFocus();
        return result;
    }

    public void addTextFocusListener(FocusListener listener) {
        this.textEditor.addFocusListener(listener);
    }

    public void removeTextFocusListener(FocusListener listener) {
        this.textEditor.removeFocusListener(listener);
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
        this.updateStat();
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.updateStat();
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this.updateStat();
    }
}

