/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.glyph;

import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import jp.sfjp.jindolf.glyph.FontListModel;

public class FontSelectList
extends JList<String>
implements ListDataListener {
    private String selectedFamily = null;

    public FontSelectList() {
        FontListModel fontListModel = new FontListModel();
        this.setModelImpl(fontListModel);
        this.setVisibleRowCount(-1);
        this.setSelectionMode(0);
    }

    private void setModelImpl(ListModel<String> model) {
        ListModel oldModel = this.getModel();
        if (oldModel != null) {
            oldModel.removeListDataListener(this);
        }
        model.addListDataListener(this);
        super.setModel(model);
    }

    @Override
    public void setModel(ListModel<String> model) {
        this.setModelImpl(model);
    }

    public void setSelectedFamily(String family) {
        this.selectedFamily = family;
        this.reSelectFamily();
    }

    public String getSelectedFamily() {
        Object selected = this.getSelectedValue();
        if (selected == null) {
            return null;
        }
        String result = selected.toString();
        return result;
    }

    private void reSelectFamily() {
        boolean shouldScroll = true;
        this.setSelectedValue(this.selectedFamily, shouldScroll);
    }

    @Override
    public void contentsChanged(ListDataEvent event) {
        this.reSelectFamily();
    }

    @Override
    public void intervalAdded(ListDataEvent event) {
        this.reSelectFamily();
    }

    @Override
    public void intervalRemoved(ListDataEvent event) {
        this.reSelectFamily();
    }
}

